/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.ejs.highlight.EjsSyntaxHighlighterColors;
import com.jetbrains.lang.ejs.psi.EjsPsiBraces;
import com.jetbrains.lang.ejs.psi.EjsPsiCloseBrace;
import com.jetbrains.lang.ejs.psi.EjsPsiOpenBrace;
import org.jetbrains.annotations.NotNull;

public final class EjsColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            EjsColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            EjsColorAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof EjsPsiBraces) {
            EjsPsiOpenBrace openBrace = ((EjsPsiBraces)element).getOpenBrace();
            EjsPsiCloseBrace closeBrace = ((EjsPsiBraces)element).getCloseBrace();
            if (openBrace == null) {
                return;
            }
            IElementType openBraceTokenType = openBrace.getTokenType();
            String colorKey = EjsSyntaxHighlighterColors.findBraceKeyByElementType(openBraceTokenType);
            if (colorKey == null) {
                return;
            }
            TextAttributesKey attributesKey = TextAttributesKey.find((String)colorKey);
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)openBrace).textAttributes(attributesKey).create();
            if (closeBrace != null) {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)closeBrace).textAttributes(attributesKey).create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/lang/ejs/annotator/EjsColorAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

