/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.file.EjsFileViewProvider;
import com.jetbrains.lang.ejs.psi.EjsPsiBraces;
import com.jetbrains.lang.ejs.psi.EjsPsiElement;
import com.jetbrains.lang.ejs.psi.EjsPsiOpenBrace;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import com.jetbrains.lang.ejs.util.EjsUtils;
import org.jetbrains.annotations.NotNull;

public final class EjsTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        FileViewProvider provider;
        if (project == null) {
            EjsTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EjsTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EjsTypedHandler.$$$reportNull$$$0(2);
        }
        if (!((provider = file.getViewProvider()) instanceof EjsFileViewProvider)) {
            TypedHandlerDelegate.Result result = super.charTyped(c, project, editor, file);
            if (result == null) {
                EjsTypedHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset > editor.getDocument().getTextLength()) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                EjsTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        Couple<String> delimiters = EjsUtils.getDelimiters(project);
        int openBraceLength = ((String)delimiters.first).length();
        if (offset < openBraceLength) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                EjsTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        String previousChars = editor.getDocument().getText(new TextRange(offset - openBraceLength, offset));
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        if (((String)delimiters.first).equals(previousChars) && !EjsTypedHandler.hasClosingBrace(project, editor, provider, offset - openBraceLength / 2)) {
            editor.getDocument().insertString(offset, (CharSequence)delimiters.second);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            EjsTypedHandler.$$$reportNull$$$0(6);
        }
        return result;
    }

    private static boolean hasClosingBrace(Project project, Editor editor, FileViewProvider provider, int offset) {
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        EjsPsiElement elementAt = (EjsPsiElement)PsiTreeUtil.getParentOfType((PsiElement)provider.findElementAt(offset, (Language)EjsLanguage.INSTANCE), EjsPsiElement.class);
        PsiElement parent = elementAt != null ? elementAt.getParent() : null;
        return parent instanceof EjsPsiBraces && ((EjsPsiBraces)parent).getOpenBrace() == elementAt && !EjsTypedHandler.containsUnbalancedOpenBrace((EjsPsiBraces)parent);
    }

    private static boolean containsUnbalancedOpenBrace(EjsPsiBraces braces) {
        EjsPsiOpenBrace currentChild = braces.getOpenBrace();
        if (currentChild == null) {
            return false;
        }
        while ((currentChild = currentChild.getNextSibling()) != null) {
            if (!(currentChild instanceof EjsPsiElement) || !EjsTokenTypes.OPEN_BRACES.contains(((EjsPsiElement)currentChild).getTokenType())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/ejs/editor/EjsTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/ejs/editor/EjsTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

