/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.file;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.EjsIcons;
import com.jetbrains.lang.ejs.EjsLanguage;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EjsFileType
extends LanguageFileType
implements TemplateLanguageFileType {
    public static final LanguageFileType INSTANCE = new EjsFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "ejs";

    private EjsFileType() {
        super((Language)EjsLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "EJS";
    }

    @NotNull
    public String getDescription() {
        String string = EjsBundle.message("filetype.ejs.description", new Object[0]);
        if (string == null) {
            EjsFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return EjsIcons.EJS;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        LanguageFileType associatedFileType;
        if (content == null) {
            EjsFileType.$$$reportNull$$$0(1);
        }
        if ((associatedFileType = EjsFileType.getAssociatedFileType(file, project)) == null) {
            return null;
        }
        return CharsetUtil.extractCharsetFromFileContent((Project)project, (VirtualFile)file, (FileType)associatedFileType, (CharSequence)content);
    }

    private static LanguageFileType getAssociatedFileType(VirtualFile file, Project project) {
        if (project == null) {
            return null;
        }
        Language language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(file);
        LanguageFileType associatedFileType = null;
        if (language != null) {
            associatedFileType = language.getAssociatedFileType();
        }
        if (language == null || associatedFileType == null) {
            associatedFileType = EjsLanguage.getDefaultTemplateLang();
        }
        return associatedFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/ejs/file/EjsFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/ejs/file/EjsFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

