/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.lang.ejs.EjsBundle;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.formatter.settings.EjsCustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public final class EjsLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final String SPACING_CODE_SAMPLE = "<%# all syntax features %>\n<% if (title) { %>\n    <h1><%= title %></h1>\n<% } %>\n<p><%=: users | map:'name' | join %></p>\n<ul>\n    <li>Escaped value <%= value %></li>\n    <li>Unescaped value <%== value %></li>\n    <li>Generated escaped tag <%%= value %></li>\n</ul>";

    @NotNull
    public Language getLanguage() {
        EjsLanguage ejsLanguage = EjsLanguage.INSTANCE;
        if (ejsLanguage == null) {
            EjsLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return ejsLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            EjsLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS ? SPACING_CODE_SAMPLE : null;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            EjsLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            EjsLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        super.customizeSettings(consumer, settingsType);
        if (settingsType != LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return;
        }
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_BRACES", EjsBundle.message("ejs.style.spaces.within.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_EQ_BRACES", EjsBundle.message("ejs.style.spaces.within.eq.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_EQ_EQ_BRACES", EjsBundle.message("ejs.style.spaces.within.eq.eq.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_EQ_GENERATE_BRACES", EjsBundle.message("ejs.style.spaces.within.eq.generate.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_FILTER", EjsBundle.message("ejs.style.spaces.within.filter.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_BEFORE_COLON", EjsBundle.message("ejs.style.spaces.before.colon", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_AFTER_COLON", EjsBundle.message("ejs.style.spaces.after.colon", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "SPACES_WITHIN_CHAIN", EjsBundle.message("ejs.style.spaces.within.chain", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
        consumer.showCustomOption(EjsCustomCodeStyleSettings.class, "INDENT_CONTROL_BLOCKS", EjsBundle.message("ejs.style.intents.for.control.blocks", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/ejs/formatter/settings/EjsLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/ejs/formatter/settings/EjsLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

