/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementInteractivity;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssNavigableDescriptor;
import com.intellij.psi.css.impl.CssCustomPropertyAtRuleImpl;
import com.intellij.psi.css.impl.CssDeclarationImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssEscapeUtil;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssVendorSpecificPropertyUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssCompletionUtil {
    public static final int CSS_SELECTOR_SUFFIX_PRIORITY = 20;
    public static final int CSS_SELECTOR_SUFFIX_FROM_HTML_PRIORITY = 10;
    public static final int CSS_KEYWORDS_PRIORITY = 20;
    public static final int CSS_PSEUDO_SELECTOR_PRIORITY = 10;
    public static final int CSS_PROPERTY_NAME_PRIORITY = 10;
    public static final int CSS_CUSTOM_PROPERTY_DECLARATION_PRIORITY = 9;
    public static final int CSS_PROPERTY_VALUE_PRIORITY = 50;
    private static final InsertHandler<LookupElement> SELECTOR_SUFFIX_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            PsiElement element;
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((element = item.getPsiElement()) instanceof CssSelectorSuffix) {
                Document document = context.getDocument();
                int startOffset = context.getStartOffset();
                int tailOffset = context.getTailOffset();
                if (0 <= startOffset && startOffset < document.getTextLength() && 0 <= tailOffset && tailOffset < document.getTextLength()) {
                    document.replaceString(startOffset, tailOffset, (CharSequence)item.getLookupString());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/util/CssCompletionUtil$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public static LookupElement lookupForSelectorSuffix(@NotNull String name, @NotNull CssSelectorSuffix selectorSuffix, @NotNull PsiElement navigationElement, @Nullable PsiFile contextFile) {
        if (name == null) {
            CssCompletionUtil.$$$reportNull$$$0(0);
        }
        if (selectorSuffix == null) {
            CssCompletionUtil.$$$reportNull$$$0(1);
        }
        if (navigationElement == null) {
            CssCompletionUtil.$$$reportNull$$$0(2);
        }
        String lookupString = contextFile instanceof StylesheetFile ? CssEscapeUtil.escapeSpecialCssChars(name) : name;
        LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)navigationElement).withPresentableText(name).withInsertHandler(SELECTOR_SUFFIX_INSERT_HANDLER);
        ItemPresentation presentation = selectorSuffix.getPresentation();
        assert (presentation != null);
        if (selectorSuffix != navigationElement) {
            presentation = new CssNamedItemPresentation.WithCustomContext(presentation, navigationElement);
        }
        int priority = 20;
        PsiFile containingFile = navigationElement.getContainingFile();
        if (contextFile == containingFile) {
            priority += 10;
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withIcon(presentation.getIcon(false)).withTypeText(presentation.getLocationString()), (double)priority);
        if (lookupElement == null) {
            CssCompletionUtil.$$$reportNull$$$0(3);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type, @Nullable PsiFile contextFile, @Nullable VirtualFile containingFile, @NotNull Project project) {
        if (name == null) {
            CssCompletionUtil.$$$reportNull$$$0(4);
        }
        if (type == null) {
            CssCompletionUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CssCompletionUtil.$$$reportNull$$$0(6);
        }
        return CssCompletionUtil.lookupForSelectorSuffixFromHtml(name, type, contextFile, containingFile, project, 0);
    }

    @NotNull
    public static LookupElement lookupForSelectorSuffixFromHtml(@NotNull String name, @NotNull CssSelectorSuffixType type, @Nullable PsiFile contextFile, @Nullable VirtualFile containingFile, @Nullable Project project, int extraPriority) {
        if (name == null) {
            CssCompletionUtil.$$$reportNull$$$0(7);
        }
        if (type == null) {
            CssCompletionUtil.$$$reportNull$$$0(8);
        }
        String lookupString = contextFile instanceof StylesheetFile ? CssEscapeUtil.escapeSpecialCssChars(name) : name;
        LookupElementBuilder builder = LookupElementBuilder.create((String)lookupString).withPresentableText(name).withIcon(type.getIcon()).withTypeText(containingFile != null ? CssCompletionUtil.getContainingFileText(containingFile, project) : "from html").withInsertHandler(SELECTOR_SUFFIX_INSERT_HANDLER);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder, (double)(10 + extraPriority));
        if (lookupElement == null) {
            CssCompletionUtil.$$$reportNull$$$0(9);
        }
        return lookupElement;
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString) {
        if (lookupString == null) {
            CssCompletionUtil.$$$reportNull$$$0(10);
        }
        return CssCompletionUtil.lookupForKeyword(lookupString, null, null);
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (lookupString == null) {
            CssCompletionUtil.$$$reportNull$$$0(11);
        }
        return CssCompletionUtil.lookupForKeyword(lookupString, insertHandler, LookupElementInteractivity.NEVER);
    }

    public static LookupElement lookupForKeyword(@NotNull String lookupString, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementInteractivity interactivity) {
        if (lookupString == null) {
            CssCompletionUtil.$$$reportNull$$$0(12);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)lookupString).bold().withInsertHandler(insertHandler);
        if (interactivity != null) {
            builder.putUserData(LookupElementInteractivity.KEY, (Object)interactivity);
        }
        return PrioritizedLookupElement.withPriority((LookupElement)builder, (double)20.0);
    }

    private static String getContainingFileText(@NotNull VirtualFile file, @Nullable Project project) {
        String relativePath;
        ProjectFileIndex index;
        VirtualFile rootForFile;
        if (file == null) {
            CssCompletionUtil.$$$reportNull$$$0(13);
        }
        if (project != null && (rootForFile = (index = ProjectRootManager.getInstance((Project)project).getFileIndex()).getContentRootForFile(file)) != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)rootForFile, (char)File.separatorChar)) != null) {
            return relativePath;
        }
        return file.getName();
    }

    @NotNull
    public static CompletionResultSet fixPrefixForVendorPrefixes(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, IElementType ... typesToFix) {
        PsiElement position;
        IElementType type;
        if (parameters == null) {
            CssCompletionUtil.$$$reportNull$$$0(14);
        }
        if (result == null) {
            CssCompletionUtil.$$$reportNull$$$0(15);
        }
        if (typesToFix == null) {
            CssCompletionUtil.$$$reportNull$$$0(16);
        }
        if (CssElementTypes.NAME_TOKEN_TYPES.contains(type = (position = parameters.getPosition()).getNode().getElementType()) || type == CssElementTypes.CSS_ATKEYWORD || TokenSet.create((IElementType[])typesToFix).contains(type)) {
            String positionText = position.getText();
            int prefixShift = parameters.getOffset() - position.getTextRange().getStartOffset();
            if (0 < prefixShift && prefixShift < positionText.length()) {
                CompletionResultSet completionResultSet = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(positionText.substring(0, prefixShift)));
                if (completionResultSet == null) {
                    CssCompletionUtil.$$$reportNull$$$0(17);
                }
                return completionResultSet;
            }
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            CssCompletionUtil.$$$reportNull$$$0(18);
        }
        return completionResultSet;
    }

    @NotNull
    public static CompletionResultSet fixPrefixForCustomPropertyAtRuleSyntaxValue(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement element;
        if (parameters == null) {
            CssCompletionUtil.$$$reportNull$$$0(19);
        }
        if (result == null) {
            CssCompletionUtil.$$$reportNull$$$0(20);
        }
        if (CssCompletionUtil.isCustomPropertyAtRuleSyntaxProperty(element = parameters.getPosition())) {
            String positionText = element.getText();
            int prefixShift = parameters.getOffset() - element.getTextRange().getStartOffset();
            CompletionResultSet completionResultSet = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(positionText.substring(0, prefixShift)));
            if (completionResultSet == null) {
                CssCompletionUtil.$$$reportNull$$$0(21);
            }
            return completionResultSet;
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            CssCompletionUtil.$$$reportNull$$$0(22);
        }
        return completionResultSet;
    }

    @NotNull
    public static Collection<LookupElement> lookupItemsForDescriptors(@NotNull Collection<? extends CssElementDescriptor> descriptors, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        if (descriptors == null) {
            CssCompletionUtil.$$$reportNull$$$0(23);
        }
        return CssCompletionUtil.lookupItemsForDescriptors(descriptors, insertHandler, CssDescriptorsUtil.GET_DESCRIPTOR_ID_FUNCTION, priority);
    }

    @NotNull
    public static Collection<LookupElement> lookupItemsForDescriptors(@NotNull Collection<? extends CssElementDescriptor> descriptors, @Nullable InsertHandler<LookupElement> insertHandler, @NotNull NotNullFunction<? super CssElementDescriptor, String> extractLookupStringFunction, int priority) {
        if (descriptors == null) {
            CssCompletionUtil.$$$reportNull$$$0(24);
        }
        if (extractLookupStringFunction == null) {
            CssCompletionUtil.$$$reportNull$$$0(25);
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        MultiMap map = MultiMap.create();
        for (CssElementDescriptor cssElementDescriptor : descriptors) {
            map.putValue((Object)cssElementDescriptor.getId(), (Object)cssElementDescriptor);
        }
        for (Map.Entry entry : map.entrySet()) {
            CssElementDescriptor descriptor = CssCompositeElementDescriptor.create((Collection)entry.getValue());
            if (descriptor == null) continue;
            result.add(CssCompletionUtil.lookupItemForDescriptor((String)extractLookupStringFunction.fun((Object)descriptor), descriptor, insertHandler, priority));
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            CssCompletionUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    public static LookupElement lookupItemForDescriptor(@NotNull CssElementDescriptor descriptor, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        if (descriptor == null) {
            CssCompletionUtil.$$$reportNull$$$0(27);
        }
        return CssCompletionUtil.lookupItemForDescriptor(descriptor.getId(), descriptor, insertHandler, priority);
    }

    @NotNull
    public static LookupElement lookupItemForDescriptor(@NotNull String lookupString, @NotNull CssElementDescriptor descriptor, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        String typeText;
        PsiElement element;
        if (lookupString == null) {
            CssCompletionUtil.$$$reportNull$$$0(28);
        }
        if (descriptor == null) {
            CssCompletionUtil.$$$reportNull$$$0(29);
        }
        PsiElement psiElement = element = descriptor instanceof CssNavigableDescriptor ? ((CssNavigableDescriptor)descriptor).getElement() : null;
        if (element != null) {
            ItemPresentation presentation = element instanceof NavigationItem ? ((NavigationItem)element).getPresentation() : null;
            typeText = presentation == null ? null : presentation.getLocationString();
        } else {
            typeText = null;
        }
        PsiElement lookupObject = descriptor instanceof CssNavigableDescriptor ? ((CssNavigableDescriptor)descriptor).getElement() : null;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)ObjectUtils.notNull((Object)lookupObject, (Object)descriptor), (String)lookupString).withIcon(descriptor.getIcon()).withTailText(CssCompletionUtil.descriptorTailText(descriptor), true).withTypeText(typeText, true).withInsertHandler(insertHandler);
        if (CssVendorSpecificPropertyUtil.isVendorSpecificElement(descriptor.getId()) || descriptor.getCssVersion() == CssElementDescriptor.CssVersion.UNKNOWN || descriptor.getId().equals("widows")) {
            --priority;
        }
        if (descriptor.getId().startsWith("mso-")) {
            priority -= 2;
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElementBuilder, (double)priority);
        if (lookupElement == null) {
            CssCompletionUtil.$$$reportNull$$$0(30);
        }
        return lookupElement;
    }

    private static String descriptorTailText(@NotNull CssElementDescriptor descriptor) {
        if (descriptor == null) {
            CssCompletionUtil.$$$reportNull$$$0(31);
        }
        if (descriptor instanceof CssFunctionDescriptor) {
            CssParameterInfoValueDescriptorsVisitor messageBuilder = new CssParameterInfoValueDescriptorsVisitor(null, true, false);
            ((CssFunctionDescriptor)descriptor).getValueDescriptor().accept(messageBuilder);
            return "(" + StringUtil.unescapeXmlEntities((String)messageBuilder.getParameterInfo()) + ")";
        }
        return null;
    }

    public static boolean isCustomPropertyAtRuleSyntaxProperty(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        String propertyName = null;
        PsiElement declarationParent = PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclarationImpl.class);
        if (declarationParent != null && declarationParent.getFirstChild() != null) {
            propertyName = declarationParent.getFirstChild().getText();
        }
        return type == CssElementTypes.CSS_STRING_TOKEN && propertyName != null && propertyName.equals("syntax") && PsiTreeUtil.getParentOfType((PsiElement)element, CssCustomPropertyAtRuleImpl.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 17, 18, 21, 22, 26, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorSuffix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
            case 3: 
            case 9: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/util/CssCompletionUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToFix";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractLookupStringFunction";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/util/CssCompletionUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupForSelectorSuffix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupForSelectorSuffixFromHtml";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fixPrefixForVendorPrefixes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fixPrefixForCustomPropertyAtRuleSyntaxValue";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupItemsForDescriptors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupItemForDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lookupForSelectorSuffix";
                break;
            }
            case 3: 
            case 9: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 26: 
            case 30: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lookupForSelectorSuffixFromHtml";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lookupForKeyword";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFileText";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fixPrefixForVendorPrefixes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fixPrefixForCustomPropertyAtRuleSyntaxValue";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lookupItemsForDescriptors";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lookupItemForDescriptor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "descriptorTailText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 17, 18, 21, 22, 26, 30 -> new IllegalStateException(string);
        };
    }
}

