/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.codeinsight;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public final class GherkinTypedHandler
extends TypedHandlerDelegate {
    public static final char PIPE = '|';

    @Nullable
    private static GherkinTable getTable(@NotNull PsiElement element) {
        if (element == null) {
            GherkinTypedHandler.$$$reportNull$$$0(0);
        }
        while (element != null && !(element instanceof GherkinTable)) {
            element = element.getParent();
        }
        return (GherkinTable)element;
    }

    @Nullable
    private static GherkinTableRow findCurrentRow(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiElement cursorElement;
        if (editor == null) {
            GherkinTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GherkinTypedHandler.$$$reportNull$$$0(2);
        }
        if ((cursorElement = file.findElementAt((offset = editor.getCaretModel().getOffset()) - 1)) == null) {
            return null;
        }
        GherkinTable element = GherkinTypedHandler.getTable(cursorElement);
        if (element == null) {
            if ((cursorElement = file.findElementAt(offset - cursorElement.getTextLength())) == null) {
                return null;
            }
            element = GherkinTypedHandler.getTable(cursorElement);
            if (element == null) {
                return null;
            }
        }
        GherkinTable table = element;
        int tableOffset = table.getTextOffset();
        int caretOffsetInParent = editor.getCaretModel().getOffset() - tableOffset;
        ArrayList<GherkinTableRow> rowList = new ArrayList<GherkinTableRow>();
        if (table.getHeaderRow() != null) {
            rowList.add(table.getHeaderRow());
        }
        rowList.addAll(table.getDataRows());
        for (int i = 0; i < rowList.size() - 1; ++i) {
            GherkinTableRow row = (GherkinTableRow)rowList.get(i);
            GherkinTableRow nextRow = (GherkinTableRow)rowList.get(i + 1);
            int start = row.getStartOffsetInParent();
            int end = start + row.getTextLength();
            if (start <= caretOffsetInParent && caretOffsetInParent <= end) {
                return row;
            }
            if (end >= caretOffsetInParent || caretOffsetInParent > nextRow.getStartOffsetInParent()) continue;
            return row;
        }
        return (GherkinTableRow)rowList.get(rowList.size() - 1);
    }

    @Nullable
    private static GherkinTableRow getPreviousRow(@NotNull GherkinTableRow currentRow) {
        PsiElement psiElement;
        if (currentRow == null) {
            GherkinTypedHandler.$$$reportNull$$$0(3);
        }
        if (currentRow.getParent() != null && (psiElement = currentRow.getParent()) instanceof GherkinTable) {
            GherkinTable table = (GherkinTable)psiElement;
            int i = table.getDataRows().indexOf(currentRow);
            if (i > 0) {
                return table.getDataRows().get(i - 1);
            }
            if (i == 0) {
                return table.getHeaderRow();
            }
        }
        return null;
    }

    private static int getColumnNumber(@NotNull GherkinTableRow row, int caretPosition) {
        if (row == null) {
            GherkinTypedHandler.$$$reportNull$$$0(4);
        }
        String rowText = row.getText();
        int length = Math.min(caretPosition, rowText.length());
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (rowText.charAt(i) != '|') continue;
            ++count;
        }
        return count - 1;
    }

    private static String getSpaceLine(int n) {
        char[] spaces = new char[n];
        Arrays.fill(spaces, ' ');
        return String.valueOf(spaces);
    }

    private static int getPreferredPipeOffset(@NotNull GherkinTableRow row, int columnNumber) {
        int i;
        if (row == null) {
            GherkinTypedHandler.$$$reportNull$$$0(5);
        }
        String rowText = row.getText();
        int passedPipeCount = 0;
        for (i = 0; i < rowText.length() && passedPipeCount - 2 < columnNumber; ++i) {
            if (rowText.charAt(i) != '|') continue;
            ++passedPipeCount;
        }
        return passedPipeCount - 2 == columnNumber ? i : -1;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        int cellNumber;
        int rightPosition;
        int offsetInParent;
        GherkinTableRow previousRow;
        GherkinTableRow currentRow;
        if (project == null) {
            GherkinTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GherkinTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GherkinTypedHandler.$$$reportNull$$$0(8);
        }
        if (fileType == null) {
            GherkinTypedHandler.$$$reportNull$$$0(9);
        }
        if (fileType.equals((Object)GherkinFileType.INSTANCE) && c == '|' && (currentRow = GherkinTypedHandler.findCurrentRow(editor, file)) != null && (previousRow = GherkinTypedHandler.getPreviousRow(currentRow)) != null && (offsetInParent = editor.getCaretModel().getOffset() - currentRow.getTextOffset()) < (rightPosition = GherkinTypedHandler.getPreferredPipeOffset(previousRow, cellNumber = GherkinTypedHandler.getColumnNumber(currentRow, offsetInParent))) - 1) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)GherkinTypedHandler.getSpaceLine(rightPosition - offsetInParent - 1));
        }
        TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result == null) {
            GherkinTypedHandler.$$$reportNull$$$0(10);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRow";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/codeinsight/GherkinTypedHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentRow";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousRow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNumber";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredPipeOffset";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

