/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinElementFactory;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinLanguage;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTag;
import org.jetbrains.plugins.cucumber.psi.GherkinUtil;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public final class ScenarioToOutlineIntention
implements IntentionAction {
    public static final String ARGUMENT = "argument";

    @NotNull
    public String getText() {
        String string = CucumberBundle.message("intention.convert.scenario.to.outline.name", new Object[0]);
        if (string == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CucumberBundle.message("intention.convert.scenario.to.outline.name", new Object[0]);
        if (string == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(2);
        }
        if (!(psiFile.getLanguage() instanceof GherkinLanguage)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = psiFile.findElementAt(offset);
        if (element == null) {
            return false;
        }
        GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinScenario.class);
        return scenario != null && ScenarioToOutlineIntention.canConvertScenario(scenario);
    }

    private static boolean canConvertScenario(GherkinScenario scenario) {
        if (scenario.isBackground()) {
            return false;
        }
        for (GherkinStep step : scenario.getSteps()) {
            if (step.getTable() == null && step.getPystring() == null) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(3);
        }
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getParentOfType((PsiElement)element, GherkinScenario.class);
        assert (scenario != null);
        assert (psiFile instanceof GherkinFile);
        String language = GherkinUtil.getFeatureLanguage((GherkinFile)psiFile);
        GherkinKeywordTable keywordsTable = JsonGherkinKeywordProvider.getKeywordProvider().getKeywordsTable(language);
        StringBuilder newScenarioText = new StringBuilder();
        for (GherkinTag tag : scenario.getTags()) {
            newScenarioText.append(tag.getName()).append(' ');
        }
        if (scenario.getTags().length > 0) {
            newScenarioText.append('\n');
        }
        newScenarioText.append(keywordsTable.getScenarioOutlineKeyword()).append(": ").append(scenario.getScenarioName());
        LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
        for (GherkinStep step : scenario.getSteps()) {
            AbstractStepDefinition definition;
            CucumberStepReference reference = CucumberUtil.getCucumberStepReference(step);
            AbstractStepDefinition abstractStepDefinition = definition = reference != null ? reference.resolveToDefinition() : null;
            if (definition != null) {
                String stepName = ScenarioToOutlineIntention.replaceVarNames(step.getName(), definition, examples);
                newScenarioText.append("\n").append(step.getKeyword().getText()).append(" ").append(stepName);
                continue;
            }
            newScenarioText.append("\n").append(step.getText());
        }
        newScenarioText.append("\n").append(ScenarioToOutlineIntention.buildExamplesSection(examples, keywordsTable.getExampleSectionKeyword()));
        GherkinStepsHolder newScenario = GherkinElementFactory.createScenarioFromText(project, language, newScenarioText.toString());
        scenario.replace(newScenario);
    }

    private static String replaceVarNames(String stepName, AbstractStepDefinition definition, Map<String, String> examples) {
        Pattern pattern;
        List<String> varNames = definition.getVariableNames();
        if (!varNames.isEmpty() && (pattern = definition.getPattern()) != null) {
            int offset = 0;
            Matcher matcher = pattern.matcher(stepName);
            if (matcher.matches()) {
                int groupCount = matcher.groupCount();
                for (int i = 0; i < groupCount; ++i) {
                    if (matcher.group(i + 1) == null) continue;
                    String name = i < varNames.size() ? varNames.get(i) : ARGUMENT;
                    name = ScenarioToOutlineIntention.uniqueName(name, examples, matcher.group(i + 1));
                    int start = matcher.start(i + 1);
                    int end = matcher.end(i + 1);
                    String referencedValue = "<" + name + ">";
                    stepName = StringUtil.replaceSubstring((String)stepName, (TextRange)new TextRange(start + offset, end + offset), (String)referencedValue);
                    offset += referencedValue.length() - (end - start);
                }
            }
        }
        return stepName;
    }

    private static String buildExamplesSection(Map<String, String> examples, String keyword) {
        StringBuilder builder = new StringBuilder(keyword);
        builder.append(":\n");
        if (!examples.isEmpty()) {
            for (String key : examples.keySet()) {
                builder.append("|").append(key);
            }
            builder.append("|\n");
            for (String key : examples.keySet()) {
                builder.append("|").append(examples.get(key));
            }
            builder.append("|\n");
        }
        return builder.toString();
    }

    private static String uniqueName(@NotNull String name, @NotNull Map<String, String> examples, @NotNull String value) {
        if (name == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(4);
        }
        if (examples == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(5);
        }
        if (value == null) {
            ScenarioToOutlineIntention.$$$reportNull$$$0(6);
        }
        Object candidate = name;
        int i = 1;
        while (examples.containsKey(candidate) && !examples.get(candidate).equals(value)) {
            candidate = name + i++;
        }
        examples.put((String)candidate, value);
        return candidate;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/intentions/ScenarioToOutlineIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "examples";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/intentions/ScenarioToOutlineIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uniqueName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

