/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import java.awt.GridBagConstraints;
import java.util.EnumSet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public final class GherkinStepRenameDialog
extends RenameDialog {
    private AbstractStepDefinition myStepDefinition;

    public GherkinStepRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(1);
        }
        super(project, psiElement, nameSuggestionContext, editor);
    }

    protected RenameProcessor createRenameProcessor(@NotNull String newName) {
        if (newName == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(2);
        }
        return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles());
    }

    protected String getFullName() {
        return CucumberBundle.message("cucumber.step", new Object[0]);
    }

    protected boolean areButtonsValid() {
        return true;
    }

    protected void createNewNameComponent() {
        super.createNewNameComponent();
        Runnable guardRunnable = () -> {
            Editor editor = this.getNameSuggestionsField().getEditor();
            if (editor != null) {
                editor.getSelectionModel().removeSelection();
                editor.getCaretModel().moveToOffset(0);
                Document document = editor.getDocument();
                EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(document, new ReadonlyFragmentModificationHandler(){

                    public void handle(ReadOnlyFragmentModificationException e) {
                    }
                });
                GherkinStepRenameDialog.guardRegexpSpecialSymbols(editor);
            }
        };
        SwingUtilities.invokeLater(guardRunnable);
    }

    private AbstractStepDefinition getStepDefinition() {
        CucumberStepReference ref;
        if (this.myStepDefinition == null && (ref = CucumberUtil.getCucumberStepReference(this.getPsiElement())) != null) {
            this.myStepDefinition = ref.resolveToDefinition();
        }
        return this.myStepDefinition;
    }

    private static void guardRegexpSpecialSymbols(@NotNull Editor editor) {
        if (editor == null) {
            GherkinStepRenameDialog.$$$reportNull$$$0(3);
        }
        String text = editor.getDocument().getText();
        RegExpLexer lexer = new RegExpLexer(EnumSet.noneOf(RegExpCapability.class));
        lexer.start((CharSequence)text);
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() != RegExpTT.CHARACTER) {
                editor.getDocument().createGuardedBlock(lexer.getTokenStart(), lexer.getTokenEnd());
            }
            lexer.advance();
        }
    }

    public String[] getSuggestedNames() {
        String result;
        AbstractStepDefinition stepDefinition = this.getStepDefinition();
        if (stepDefinition != null && (result = stepDefinition.getCucumberRegex()) != null) {
            result = StringUtil.trimStart((String)result, (String)"^");
            result = StringUtil.trimEnd((String)result, (String)"$");
            return new String[]{result};
        }
        return super.getSuggestedNames();
    }

    protected void processNewNameChanged() {
        this.getPreviewAction().setEnabled(true);
        this.getRefactorAction().setEnabled(true);
    }

    protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
        super.createCheckboxes(panel, gbConstraints);
        this.getCbSearchInComments().setVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/refactoring/rename/GherkinStepRenameDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "guardRegexpSpecialSymbols";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

