/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public final class GherkinStepRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof GherkinStep || PsiTreeUtil.getParentOfType((PsiElement)element, GherkinStep.class) != null;
    }

    @NotNull
    public static List<String> prepareRegexAndGetStaticTexts(@NotNull String source) {
        if (source == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder preparedRegexp = new StringBuilder();
        RegExpLexer lexer = new RegExpLexer(EnumSet.noneOf(RegExpCapability.class));
        lexer.start((CharSequence)source);
        IElementType previous = null;
        TokenSet toSkip = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.CHARACTER, RegExpTT.CARET, RegExpTT.DOLLAR, RegExpTT.REDUNDANT_ESCAPE});
        StringBuilder currentStaticText = new StringBuilder();
        boolean insideAddedGroup = false;
        Stack elementsWaitingToClose = new Stack();
        while (lexer.getTokenType() != null) {
            if (!toSkip.contains(lexer.getTokenType())) {
                if (!insideAddedGroup) {
                    insideAddedGroup = true;
                    preparedRegexp.append('(');
                    result.add(currentStaticText.toString());
                    currentStaticText = new StringBuilder();
                }
                if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN || lexer.getTokenType() == RegExpTT.NON_CAPT_GROUP) {
                    elementsWaitingToClose.push((Object)RegExpTT.GROUP_END);
                } else if (lexer.getTokenType() == RegExpTT.CLASS_BEGIN) {
                    elementsWaitingToClose.push((Object)RegExpTT.CLASS_END);
                } else if (!elementsWaitingToClose.isEmpty() && lexer.getTokenType() == elementsWaitingToClose.peek()) {
                    elementsWaitingToClose.pop();
                }
            } else if (elementsWaitingToClose.isEmpty()) {
                if (previous != null && previous != RegExpTT.CHARACTER && insideAddedGroup) {
                    insideAddedGroup = false;
                    preparedRegexp.append(')');
                }
                if (lexer.getTokenType() == RegExpTT.CHARACTER) {
                    currentStaticText.append(lexer.getTokenText());
                }
            }
            preparedRegexp.append(lexer.getTokenText());
            if (lexer.getTokenType() == RegExpTT.GROUP_BEGIN) {
                preparedRegexp.append("?:");
            }
            previous = lexer.getTokenType();
            lexer.advance();
        }
        if (insideAddedGroup) {
            preparedRegexp.append(')');
        }
        result.add(currentStaticText.toString());
        result.add(0, preparedRegexp.toString());
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static String getNewStepName(@NotNull String oldStepName, @NotNull Pattern oldStepDefPattern, @NotNull List<String> newStaticTexts) {
        Matcher matcher;
        if (oldStepName == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(3);
        }
        if (oldStepDefPattern == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(4);
        }
        if (newStaticTexts == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(5);
        }
        if ((matcher = oldStepDefPattern.matcher(oldStepName)).find()) {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < matcher.groupCount(); ++i) {
                values.add(matcher.group(i + 1));
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                result.append(newStaticTexts.get(i + 1));
                result.append((String)values.get(i));
            }
            result.append(newStaticTexts.get(newStaticTexts.size() - 1));
            String string = result.toString();
            if (string == null) {
                GherkinStepRenameProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = oldStepName;
        if (string == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        AbstractStepDefinition stepDefinition;
        CucumberStepReference reference;
        if (element == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(9);
        }
        if (usages == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(10);
        }
        if ((reference = CucumberUtil.getCucumberStepReference(element)) != null && (stepDefinition = reference.resolveToDefinition()) != null) {
            PsiElement elementToRename = stepDefinition.getElement();
            List<String> newStaticTexts = GherkinStepRenameProcessor.prepareRegexAndGetStaticTexts(newName);
            String oldStepDefPatternText = stepDefinition.getCucumberRegex();
            if (oldStepDefPatternText != null) {
                Pattern oldStepDefPattern = Pattern.compile(GherkinStepRenameProcessor.prepareRegexAndGetStaticTexts(oldStepDefPatternText).get(0));
                for (UsageInfo usage : usages) {
                    PsiElement possibleStep = usage.getElement();
                    if (!(possibleStep instanceof GherkinStep)) continue;
                    String oldStepName = ((GherkinStep)possibleStep).getName();
                    String newStepName = GherkinStepRenameProcessor.getNewStepName(oldStepName, oldStepDefPattern, newStaticTexts);
                    ((GherkinStep)possibleStep).setName(newStepName);
                }
                String prefix = oldStepDefPatternText.startsWith("^") ? "^" : "";
                String suffix = oldStepDefPatternText.endsWith("$") ? "$" : "";
                stepDefinition.setCucumberRegex(prefix + newName + suffix);
                if (listener != null && elementToRename != null) {
                    listener.elementRenamed(elementToRename);
                }
            }
        }
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(12);
        }
        List<PsiReference> list = Arrays.asList(element.getReferences());
        if (list == null) {
            GherkinStepRenameProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/refactoring/rename/GherkinStepRenameProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStepName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStepDefPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStaticTexts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/refactoring/rename/GherkinStepRenameProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRegexAndGetStaticTexts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewStepName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareRegexAndGetStaticTexts";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNewStepName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 13 -> new IllegalStateException(string);
        };
    }
}

