/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.extras.custom;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.components.DiagramNodeDeferredIconsEvaluator;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CommonDiagramExtras<T>
extends DiagramExtras<T> {
    public static final DiagramCategory SELECTION_MODE = new DiagramCategory(DiagramBundle.messagePointer("category.name.show.neighbours.of.selected.nodes", new Object[0]), AllIcons.Graph.NodeSelectionMode, false, true, true, true, false);
    public static final DiagramCategory BORDERS = new DiagramCategory(DiagramBundle.messagePointer("category.name.show.borders", new Object[0]), AllIcons.Graph.SnapToGrid, true, false, false);
    public static final DiagramCategory PATH_TO_ROOT = new DiagramCategory(DiagramBundle.messagePointer("category.name.show.paths.root.selection", new Object[0]), AllIcons.Hierarchy.Subtypes, false, true, true, true, false);

    @NotNull
    public JComponent createLabelNode(@NotNull DiagramNode<T> node, @NotNull DiagramBuilder builder2, @NotNull JPanel wrapper) {
        if (node == null) {
            CommonDiagramExtras.$$$reportNull$$$0(0);
        }
        if (builder2 == null) {
            CommonDiagramExtras.$$$reportNull$$$0(1);
        }
        if (wrapper == null) {
            CommonDiagramExtras.$$$reportNull$$$0(2);
        }
        this.setNodeBorders(node, builder2, wrapper);
        wrapper.setBackground(builder2.getColorScheme().getDefaultBackground());
        SimpleColoredComponent simpleColoredComponent = this.createLabel(builder2, node);
        if (simpleColoredComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(3);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public SimpleColoredComponent createLabel(@NotNull DiagramBuilder builder2, @NotNull DiagramNode<T> node) {
        if (builder2 == null) {
            CommonDiagramExtras.$$$reportNull$$$0(4);
        }
        if (node == null) {
            CommonDiagramExtras.$$$reportNull$$$0(5);
        }
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.setOpaque(false);
        label.setIconOpaque(false);
        label.setForeground(builder2.getColorScheme().getDefaultForeground());
        DiagramElementManager<?> manager = builder2.getProvider().getElementManager();
        SimpleColoredText presentableName = manager.getPresentableElementTitle(node.getIdentifyingElement(), builder2);
        if (presentableName != null) {
            presentableName.appendToComponent((ColoredTextContainer)label);
        }
        Icon icon = DiagramNodeDeferredIconsEvaluator.getInstance().registerEvaluationOrGetReadyIcon(node, evaluatedIcon -> label.setIcon(ScalableIconWrapper.wrap(evaluatedIcon)));
        label.setIcon(ScalableIconWrapper.wrap(icon));
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(6);
        }
        return simpleColoredComponent;
    }

    protected void setNodeBorders(@NotNull DiagramNode<T> node, @NotNull DiagramBuilder builder2, @NotNull JPanel wrapper) {
        if (node == null) {
            CommonDiagramExtras.$$$reportNull$$$0(7);
        }
        if (builder2 == null) {
            CommonDiagramExtras.$$$reportNull$$$0(8);
        }
        if (wrapper == null) {
            CommonDiagramExtras.$$$reportNull$$$0(9);
        }
        DiagramNodeContentManager nodeContentManager = builder2.getDataModel().getNodeContentManager();
        DiagramColorManager colorManager = builder2.getProvider().getColorManager();
        boolean isSelected = builder2.getGraph().isSelected(builder2.getNode(node));
        wrapper.setBorder(isSelected || nodeContentManager.isCategoryEnabled(BORDERS) ? JBUI.Borders.customLine((Color)colorManager.getNodeBorderColor(builder2, node, isSelected)) : JBUI.Borders.empty());
    }

    @Override
    public boolean isZoomAnimationsEnabled() {
        return true;
    }

    public static boolean isSelectionMode(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            CommonDiagramExtras.$$$reportNull$$$0(10);
        }
        DiagramNodeContentManager nodeContentManager = builder2.getDataModel().getNodeContentManager();
        return nodeContentManager.isCategoryEnabled(SELECTION_MODE);
    }

    public static boolean isPathToRootMode(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            CommonDiagramExtras.$$$reportNull$$$0(11);
        }
        DiagramNodeContentManager nodeContentManager = builder2.getDataModel().getNodeContentManager();
        return nodeContentManager.isCategoryEnabled(PATH_TO_ROOT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/extras/custom/CommonDiagramExtras";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/extras/custom/CommonDiagramExtras";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLabelNode";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setNodeBorders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionMode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPathToRootMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

