/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.graph.layout.ComponentLayouter;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.circular.CircularLayouter;
import com.intellij.openapi.graph.layout.circular.SingleCycleLayouter;
import com.intellij.openapi.graph.layout.genealogy.FamilyTreeLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.IncrementalHierarchicLayouter;
import com.intellij.openapi.graph.layout.organic.OrganicLayouter;
import com.intellij.openapi.graph.layout.orthogonal.CompactOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.DirectedOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.OrthogonalGroupLayouter;
import com.intellij.openapi.graph.layout.radial.RadialLayouter;
import com.intellij.openapi.graph.layout.random.RandomLayouter;
import com.intellij.openapi.graph.layout.router.ChannelEdgeRouter;
import com.intellij.openapi.graph.layout.router.OrganicEdgeRouter;
import com.intellij.openapi.graph.layout.seriesparallel.SeriesParallelLayouter;
import com.intellij.openapi.graph.layout.tree.ARTreeLayouter;
import com.intellij.openapi.graph.layout.tree.BalloonLayouter;
import com.intellij.openapi.graph.layout.tree.GenericTreeLayouter;
import com.intellij.openapi.graph.layout.tree.HVTreeLayouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uml.utils.DiagramBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DiagramLayout {
    CUSTOM,
    COMPACT_ORTHOGONAL,
    COMPONENT,
    DIRECTED_ORTHOGONAL,
    HIERARCHIC,
    HIERARCHIC_COMPACT,
    ORTHOGONAL_GROUPS,
    CHANNEL,
    SERIES_PARALLEL,
    CIRCULAR,
    CIRCULAR_EDGE_BUNDLED,
    RADIAL,
    RADIAL_EDGE_BUNDLED,
    SINGLE_CYCLE,
    AR_TREE,
    BALLOON,
    BALLOON_EDGE_BUNDLED,
    FAMILY_TREE,
    GENERIC_TREE,
    HV_TREE,
    RANDOM,
    ORGANIC,
    ORGANIC_EDGE_BUNDLED;


    @NotNull
    public static DiagramLayout getDefault() {
        DiagramLayout diagramLayout = HIERARCHIC;
        if (diagramLayout == null) {
            DiagramLayout.$$$reportNull$$$0(0);
        }
        return diagramLayout;
    }

    @NotNull
    public static DiagramLayout getCurrentLayout(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            DiagramLayout.$$$reportNull$$$0(1);
        }
        GraphSettings graphSettings = builder2.getPresentationModel().getSettings();
        Layouter currentLayouter = graphSettings.getCurrentLayouter();
        Layouter customLayouter = builder2.getProvider().getExtras().getCustomLayouter(graphSettings, builder2.getProject());
        if (customLayouter != null && currentLayouter.getClass() == customLayouter.getClass()) {
            DiagramLayout diagramLayout = CUSTOM;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(2);
            }
            return diagramLayout;
        }
        return DiagramLayout.from(currentLayouter);
    }

    @NotNull
    public static DiagramLayout from(@NotNull Layouter layouter) {
        if (layouter == null) {
            DiagramLayout.$$$reportNull$$$0(3);
        }
        if (layouter instanceof CompactOrthogonalLayouter) {
            DiagramLayout diagramLayout = COMPACT_ORTHOGONAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(4);
            }
            return diagramLayout;
        }
        if (layouter instanceof ComponentLayouter) {
            DiagramLayout diagramLayout = COMPONENT;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(5);
            }
            return diagramLayout;
        }
        if (layouter instanceof DirectedOrthogonalLayouter) {
            DiagramLayout diagramLayout = DIRECTED_ORTHOGONAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(6);
            }
            return diagramLayout;
        }
        if (layouter instanceof HierarchicGroupLayouter) {
            DiagramLayout diagramLayout = HIERARCHIC;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(7);
            }
            return diagramLayout;
        }
        if (layouter instanceof IncrementalHierarchicLayouter) {
            DiagramLayout diagramLayout = HIERARCHIC_COMPACT;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(8);
            }
            return diagramLayout;
        }
        if (layouter instanceof OrthogonalGroupLayouter) {
            DiagramLayout diagramLayout = ORTHOGONAL_GROUPS;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(9);
            }
            return diagramLayout;
        }
        if (layouter instanceof ChannelEdgeRouter) {
            DiagramLayout diagramLayout = CHANNEL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(10);
            }
            return diagramLayout;
        }
        if (layouter instanceof SeriesParallelLayouter) {
            DiagramLayout diagramLayout = SERIES_PARALLEL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(11);
            }
            return diagramLayout;
        }
        if (layouter instanceof CircularLayouter) {
            DiagramLayout diagramLayout = ((CircularLayouter)layouter).getEdgeBundling().getDefaultBundleDescriptor().isBundled() ? CIRCULAR_EDGE_BUNDLED : CIRCULAR;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(12);
            }
            return diagramLayout;
        }
        if (layouter instanceof RadialLayouter) {
            DiagramLayout diagramLayout = ((RadialLayouter)layouter).getEdgeBundling().getDefaultBundleDescriptor().isBundled() ? RADIAL_EDGE_BUNDLED : RADIAL;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(13);
            }
            return diagramLayout;
        }
        if (layouter instanceof SingleCycleLayouter) {
            DiagramLayout diagramLayout = SINGLE_CYCLE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(14);
            }
            return diagramLayout;
        }
        if (layouter instanceof ARTreeLayouter) {
            DiagramLayout diagramLayout = AR_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(15);
            }
            return diagramLayout;
        }
        if (layouter instanceof BalloonLayouter) {
            DiagramLayout diagramLayout = BALLOON;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(16);
            }
            return diagramLayout;
        }
        if (layouter instanceof FamilyTreeLayouter) {
            DiagramLayout diagramLayout = FAMILY_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(17);
            }
            return diagramLayout;
        }
        if (layouter instanceof GenericTreeLayouter) {
            DiagramLayout diagramLayout = GENERIC_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(18);
            }
            return diagramLayout;
        }
        if (layouter instanceof HVTreeLayouter) {
            DiagramLayout diagramLayout = HV_TREE;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(19);
            }
            return diagramLayout;
        }
        if (layouter instanceof RandomLayouter) {
            DiagramLayout diagramLayout = RANDOM;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(20);
            }
            return diagramLayout;
        }
        if (layouter instanceof OrganicEdgeRouter) {
            DiagramLayout diagramLayout = ORGANIC_EDGE_BUNDLED;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(21);
            }
            return diagramLayout;
        }
        if (layouter instanceof OrganicLayouter) {
            DiagramLayout diagramLayout = ORGANIC;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(22);
            }
            return diagramLayout;
        }
        DiagramLayout diagramLayout = HIERARCHIC;
        if (diagramLayout == null) {
            DiagramLayout.$$$reportNull$$$0(23);
        }
        return diagramLayout;
    }

    @NotNull
    public Layouter getLayouter(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            DiagramLayout.$$$reportNull$$$0(24);
        }
        GraphSettings settings = builder2.getPresentationModel().getSettings();
        if (this == CUSTOM) {
            Layouter customLayouter = builder2.getProvider().getExtras().getCustomLayouter(settings, builder2.getProject());
            Layouter layouter = customLayouter != null ? customLayouter : GraphLayoutService.getInstance().getGroupLayouter();
            if (layouter == null) {
                DiagramLayout.$$$reportNull$$$0(25);
            }
            return layouter;
        }
        Layouter layouter = this.getPredefinedLayouter(settings);
        if (layouter == null) {
            DiagramLayout.$$$reportNull$$$0(26);
        }
        return layouter;
    }

    @NotNull
    public Layouter getPredefinedLayouter(@NotNull GraphSettings settings) {
        if (settings == null) {
            DiagramLayout.$$$reportNull$$$0(27);
        }
        Layouter layouter = switch (this) {
            case CUSTOM -> throw new IllegalArgumentException("Use getLayouter instead");
            case COMPACT_ORTHOGONAL -> GraphLayoutService.getInstance().getCompactOrthogonalLayouter();
            case COMPONENT -> GraphLayoutService.getInstance().getComponentLayouter();
            case DIRECTED_ORTHOGONAL -> GraphLayoutService.getInstance().getDirectedOrthogonalLayouter();
            case ORTHOGONAL_GROUPS -> GraphLayoutService.getInstance().getOrthogonalGroupLayouter();
            case CHANNEL -> GraphLayoutService.getInstance().getChannelLayouter();
            case SERIES_PARALLEL -> GraphLayoutService.getInstance().getSeriesParallelLayouter();
            case CIRCULAR -> GraphLayoutService.getInstance().getCircularLayouter();
            case CIRCULAR_EDGE_BUNDLED -> GraphLayoutService.getInstance().getEdgeBundledCircularLayouter();
            case RADIAL -> GraphLayoutService.getInstance().getRadialLayouter();
            case RADIAL_EDGE_BUNDLED -> GraphLayoutService.getInstance().getEdgeBundledRadialLayouter();
            case SINGLE_CYCLE -> GraphLayoutService.getInstance().getSingleCycleLayouter();
            case AR_TREE -> GraphLayoutService.getInstance().getARTreeLayouter();
            case BALLOON -> GraphLayoutService.getInstance().getBalloonLayouter();
            case BALLOON_EDGE_BUNDLED -> GraphLayoutService.getInstance().getEdgeBundledBalloonLayouter();
            case FAMILY_TREE -> GraphLayoutService.getInstance().getFamilyTreeLayouter();
            case RANDOM -> GraphLayoutService.getInstance().getRandomLayouter();
            case ORGANIC -> GraphLayoutService.getInstance().getOrganicLayouter();
            case ORGANIC_EDGE_BUNDLED -> GraphLayoutService.getInstance().getEdgeBundledOrganicLayouter();
            case HIERARCHIC_COMPACT -> GraphLayoutService.getInstance().getHierarchicLayouter();
            default -> GraphLayoutService.getInstance().getGroupLayouter();
        };
        if (layouter == null) {
            DiagramLayout.$$$reportNull$$$0(28);
        }
        return layouter;
    }

    @NlsSafe
    public String getPresentableName() {
        return DiagramBundle.message("diagram.layout." + StringUtil.toLowerCase((String)this.name()).replaceAll("_", "."), new Object[0]);
    }

    @NotNull
    public static DiagramLayout fromLocalizedString(@Nullable String name) {
        if (name == null) {
            return DiagramLayout.getDefault();
        }
        for (DiagramLayout value : DiagramLayout.values()) {
            if (!name.equals(value.getPresentableName())) continue;
            DiagramLayout diagramLayout = value;
            if (diagramLayout == null) {
                DiagramLayout.$$$reportNull$$$0(29);
            }
            return diagramLayout;
        }
        return DiagramLayout.getDefault();
    }

    public static DiagramLayout fromString(Object obj) {
        if (obj == null) {
            return DiagramLayout.getDefault();
        }
        String name = obj.toString();
        try {
            return DiagramLayout.valueOf(StringUtil.toUpperCase((String)name).replaceAll(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            return DiagramLayout.getDefault();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 24, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 1: 
            case 3: 
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/settings/DiagramLayout";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayout";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayouter";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLayouter";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLocalizedString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLayout";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLayouter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLayouter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 24, 27 -> new IllegalArgumentException(string);
        };
    }
}

