/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.state;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.state.DiagramSnapshot;
import com.intellij.diagram.state.DiagramSnapshotFactory;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class DiagramContentSettingsSnapshot
implements DiagramSnapshot {
    private final boolean myIsEdgeCreationMode;
    private final boolean myDoShowDependencies;
    @NotNull
    private final Set<DiagramCategory> myEnabledCategories;
    @Nullable
    private final VisibilityLevel myVisibility;
    @Nullable
    private final NamedScope myScope;

    public DiagramContentSettingsSnapshot(boolean isEdgeCreationMode, boolean doShowDependencies, @NotNull Set<DiagramCategory> enabledCategories, @Nullable VisibilityLevel visibility, @Nullable NamedScope scope) {
        if (enabledCategories == null) {
            DiagramContentSettingsSnapshot.$$$reportNull$$$0(0);
        }
        this.myIsEdgeCreationMode = isEdgeCreationMode;
        this.myDoShowDependencies = doShowDependencies;
        this.myEnabledCategories = enabledCategories;
        this.myVisibility = visibility;
        this.myScope = scope;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> restoreAsync(@NotNull DiagramBuilder builder2) {
        if (builder2 == null) {
            DiagramContentSettingsSnapshot.$$$reportNull$$$0(1);
        }
        CompletableFuture<Void> completableFuture = Futures.runInEdtAsync(() -> {
            DiagramDataModel<?> dataModel = builder2.getDataModel();
            builder2.setAllowEdgeCreation(this.myIsEdgeCreationMode);
            dataModel.setShowDependencies(this.myDoShowDependencies);
            DiagramNodeContentManager nodeContentManager = dataModel.getNodeContentManager();
            for (DiagramCategory category : nodeContentManager.getContentCategories()) {
                nodeContentManager.setCategoryEnabled(category, this.myEnabledCategories.contains(category));
            }
            dataModel.getVisibilityManager().setCurrentVisibilityLevel(this.myVisibility);
            DiagramScopeManager<?> scopeManager = dataModel.getScopeManager();
            if (scopeManager != null) {
                scopeManager.setCurrentScope(this.myScope);
            }
        });
        if (completableFuture == null) {
            DiagramContentSettingsSnapshot.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledCategories";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/state/DiagramContentSettingsSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/state/DiagramContentSettingsSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreAsync";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    implements DiagramSnapshotFactory<DiagramContentSettingsSnapshot> {
        @NotNull
        private static final Factory INSTANCE = new Factory();

        @NotNull
        public static Factory getInstance() {
            Factory factory = INSTANCE;
            if (factory == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return factory;
        }

        @Override
        @NotNull
        public DiagramContentSettingsSnapshot makeSnapshot(@NotNull DiagramBuilder builder2) {
            if (builder2 == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new DiagramContentSettingsSnapshot(builder2.doAllowEdgeCreation(), builder2.getDataModel().isShowDependencies(), new TreeSet<DiagramCategory>(Arrays.asList(builder2.getDataModel().getNodeContentManager().getEnabledCategories())), builder2.getDataModel().getVisibilityManager().getCurrentVisibilityLevel(), Optional.ofNullable(builder2.getDataModel().getScopeManager()).map(it -> it.getCurrentScope()).orElse(null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/state/DiagramContentSettingsSnapshot$Factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/state/DiagramContentSettingsSnapshot$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "makeSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

