/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.view;

import com.intellij.openapi.graph.impl.view.JBGraphEditorComponentDrawable;
import com.intellij.openapi.graph.impl.view.JByToSwingEventsDelegatingMode;
import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import q.C.k;
import q.g.G;
import q.g.M;
import q.g.P;
import q.m.Kp;
import q.m.hq;
import q.m.oI;
import q.m.s1;
import q.m.uI;

public class JBCellEditorMode
extends uI {
    @NotNull
    private final G myNodeCellEditorProvider;
    @NotNull
    private final P myUserObjectMap;
    @NotNull
    private final CellEditorListener myCellEditorListener = new MyCellEditorListener();
    @Nullable
    private Kp myCurrentEditor;
    @Nullable
    private s1 myCurrentEditedNodeRealizer;
    @Nullable
    private JComponent myCurrentEditorComponent;
    @Nullable
    private JByToSwingEventsDelegatingMode myEventsDelegatingMode;
    @Nullable
    private JBGraphEditorComponentDrawable myEditorComponentDrawable;
    @Nullable
    private PropertyChangeListener myFocusOwnerChangeListener;

    public JBCellEditorMode(Kp nodeCellEditor, P userObjectMap) {
        this(k.o(nodeCellEditor), userObjectMap);
    }

    public JBCellEditorMode(G nodeCellEditorProvider, P userObjectMap) {
        super(nodeCellEditorProvider, userObjectMap);
        this.myNodeCellEditorProvider = nodeCellEditorProvider;
        this.myUserObjectMap = userObjectMap;
    }

    @Override
    public boolean editNode(M node, EventObject event) {
        if (this.isNodeEditable(node) && (!this.isCellEditing() || this.stopCellEditing())) {
            s1 s12 = this.o().o(node);
            Kp kp = this.getNodeCellEditor(node);
            if (kp == null || event != null && !kp.isCellEditable(event)) {
                return false;
            }
            this.startCellEditing(s12, kp);
            if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 500 && this.myEventsDelegatingMode != null && this.isCellEditing()) {
                this.myEventsDelegatingMode.mouseClicked((MouseEvent)event);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNodeEditable(M node) {
        return this.getNodeCellEditor(node) != null;
    }

    private void K(MouseEvent mouseEvent) {
        Object object;
        hq hq2;
        if (!this.isCellEditing()) {
            if (!this.shouldStartCellEditing(mouseEvent)) {
                return;
            }
            hq2 = this.o(mouseEvent);
            if (hq2.o() == null) {
                return;
            }
            this.editNode((M)hq2.o(), mouseEvent);
            if (!s1.E) {
                return;
            }
        }
        this.q(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (this.isCellEditing() && mouseEvent.getID() == 501 && ((object = (hq2 = this.o(mouseEvent)).o()) == null || object != this.myCurrentEditedNodeRealizer.o()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    @Nullable
    public Object getUserObject(M node) {
        return this.myUserObjectMap.get(this.myCurrentEditedNodeRealizer.o());
    }

    @Override
    public void setUserObject(M node, Object data) {
        this.myUserObjectMap.o((Object)node, data);
    }

    @Override
    protected boolean shouldStartCellEditing(@NotNull MouseEvent event) {
        if (event == null) {
            JBCellEditorMode.q(0);
        }
        return event.getID() == 500 && event.getClickCount() == 2;
    }

    @Override
    @Nullable
    public Kp getNodeCellEditor(M node) {
        Object object = this.myNodeCellEditorProvider != null ? this.myNodeCellEditorProvider.get(node) : null;
        return object instanceof Kp ? (Kp)object : null;
    }

    @Override
    public boolean isCellEditing() {
        return this.myCurrentEditor != null;
    }

    @Override
    public void startCellEditing(s1 nodeRealizer, Kp nodeCellEditor) {
        if (this.isCellEditing() && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
        if (!this.isCellEditing()) {
            this.myCurrentEditor = nodeCellEditor;
            this.myCurrentEditedNodeRealizer = nodeRealizer;
            nodeCellEditor.addCellEditorListener(this.myCellEditorListener);
            JComponent jComponent = nodeCellEditor.getNodeCellEditorComponent(this.y, nodeRealizer, this.getUserObject(nodeRealizer.o()), nodeRealizer.A());
            this.installEditor(jComponent, nodeRealizer);
        }
    }

    @Override
    @Nullable
    public Kp getEditor() {
        return this.myCurrentEditor;
    }

    @Override
    @Nullable
    public M getEditingNode() {
        return this.myCurrentEditedNodeRealizer != null ? this.myCurrentEditedNodeRealizer.o() : null;
    }

    @Override
    public void cancelCellEditing() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.cancelCellEditing();
        }
    }

    @Override
    public boolean stopCellEditing() {
        return this.myCurrentEditor != null ? this.myCurrentEditor.stopCellEditing() : true;
    }

    @Override
    protected void cellEditingCanceled() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    protected void cellEditingStopped() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    public void reactivateParent() {
        super.reactivateParent();
    }

    @Override
    public void cancelEditing() throws UnsupportedOperationException {
        super.cancelEditing();
    }

    @Override
    protected void setEditing(boolean b2) {
        super.setEditing(b2);
    }

    @Override
    public void activate(boolean b2) {
        super.activate(b2);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseMoved(event);
        }
    }

    private void m(@NotNull MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent == null) {
            JBCellEditorMode.q(1);
        }
        if (mouseEvent.getID() == 501 && this.isCellEditing() && ((object = this.o(mouseEvent).o()) == null || object != this.myCurrentEditedNodeRealizer.o()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseReleased(event);
        }
        this.A(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseDragged(event);
        }
        this.A(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mousePressed(event);
        }
        this.A(event);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseClicked(event);
        }
        this.A(event);
    }

    private void A(MouseEvent mouseEvent) {
        this.m(mouseEvent);
        if (!s1.E) {
            return;
        }
        this.K(mouseEvent);
    }

    @Override
    protected void installEditor(@NotNull JComponent editorComponent, s1 nodeRealizer) {
        if (editorComponent == null) {
            JBCellEditorMode.q(2);
        }
        if (editorComponent.getNextFocusableComponent() == null) {
            editorComponent.setNextFocusableComponent(this.y.o());
        }
        JComponent jComponent = this.o();
        jComponent.add(editorComponent);
        this.myCurrentEditorComponent = editorComponent;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(nodeRealizer.q(), nodeRealizer.o());
        JByToSwingEventsDelegatingMode jByToSwingEventsDelegatingMode = new JByToSwingEventsDelegatingMode(true);
        this.o(jByToSwingEventsDelegatingMode, null, null, null);
        jByToSwingEventsDelegatingMode.addDelegateComponent(editorComponent, affineTransform);
        this.myEventsDelegatingMode = jByToSwingEventsDelegatingMode;
        this.myEditorComponentDrawable = new JBGraphEditorComponentDrawable(jComponent, editorComponent, affineTransform);
        this.y.A(this.myEditorComponentDrawable);
        editorComponent.setBounds(0, 0, (int)nodeRealizer.m(), (int)nodeRealizer.A());
        editorComponent.validate();
        editorComponent.requestFocusInWindow();
        editorComponent.repaint();
        if (this.myFocusOwnerChangeListener == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myFocusOwnerChangeListener = new MyFocusOwnerListener(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
        }
    }

    @Override
    protected void removeEditor() {
        if (this.myFocusOwnerChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
            this.myFocusOwnerChangeListener = null;
        }
        if (this.myCurrentEditorComponent != null) {
            this.myEventsDelegatingMode.reactivateParent();
            this.o().remove(this.myCurrentEditorComponent);
            this.y.m(this.myEditorComponentDrawable);
            this.y.o().repaint();
            this.myEventsDelegatingMode = null;
        }
        this.myCurrentEditorComponent = null;
    }

    private void q(Component component) {
        if (component instanceof oI) {
            return;
        }
        boolean bl = s1.E;
        if (this.isCellEditing()) {
            JComponent jComponent = this.o();
            for (Component component2 = component; component2 != null && component2 != jComponent; component2 = component2.getParent()) {
                if (component2 instanceof Window || component2 instanceof Applet && component2.getParent() == null) {
                    if (component2 == SwingUtilities.getRoot(this.y) && !this.stopCellEditing()) {
                        this.cancelCellEditing();
                    }
                    return;
                }
                if (!bl) continue;
                return;
            }
        }
    }

    @NotNull
    private JComponent o() {
        JComponent jComponent = this.y.o();
        if (jComponent == null) {
            JBCellEditorMode.q(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void q(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanvasComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldStartCellEditing";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cancelEditingIfAnotherNodeWasClicked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installEditor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class MyCellEditorListener
    implements CellEditorListener {
        MyCellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingStopped();
        }

        @Override
        public void editingCanceled(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingCanceled();
        }
    }

    private final class MyFocusOwnerListener
    implements PropertyChangeListener {
        @NotNull
        private final KeyboardFocusManager myFocusManager;

        public MyFocusOwnerListener(KeyboardFocusManager focusManager) {
            if (focusManager == null) {
                MyFocusOwnerListener.o(0);
            }
            this.myFocusManager = focusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JBCellEditorMode.this.q(this.myFocusManager.getPermanentFocusOwner());
        }

        private static /* synthetic */ void o(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusManager", "com/intellij/openapi/graph/impl/view/JBCellEditorMode$MyFocusOwnerListener", "<init>"));
        }
    }
}

