/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0007J%\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/lsp/impl/LspDidChangeUtil;", "", "LspDidChangeUtil", "()V", "getFileToHandle", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "createIncrementalDidChangeParamsBeforeDocumentChange", "Lorg/eclipse/lsp4j/DidChangeTextDocumentParams;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "documentEvent", "virtualFile", "createFullDidChangeParams", "document", "Lcom/intellij/openapi/editor/Document;", "createFullDidChangeParams$intellij_platform_lsp_impl", "o", "Lorg/eclipse/lsp4j/VersionedTextDocumentIdentifier;", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
public final class LspDidChangeUtil {
    @NotNull
    public static final LspDidChangeUtil INSTANCE = new LspDidChangeUtil();

    private LspDidChangeUtil() {
    }

    @Nullable
    public final VirtualFile getFileToHandle(@NotNull DocumentEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3 = virtualFile2 = virtualFile;
            boolean bl = false;
            object = virtualFile3.isInLocalFileSystem() && !StringUtil.equals((CharSequence)event.getOldFragment(), (CharSequence)event.getNewFragment()) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @RequiresEdt
    @NotNull
    public final DidChangeTextDocumentParams createIncrementalDidChangeParamsBeforeDocumentChange(@NotNull LspServer lspServer, @NotNull DocumentEvent documentEvent, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"documentEvent");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Document document = documentEvent.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = this.o(lspServer, document, virtualFile);
        versionedTextDocumentIdentifier.setVersion(Integer.valueOf(versionedTextDocumentIdentifier.getVersion() + 1));
        Document document2 = documentEvent.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Range range = Lsp4jUtilKt.getLsp4jRange(document2, documentEvent.getOffset(), documentEvent.getOldLength());
        String string = ((Object)documentEvent.getNewFragment()).toString();
        TextDocumentContentChangeEvent textDocumentContentChangeEvent = new TextDocumentContentChangeEvent(range, string);
        return new DidChangeTextDocumentParams(versionedTextDocumentIdentifier, CollectionsKt.listOf((Object)textDocumentContentChangeEvent));
    }

    @RequiresReadLock
    @NotNull
    public final DidChangeTextDocumentParams createFullDidChangeParams$intellij_platform_lsp_impl(@NotNull LspServer lspServer, @NotNull Document document, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return new DidChangeTextDocumentParams(this.o(lspServer, document, virtualFile), CollectionsKt.listOf((Object)new TextDocumentContentChangeEvent(document.getText())));
    }

    private final VersionedTextDocumentIdentifier o(LspServer lspServer, Document document, VirtualFile virtualFile) {
        return new VersionedTextDocumentIdentifier(lspServer.getDescriptor().getFileUri(virtualFile), Integer.valueOf(lspServer.getDocumentVersion(document)));
    }
}

