/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.impl.LspRequestExecutorImpl;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.TextRangeAndMarkupContent;
import com.intellij.platform.lsp.impl.completion.LspCompletionUtilKt;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001HB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\u000b0\rH\u0000\u00a2\u0006\u0002\b\u0010J6\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u001c\u0010\f\u001a\u0018\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00130\rH\u0080@\u00a2\u0006\u0004\b\u0014\u0010\u0015J?\u0010\u0016\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u001c\u0010\f\u001a\u0018\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00130\rH\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJG\u0010\u001b\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00122\u001c\u0010\f\u001a\u0018\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00130\r2\u0014\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0012\u0012\u0004\u0012\u00020\u000b0\rH\u0000\u00a2\u0006\u0002\b\u001dJL\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0012\u0018\u00010\u0013\"\u0004\b\u0000\u0010\u00122\u001c\u0010\f\u001a\u0018\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00130\r2\u0014\u0010\u001c\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0012\u0012\u0004\u0012\u00020\u000b0\rH\u0002J6\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0012\u0018\u00010\u0013\"\u0004\b\u0000\u0010\u00122\u001c\u0010\f\u001a\u0018\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00130\rH\u0002J\u0014\u0010 \u001a\u00020\u000b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J=\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010#2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H#0%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0003\u00a2\u0006\u0002\u0010*J\r\u0010+\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b,Jr\u0010-\u001a\u0004\u0018\u0001H.\"\u0004\b\u0000\u0010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182K\u00102\u001aG\u0012\u0013\u0012\u001100\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\u0013\u0012\u001107\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(8\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(9\u0012\u0004\u0012\u0002H.03H\u0003\u00a2\u0006\u0002\u0010:J\"\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\u0006\u0010=\u001a\u00020'H\u0007J(\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010<0\u00132\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\u0006\u0010=\u001a\u00020'H\u0007J\"\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\u0006\u0010=\u001a\u00020'H\u0002J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0018H\u0007J#\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\bEJ$\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00182\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;", "", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "LspRequestExecutorImpl", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "hoverResultCache", "Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache;", "sendNotification", "", "lsp4jSender", "Lkotlin/Function1;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "sendNotification$intellij_platform_lsp_impl", "sendRequest", "Lsp4jResponse", "Ljava/util/concurrent/CompletableFuture;", "sendRequest$intellij_platform_lsp_impl", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendRequestSync", "timeoutMs", "", "sendRequestSync$intellij_platform_lsp_impl", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "sendRequestAsyncButWaitForResponseWithCheckCanceled", "lsp4jResponseConsumer", "sendRequestAsyncButWaitForResponseWithCheckCanceled$intellij_platform_lsp_impl", "o", "o", "o", "lsp4jResponseFuture", "o", "T", "future", "Ljava/util/concurrent/Future;", "cancelOnPCE", "", "debugName", "", "(Ljava/util/concurrent/Future;ZLjava/lang/String;I)Ljava/lang/Object;", "shutdownNow", "shutdownNow$intellij_platform_lsp_impl", "o", "Lsp4jParams", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "lsp4jParamsCreator", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "hostFile", "Lcom/intellij/openapi/editor/Document;", "hostDocument", "hostOffset", "(Lcom/intellij/openapi/vfs/VirtualFile;ILkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "getCompletionList", "Lorg/eclipse/lsp4j/CompletionList;", "isAutoPopup", "getCompletionListAsync", "o", "Lorg/eclipse/lsp4j/CompletionParams;", "getElementDefinitions", "", "Lorg/eclipse/lsp4j/LocationLink;", "getTypeDefinitions", "getTypeDefinitions$intellij_platform_lsp_impl", "getHoverInformation", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "HoverResultCache", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspRequestExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,374:1\n1#2:375\n1563#3:376\n1634#3,3:377\n1563#3:380\n1634#3,3:381\n*S KotlinDebug\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl\n*L\n273#1:376\n273#1:377,3\n286#1:380\n286#1:381,3\n*E\n"})
public final class LspRequestExecutorImpl {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final HoverResultCache hoverResultCache;

    public LspRequestExecutorImpl(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        this.lspServer = lspServer;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)("LSP Executor: " + this.lspServer.getDescriptor()), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executorService = executorService;
        this.hoverResultCache = new HoverResultCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendNotification$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, Unit> lsp4jSender) {
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl = false;
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(() -> LspRequestExecutorImpl.o(lsp4jSender, this));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final <Lsp4jResponse> Object sendRequest$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Continuation<? super Lsp4jResponse> $completion) {
        CompletableFuture<Lsp4jResponse> completableFuture = this.o(lsp4jSender);
        if (completableFuture == null) {
            return null;
        }
        CompletableFuture<Lsp4jResponse> completableFuture2 = completableFuture;
        return FutureKt.await((CompletionStage)completableFuture2, $completion);
    }

    @RequiresBackgroundThread
    @Nullable
    public final <Lsp4jResponse> Lsp4jResponse sendRequestSync$intellij_platform_lsp_impl(int timeoutMs, @NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender) {
        Lsp4jResponse Lsp4jResponse;
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        CompletableFuture<Lsp4jResponse> completableFuture = this.o(lsp4jSender);
        if (completableFuture != null) {
            CompletableFuture<Lsp4jResponse> completableFuture2 = completableFuture;
            boolean bl = false;
            Future future = completableFuture2;
            String string = lsp4jSender.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Lsp4jResponse = (Lsp4jResponse)this.o(future, true, string, timeoutMs);
        } else {
            Lsp4jResponse = null;
        }
        return Lsp4jResponse;
    }

    public static /* synthetic */ Object sendRequestSync$intellij_platform_lsp_impl$default(LspRequestExecutorImpl lspRequestExecutorImpl, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 10000;
        }
        return lspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl(n2, function1);
    }

    public final <Lsp4jResponse> void sendRequestAsyncButWaitForResponseWithCheckCanceled$intellij_platform_lsp_impl(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Function1<? super Lsp4jResponse, Unit> lsp4jResponseConsumer) {
        block0: {
            Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
            Intrinsics.checkNotNullParameter(lsp4jResponseConsumer, (String)"lsp4jResponseConsumer");
            CompletableFuture<? super Lsp4jResponse> completableFuture = this.o(lsp4jSender, lsp4jResponseConsumer);
            if (completableFuture == null) break block0;
            CompletableFuture<? super Lsp4jResponse> completableFuture2 = completableFuture;
            boolean bl = false;
            Future future = completableFuture2;
            String string = lsp4jSender.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.o(future, false, string, 10000);
        }
    }

    private final <Lsp4jResponse> CompletableFuture<Lsp4jResponse> o(Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> function1, Function1<? super Lsp4jResponse, Unit> function12) {
        CompletableFuture<Lsp4jResponse> completableFuture = this.o(function1);
        if (completableFuture == null) {
            function12.invoke(null);
            return null;
        }
        return completableFuture.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.o((arg_0, arg_1) -> LspRequestExecutorImpl.o(function12, arg_0, arg_1), arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <Lsp4jResponse> CompletableFuture<Lsp4jResponse> o(Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> function1) {
        if (this.lspServer.getState() != LspServerState.Running) {
            this.lspServer.logDebug$intellij_platform_lsp_impl("Server not initialized yet, skipping request " + function1.getClass().getName());
            return null;
        }
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            block5: {
                boolean bl = false;
                if (!this.executorService.isShutdown()) break block5;
                CompletableFuture<Lsp4jResponse> completableFuture = null;
                return completableFuture;
            }
            CompletableFuture completableFuture = new CompletableFuture();
            this.executorService.execute(() -> LspRequestExecutorImpl.o(function1, this, completableFuture));
            CompletableFuture completableFuture2 = completableFuture;
            return completableFuture2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void o(CompletableFuture<?> completableFuture) {
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl = false;
            if (!this.executorService.isShutdown()) {
                this.executorService.execute(() -> LspRequestExecutorImpl.q(completableFuture));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @RequiresBackgroundThread
    private final <T> T o(Future<T> future, boolean bl, String string, int n2) {
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < (long)n2) {
            try {
                ProgressManager.checkCanceled();
            }
            catch (ProcessCanceledException processCanceledException) {
                if (bl) {
                    future.cancel(true);
                }
                throw processCanceledException;
            }
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException executionException) {
                LspServerImpl.logWarn$intellij_platform_lsp_impl$default(this.lspServer, "Error response from server: " + executionException.getCause(), null, 2, null);
                return null;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        this.lspServer.logInfo$intellij_platform_lsp_impl("No response from the server in " + n2 + "ms for: " + string);
        future.cancel(true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdownNow$intellij_platform_lsp_impl() {
        ExecutorService executorService = this.executorService;
        synchronized (executorService) {
            boolean bl = false;
            List<Runnable> list = this.executorService.shutdownNow();
        }
        this.hoverResultCache.clearCache();
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private final <Lsp4jParams> Lsp4jParams o(VirtualFile virtualFile, int n2, Function3<? super VirtualFile, ? super Document, ? super Integer, ? extends Lsp4jParams> function3) {
        ProgressManager.checkCanceled();
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            Lsp4jParams Lsp4jParams;
            Lsp4jParams Lsp4jParams2 = Lsp4jParams = null;
            boolean bl = false;
            this.lspServer.logError$intellij_platform_lsp_impl("No document for file " + virtualFile);
            return Lsp4jParams;
        }
        Document document2 = document;
        VirtualFileWindow virtualFileWindow = virtualFile instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile : null;
        if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
            virtualFileWindow = virtualFile;
        }
        VirtualFileWindow virtualFileWindow2 = virtualFileWindow;
        Document document3 = PsiDocumentManagerBase.getTopLevelDocument((Document)document2);
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getTopLevelDocument(...)");
        Document document4 = document3;
        DocumentWindow documentWindow = document2 instanceof DocumentWindow ? (DocumentWindow)document2 : null;
        int n3 = documentWindow != null ? documentWindow.injectedToHost(n2) : n2;
        return (Lsp4jParams)function3.invoke((Object)virtualFileWindow2, (Object)document4, (Object)n3);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final CompletionList getCompletionList(@NotNull VirtualFile file, int offset, boolean isAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CompletionParams completionParams = this.o(file, offset, isAutoPopup);
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, arg_0 -> LspRequestExecutorImpl.q(completionParams, arg_0), 1, null);
        if (either == null) {
            return null;
        }
        Either either2 = either;
        return LspCompletionUtilKt.asCompletionList((Either<List<CompletionItem>, CompletionList>)either2);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final CompletableFuture<CompletionList> getCompletionListAsync(@NotNull VirtualFile file, int offset, boolean isAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CompletionParams completionParams = this.o(file, offset, isAutoPopup);
        CompletableFuture<Object> completableFuture = this.o(arg_0 -> LspRequestExecutorImpl.o(completionParams, arg_0));
        if (completableFuture == null) {
            completableFuture = CompletableFuture.completedFuture(null);
        }
        CompletableFuture completableFuture2 = completableFuture;
        CompletionStage completionStage = completableFuture2.thenApply(arg_0 -> LspRequestExecutorImpl.o(getCompletionListAsync.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final CompletionParams o(VirtualFile virtualFile, int n2, boolean bl) {
        return (CompletionParams)this.o(virtualFile, n2, (arg_0, arg_1, arg_2) -> LspRequestExecutorImpl.o(this, bl, arg_0, arg_1, arg_2));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final List<LocationLink> getElementDefinitions(@NotNull VirtualFile file, int offset) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DefinitionParams definitionParams = (DefinitionParams)this.o(file, offset, (arg_0, arg_1, arg_2) -> LspRequestExecutorImpl.o(this, arg_0, arg_1, arg_2));
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, arg_0 -> LspRequestExecutorImpl.o(definitionParams, arg_0), 1, null);
        if (either == null) {
            return CollectionsKt.emptyList();
        }
        Either either2 = either;
        if (either2.isRight()) {
            Object object = either2.getRight();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRight(...)");
            list = CollectionsKt.distinct((Iterable)((Iterable)object));
        } else {
            Object object = either2.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
            Iterable iterable = (Iterable)object;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t2 : iterable2) {
                Location location = (Location)t2;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new LocationLink(location.getUri(), location.getRange(), location.getRange()));
            }
            list = CollectionsKt.distinct((Iterable)((List)collection));
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final List<LocationLink> getTypeDefinitions$intellij_platform_lsp_impl(@NotNull VirtualFile file, int offset) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TypeDefinitionParams typeDefinitionParams = (TypeDefinitionParams)this.o(file, offset, (arg_0, arg_1, arg_2) -> LspRequestExecutorImpl.o(this, arg_0, arg_1, arg_2));
        Either either = (Either)LspRequestExecutorImpl.sendRequestSync$intellij_platform_lsp_impl$default(this, 0, arg_0 -> LspRequestExecutorImpl.o(typeDefinitionParams, arg_0), 1, null);
        if (either == null) {
            return CollectionsKt.emptyList();
        }
        Either either2 = either;
        if (either2.isRight()) {
            Object object = either2.getRight();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRight(...)");
            list = (List)object;
        } else {
            Object object = either2.getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
            Iterable iterable = (Iterable)object;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t2 : iterable2) {
                Location location = (Location)t2;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new LocationLink(location.getUri(), location.getRange(), location.getRange()));
            }
            list = (List)collection;
        }
        return list;
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public final TextRangeAndMarkupContent getHoverInformation(@NotNull VirtualFile file, int offset, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.hoverResultCache.getHoverInformation(file, offset, timeoutMs);
    }

    public static /* synthetic */ TextRangeAndMarkupContent getHoverInformation$default(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 10000;
        }
        return lspRequestExecutorImpl.getHoverInformation(virtualFile, n2, n3);
    }

    private static final void o(Function1 function1, LspRequestExecutorImpl lspRequestExecutorImpl) {
        function1.invoke((Object)lspRequestExecutorImpl.lspServer.getLsp4jServer$intellij_platform_lsp_impl());
    }

    private static final Unit o(Function1 function1, Object object, Throwable throwable) {
        function1.invoke(object);
        return Unit.INSTANCE;
    }

    private static final void o(Function2 function2, Object object, Object object2) {
        function2.invoke(object, object2);
    }

    private static final Unit o(CompletableFuture completableFuture, Object object, Throwable throwable) {
        boolean bl = throwable == null ? completableFuture.complete(object) : completableFuture.completeExceptionally(throwable);
        return Unit.INSTANCE;
    }

    private static final void q(Function2 function2, Object object, Object object2) {
        function2.invoke(object, object2);
    }

    private static final Unit o(CompletableFuture completableFuture, LspRequestExecutorImpl lspRequestExecutorImpl, CompletableFuture completableFuture2, Object object, Throwable throwable) {
        if (completableFuture.isCancelled()) {
            lspRequestExecutorImpl.o(completableFuture2);
        }
        return Unit.INSTANCE;
    }

    private static final void m(Function2 function2, Object object, Object object2) {
        function2.invoke(object, object2);
    }

    private static final void o(Function1 function1, LspRequestExecutorImpl lspRequestExecutorImpl, CompletableFuture completableFuture) {
        CompletableFuture completableFuture2 = (CompletableFuture)function1.invoke((Object)lspRequestExecutorImpl.lspServer.getLsp4jServer$intellij_platform_lsp_impl());
        completableFuture2.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.q((arg_0, arg_1) -> LspRequestExecutorImpl.o(completableFuture, arg_0, arg_1), arg_0, arg_1));
        completableFuture.whenComplete((arg_0, arg_1) -> LspRequestExecutorImpl.m((arg_0, arg_1) -> LspRequestExecutorImpl.o(completableFuture, lspRequestExecutorImpl, completableFuture2, arg_0, arg_1), arg_0, arg_1));
    }

    private static final void q(CompletableFuture completableFuture) {
        completableFuture.cancel(true);
    }

    private static final CompletableFuture q(CompletionParams completionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().completion(completionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completion(...)");
        return completableFuture;
    }

    private static final CompletableFuture o(CompletionParams completionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().completion(completionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"completion(...)");
        return completableFuture;
    }

    private static final CompletionList o(Function1 function1, Object object) {
        return (CompletionList)function1.invoke(object);
    }

    private static final CompletionParams o(LspRequestExecutorImpl lspRequestExecutorImpl, boolean bl, VirtualFile virtualFile, Document document, int n2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
        return LspCompletionUtilKt.createCompletionParams(lspRequestExecutorImpl.lspServer, virtualFile, document, n2, bl);
    }

    private static final DefinitionParams o(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, Document document, int n2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
        return new DefinitionParams(lspRequestExecutorImpl.lspServer.getDocumentIdentifier(virtualFile), Lsp4jUtilKt.getLsp4jPosition(document, n2));
    }

    private static final CompletableFuture o(DefinitionParams definitionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().definition(definitionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"definition(...)");
        return completableFuture;
    }

    private static final TypeDefinitionParams o(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, Document document, int n2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
        return new TypeDefinitionParams(lspRequestExecutorImpl.lspServer.getDocumentIdentifier(virtualFile), Lsp4jUtilKt.getLsp4jPosition(document, n2));
    }

    private static final CompletableFuture o(TypeDefinitionParams typeDefinitionParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        CompletableFuture completableFuture = languageServer.getTextDocumentService().typeDefinition(typeDefinitionParams);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"typeDefinition(...)");
        return completableFuture;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache;", "", "LspRequestExecutorImpl$HoverResultCache", "(Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;)V", "lastResult", "Lcom/intellij/platform/lsp/impl/TextRangeAndMarkupContent;", "lastPsiModificationCount", "", "lastFilePath", "", "getHoverInformation", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "timeoutMs", "clearCache", "", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspRequestExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,374:1\n24#2:375\n*S KotlinDebug\n*F\n+ 1 LspRequestExecutorImpl.kt\ncom/intellij/platform/lsp/impl/LspRequestExecutorImpl$HoverResultCache\n*L\n311#1:375\n*E\n"})
    private final class HoverResultCache {
        @Nullable
        private TextRangeAndMarkupContent lastResult;
        private long lastPsiModificationCount = -1L;
        @NotNull
        private String lastFilePath = "";

        @RequiresReadLock
        @RequiresBackgroundThread
        @Nullable
        public final synchronized TextRangeAndMarkupContent getHoverInformation(@NotNull VirtualFile file, int offset, int timeoutMs) {
            TextRangeAndMarkupContent textRangeAndMarkupContent;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ProgressManager.checkCanceled();
            if (file instanceof VirtualFileWindow) {
                HoverResultCache hoverResultCache = this;
                boolean bl = false;
                Logger logger = Logger.getInstance(HoverResultCache.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("VirtualFileWindow not expected here");
                return null;
            }
            Project project = LspRequestExecutorImpl.this.lspServer.getProject();
            TextRangeAndMarkupContent textRangeAndMarkupContent2 = this.lastResult;
            long l2 = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String string2 = string;
            if (textRangeAndMarkupContent2 != null && this.lastPsiModificationCount == l2 && Intrinsics.areEqual((Object)this.lastFilePath, (Object)string2) && textRangeAndMarkupContent2.getTextRange().contains(offset)) {
                return textRangeAndMarkupContent2;
            }
            HoverParams hoverParams = (HoverParams)LspRequestExecutorImpl.this.o(file, offset, (arg_0, arg_1, arg_2) -> HoverResultCache.o(LspRequestExecutorImpl.this, arg_0, arg_1, arg_2));
            Hover hover = (Hover)LspRequestExecutorImpl.this.sendRequestSync$intellij_platform_lsp_impl(timeoutMs, arg_0 -> HoverResultCache.o(hoverParams, arg_0));
            if (hover == null) {
                return null;
            }
            Hover hover2 = hover;
            this.lastResult = textRangeAndMarkupContent = TextRangeAndMarkupContent.Companion.fromHover$intellij_platform_lsp_impl(hover2, file, offset);
            this.lastPsiModificationCount = l2;
            this.lastFilePath = string2;
            return textRangeAndMarkupContent;
        }

        public final void clearCache() {
            this.lastResult = null;
            this.lastPsiModificationCount = -1L;
            this.lastFilePath = "";
        }

        private static final HoverParams o(LspRequestExecutorImpl lspRequestExecutorImpl, VirtualFile virtualFile, Document document, int n2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"hostFile");
            Intrinsics.checkNotNullParameter((Object)document, (String)"hostDocument");
            return new HoverParams(lspRequestExecutorImpl.lspServer.getDocumentIdentifier(virtualFile), Lsp4jUtilKt.getLsp4jPosition(document, n2));
        }

        private static final CompletableFuture o(HoverParams hoverParams, LanguageServer languageServer) {
            Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
            CompletableFuture completableFuture = languageServer.getTextDocumentService().hover(hoverParams);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"hover(...)");
            return completableFuture;
        }
    }
}

