/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingLibrariesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class EditLibraryDialog
extends DialogWrapper {
    private static final int FILE_LOCATION_COL = 0;
    private static final int FILE_TYPE_COL = 1;
    private final String mySourceTypeName;
    private final String myCompactTypeName;
    private static final Comparator<VirtualFilePointer> FILE_COMPARATOR = (virtualFilePointer, virtualFilePointer2) -> virtualFilePointer.getUrl().compareToIgnoreCase(virtualFilePointer2.getUrl());
    private JPanel contentPane;
    private JTextField myLibName;
    private final JBTable myFileTable;
    private final JBList<String> myDocUrlList;
    private JComboBox<ScriptingFrameworkDescriptor> myFrameworkCombo;
    private JTextField myVersionField;
    private JRadioButton myProjectRadioButton;
    private JRadioButton myGlobalRadioButton;
    private JPanel myFilesPanel;
    private JPanel myUrlsPanel;
    private final Project myProject;
    private final FileTableModel myFileTableModel;
    private final LangScriptingContextProvider myProvider;
    private final MyDocUrlListModel myDocUrlListModel;
    private ScriptingFrameworkDescriptor mySelectedFramework;
    private final Icon myFileIcon;
    private final Icon myDirectoryIcon;

    public EditLibraryDialog(@NlsContexts.DialogTitle String title, LangScriptingContextProvider provider, Project project) {
        super(true);
        this.v();
        this.myFileIcon = provider.getFileIcon();
        this.myDirectoryIcon = AllIcons.Nodes.Folder;
        this.myProvider = provider;
        this.myProject = project;
        this.myFileTable = new JBTable();
        this.myFileTable.setShowGrid(false);
        this.myFileTable.setUpdateSelectionOnSort(true);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.myFileTable).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List<AnAction> list = EditLibraryDialog.this.o();
                if (list.isEmpty()) {
                    return;
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list.toArray(AnAction.EMPTY_ARRAY));
                ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                RelativePoint relativePoint = button.getPreferredPopupPoint();
                listPopup.show(relativePoint);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.h();
            }
        }).createPanel();
        this.myFilesPanel.add((Component)jPanel, "Center");
        this.setTitle(title);
        this.mySourceTypeName = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.SOURCES));
        this.myCompactTypeName = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.CLASSES));
        this.myFileTableModel = new FileTableModel();
        this.myFileTable.setRowHeight((int)((double)this.myFileTable.getRowHeight() * 1.2));
        this.myFileTable.setModel((TableModel)this.myFileTableModel);
        TableSpeedSearch.installOn((JTable)this.myFileTable);
        this.myDocUrlListModel = new MyDocUrlListModel();
        this.myDocUrlList = new JBList((ListModel)this.myDocUrlListModel);
        DumbAwareAction dumbAwareAction = new DumbAwareAction(WebCoreBundle.messagePointer((String)"action.AnActionButton.text.download", (Object[])new Object[0]), AllIcons.Actions.Download){

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    3.o(0);
                }
                e2.getPresentation().setEnabled(ContainerUtil.find((Object[])EditLibraryDialog.this.getDocUrls(), string -> EditLibraryDialog.this.myProvider.getOfflineDocUrl((String)string) != null) != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    3.o(1);
                }
                EditLibraryDialog.this.o();
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.o(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void o(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n2) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$3";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n2) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        DumbAwareAction dumbAwareAction2 = new DumbAwareAction(WebCoreBundle.messagePointer((String)"action.AnActionButton.text.edit", (Object[])new Object[0]), AllIcons.Actions.Edit){

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    4.o(0);
                }
                e2.getPresentation().setEnabled(EditLibraryDialog.this.myDocUrlList.getSelectedIndex() >= 0);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    4.o(1);
                }
                EditLibraryDialog.this.C();
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    4.o(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void o(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n2) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$4";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n2) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        this.myUrlsPanel.add((Component)ToolbarDecorator.createDecorator(this.myDocUrlList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.g();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.m();
            }
        }).addExtraAction((AnAction)dumbAwareAction2).addExtraAction((AnAction)dumbAwareAction).createPanel(), "Center");
        this.s();
        this.myVersionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                EditLibraryDialog.this.K();
            }
        });
        this.init();
        TableColumn tableColumn = this.myFileTable.getColumnModel().getColumn(1);
        ScriptingLibrariesPanel.setColumnWidth(tableColumn, JBUI.scale((int)80));
        tableColumn.setCellEditor((TableCellEditor)((Object)new TypeCellEditor()));
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel myLabel = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.myFileTableModel.o(row);
                VirtualFile virtualFile = EditLibraryDialog.o(virtualFilePointer);
                if (virtualFile == null || virtualFile.isDirectory()) {
                    this.myLabel.setText("");
                    this.myLabel.setIcon(null);
                } else {
                    this.myLabel.setText(String.valueOf(value));
                    if (isSelected) {
                        this.myLabel.setSelectionIcon();
                    } else {
                        this.myLabel.setRegularIcon();
                    }
                }
                this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                return this.myLabel;
            }
        });
        TableColumn tableColumn2 = this.myFileTable.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer(new FileNameTableCellRenderer());
    }

    @NotNull
    private List<AnAction> o() {
        List<AnAction> list = List.of(new AnAction(WebCoreBundle.message((String)"edit.library.attach.files.popup.title", (Object[])new Object[0]), null, this.myFileIcon){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    9.o(0);
                }
                EditLibraryDialog.this.q();
            }

            private static /* synthetic */ void o(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$9", "actionPerformed"));
            }
        }, new AnAction(WebCoreBundle.message((String)"edit.library.attach.directories.popup.title", (Object[])new Object[0]), null, this.myDirectoryIcon){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    10.o(0);
                }
                EditLibraryDialog.this.u();
            }

            private static /* synthetic */ void o(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$10", "actionPerformed"));
            }
        });
        if (list == null) {
            EditLibraryDialog.o(0);
        }
        return list;
    }

    public EditLibraryDialog(@NlsContexts.DialogTitle String title, LangScriptingContextProvider provider, Project project, ScriptingLibraryModel lib) {
        this(title, provider, project);
        this.myLibName.setText(lib.getName());
        this.myFileTableModel.setFiles(lib.getSourceFilePointers(), lib.getCompactFilePointers());
        Set set = lib.getDocUrls();
        this.myDocUrlListModel.setDocUrls(set);
        if (lib.getFrameworkDescriptor() != null) {
            this.o(lib.getFrameworkDescriptor());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myProjectRadioButton);
        buttonGroup.add(this.myGlobalRadioButton);
        if (lib.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            this.myGlobalRadioButton.setSelected(true);
        } else {
            this.myProjectRadioButton.setSelected(true);
        }
    }

    private void o(ScriptingFrameworkDescriptor scriptingFrameworkDescriptor) {
        this.mySelectedFramework = scriptingFrameworkDescriptor;
        this.myVersionField.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
        for (int i2 = 0; i2 < this.myFrameworkCombo.getItemCount(); ++i2) {
            ScriptingFrameworkDescriptor scriptingFrameworkDescriptor2 = this.myFrameworkCombo.getItemAt(i2);
            if (scriptingFrameworkDescriptor2 == null || !scriptingFrameworkDescriptor.getFrameworkName().equals(scriptingFrameworkDescriptor2.getFrameworkName())) continue;
            this.myFrameworkCombo.setSelectedItem(scriptingFrameworkDescriptor2);
        }
    }

    private void s() {
        List list = ContainerUtil.concat(List.of(new ScriptingFrameworkDescriptor(WebCoreBundle.message((String)"library.edit.dialog.custom_framework_type.name", (Object[])new Object[0]), null)), List.of(this.myProvider.getSupportedFrameworks(this.myProject)));
        this.myFrameworkCombo.setModel(new DefaultComboBoxModel<ScriptingFrameworkDescriptor>(list.toArray(ScriptingFrameworkDescriptor.EMPTY_ARRAY)));
        this.myFrameworkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object object = EditLibraryDialog.this.myFrameworkCombo.getSelectedItem();
                if (object instanceof ScriptingFrameworkDescriptor) {
                    String string = ((ScriptingFrameworkDescriptor)object).getFrameworkName();
                    if (EditLibraryDialog.this.mySelectedFramework == null || !string.equals(EditLibraryDialog.this.mySelectedFramework.getFrameworkName())) {
                        EditLibraryDialog.this.mySelectedFramework = new ScriptingFrameworkDescriptor(((ScriptingFrameworkDescriptor)object).getFrameworkName(), null);
                        EditLibraryDialog.this.myVersionField.setText("");
                    }
                } else {
                    EditLibraryDialog.this.mySelectedFramework = null;
                    EditLibraryDialog.this.myVersionField.setText("");
                }
            }
        });
    }

    private void o() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.getDocUrls()) {
            String string2 = this.myProvider.getOfflineDocUrl(string);
            if (string2 == null) continue;
            linkedHashSet.add(string2);
        }
        this.o(new LinkedList<String>(linkedHashSet), this.getRootPane());
    }

    private void o(@NotNull Queue<String> queue, @Nullable Component component) {
        if (queue == null) {
            EditLibraryDialog.o(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        String string = queue.poll();
        if (string != null) {
            this.myProvider.downloadOfflineDoc(this.myProject, string, component, file -> {
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                if (file != null) {
                    WriteAction.run(() -> {
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                        if (virtualFile != null) {
                            atomicBoolean.set(false);
                            this.myDocUrlListModel.addUrl(virtualFile.getUrl());
                        }
                    });
                }
                if (atomicBoolean.get()) {
                    this.o(queue, component);
                }
            });
        }
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public String getLibName() {
        return this.myLibName.getText();
    }

    private void q() {
        VirtualFile[] virtualFileArray;
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, true, false, true).withTitle(WebCoreBundle.message((String)"edit.library.attach.files.dialog.title", (Object[])new Object[0]));
        String[] stringArray = this.myProvider.getExtensions();
        if (stringArray.length > 0) {
            fileChooserDescriptor = fileChooserDescriptor.withExtensionFilter(ProjectBundle.message((String)"library.attach.files.label", (Object[])new Object[0]), stringArray);
        }
        if ((virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.myProject, null)).length == 0) {
            return;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctVFilesRootsCollection = new VfsUtilCore.DistinctVFilesRootsCollection(virtualFileArray);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : distinctVFilesRootsCollection) {
            if (!virtualFile.isValid()) continue;
            if (virtualFile.isDirectory()) {
                this.o(virtualFile, arrayList);
                continue;
            }
            arrayList.add(virtualFile);
        }
        this.o(arrayList);
    }

    private void u() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        fileChooserDescriptor.setTitle(WebCoreBundle.message((String)"edit.library.dialog.attach.directories.dialog.title", (Object[])new Object[0]));
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.myProject, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isValid()) continue;
            arrayList.add(virtualFile);
        }
        this.o(arrayList);
    }

    private void o(@NotNull List<VirtualFile> list) {
        if (list == null) {
            EditLibraryDialog.o(2);
        }
        this.q(ContainerUtil.map(list, virtualFile -> new LightFilePointer(virtualFile)));
    }

    private void q(@NotNull @Unmodifiable List<VirtualFilePointer> list) {
        if (list == null) {
            EditLibraryDialog.o(3);
        }
        list = ContainerUtil.sorted(list, FILE_COMPARATOR);
        int n2 = 0;
        for (VirtualFilePointer virtualFilePointer2 : list) {
            this.o(virtualFilePointer2, n2++ == list.size() - 1);
        }
        this.A();
        if (this.myLibName.getText().isEmpty() && !list.isEmpty()) {
            list.stream().map(virtualFilePointer -> virtualFilePointer.getFileName()).findFirst().ifPresent(string -> this.myLibName.setText((String)string));
        }
    }

    private void o(VirtualFile virtualFile, final Collection<VirtualFile> collection) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    12.o(0);
                }
                if (file.isValid() && !file.isDirectory() && EditLibraryDialog.this.myProvider.acceptsExtension(file.getExtension())) {
                    collection.add(file);
                }
                return true;
            }

            private static /* synthetic */ void o(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ui/EditLibraryDialog$12", "visitFile"));
            }
        });
    }

    private void o(@NotNull VirtualFilePointer virtualFilePointer, boolean bl) {
        if (virtualFilePointer == null) {
            EditLibraryDialog.o(4);
        }
        int n2 = this.myFileTableModel.o(virtualFilePointer);
        this.myFileTable.setRowSelectionInterval(n2, n2);
        if (bl) {
            TableUtil.scrollSelectionToVisible((JTable)this.myFileTable);
        }
    }

    @NotNull
    public List<String> getSourceFileUrls() {
        List list = ContainerUtil.map(this.myFileTableModel.o(), VirtualFilePointer::getUrl);
        if (list == null) {
            EditLibraryDialog.o(5);
        }
        return list;
    }

    @NotNull
    public List<String> getCompactFileUrls() {
        List list = ContainerUtil.map(this.myFileTableModel.getCompactFilePointers(), VirtualFilePointer::getUrl);
        if (list == null) {
            EditLibraryDialog.o(6);
        }
        return list;
    }

    private void h() {
        int[] nArray = this.myFileTable.getSelectedRows();
        ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
        for (int n2 : nArray) {
            arrayList.add(this.myFileTableModel.o(n2));
        }
        this.myFileTableModel.o(arrayList);
    }

    @Nullable
    private String o() {
        String string = this.myProvider.getDefaultDocUrl(this.mySelectedFramework);
        if (string != null && !this.myDocUrlListModel.contains(string)) {
            return string;
        }
        return null;
    }

    @Nullable
    public ScriptingFrameworkDescriptor getSelectedFramework() {
        return this.mySelectedFramework;
    }

    public String[] getDocUrls() {
        return this.myDocUrlListModel.getDocUrls();
    }

    protected void doOKAction() {
        if (!EditLibraryDialog.o(this.myLibName.getText())) {
            Messages.showErrorDialog((Project)this.myProject, (String)WebCoreBundle.message((String)"scripting.lib.invalid.name", (Object[])new Object[0]), (String)WebCoreBundle.message((String)"dialog.title.error", (Object[])new Object[0]));
            return;
        }
        super.doOKAction();
    }

    private static boolean o(String string) {
        return string != null && string.matches("\\w[\\w._\\- ]*");
    }

    private void C() {
        String string = (String)this.myDocUrlList.getSelectedValue();
        int n2 = this.myDocUrlList.getSelectedIndex();
        VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.contentPane, (String)string);
        if (virtualFile != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            this.myDocUrlListModel.replaceUrl(string, string2);
            this.myDocUrlList.ensureIndexIsVisible(n2);
            this.myDocUrlList.setSelectedIndex(n2);
        }
    }

    private void g() {
        VirtualFile virtualFile;
        String string = null;
        if (this.mySelectedFramework == null) {
            this.A();
        }
        if (this.mySelectedFramework != null) {
            string = this.o();
        }
        if ((virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.contentPane, (String)(string != null ? string : ""))) != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            int n2 = this.myDocUrlListModel.addUrl(string2);
            this.myDocUrlList.ensureIndexIsVisible(n2);
            this.myDocUrlList.setSelectedIndex(n2);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLibName;
    }

    @NotNull
    public ScriptingLibraryModel.LibraryLevel getLibraryLevel() {
        ScriptingLibraryModel.LibraryLevel libraryLevel = this.myGlobalRadioButton.isSelected() ? ScriptingLibraryModel.LibraryLevel.GLOBAL : ScriptingLibraryModel.LibraryLevel.PROJECT;
        if (libraryLevel == null) {
            EditLibraryDialog.o(7);
        }
        return libraryLevel;
    }

    private void m() {
        this.myDocUrlListModel.remove((String)this.myDocUrlList.getSelectedValue());
    }

    @Nullable
    private static VirtualFile o(@Nullable VirtualFilePointer virtualFilePointer) {
        return virtualFilePointer != null ? virtualFilePointer.getFile() : null;
    }

    private void A() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(ContainerUtil.map(this.myFileTableModel.getCompactFilePointers(), virtualFilePointer -> virtualFilePointer.getFile()));
        arrayList.addAll(ContainerUtil.map(this.myFileTableModel.o(), virtualFilePointer -> virtualFilePointer.getFile()));
        for (VirtualFile virtualFile : arrayList) {
            ScriptingFrameworkDescriptor scriptingFrameworkDescriptor = this.myProvider.detectFramework(virtualFile);
            if (scriptingFrameworkDescriptor == null) continue;
            this.myVersionField.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
            this.o(scriptingFrameworkDescriptor);
            if (this.myLibName.getText().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(scriptingFrameworkDescriptor.getFrameworkName());
                if (scriptingFrameworkDescriptor.getFrameworkVersion() != null) {
                    stringBuilder.append(' ').append(scriptingFrameworkDescriptor.getFrameworkVersion());
                }
                this.myLibName.setText(stringBuilder.toString());
            }
            return;
        }
    }

    private void K() {
        if (this.mySelectedFramework != null) {
            this.mySelectedFramework.setFrameworkVersion(this.myVersionField.getText());
        }
    }

    private /* synthetic */ void v() {
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myLibName = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.o(jLabel, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("scripting.lib.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.o(jLabel2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.framework_type.name"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myFrameworkCombo = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.o(jLabel3, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.version.name"));
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(55, -1), new Dimension(55, -1)));
        JLabel jLabel4 = new JLabel();
        this.o(jLabel4, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.visibility.name"));
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myProjectRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.o(jRadioButton2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.level.project.name"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGlobalRadioButton = jRadioButton = new JRadioButton();
        this.o(jRadioButton, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.level.global.name"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFilesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("scripting.lib.docUrl.title"), (int)0, (int)0, null, null));
        this.myUrlsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void o(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl && string.charAt(i2) != '&') {
                    bl = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void o(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl && string.charAt(i2) != '&') {
                    bl = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private static /* synthetic */ void o(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToAdd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFilesActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactFileUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processUrlQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFilePointers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSingleFilePointer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private class FileTableModel
    extends AbstractTableModel {
        private final SortedList<VirtualFilePointer> myFilePointers = new SortedList(FILE_COMPARATOR);
        private final Set<VirtualFilePointer> myCompactFilePointers = new HashSet<VirtualFilePointer>();

        private FileTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> WebCoreBundle.message((String)"scripting.lib.file.name", (Object[])new Object[0]);
                case 1 -> WebCoreBundle.message((String)"scripting.lib.file.type", (Object[])new Object[0]);
                default -> "";
            };
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            VirtualFile virtualFile;
            return columnIndex == 1 && (virtualFile = EditLibraryDialog.o(virtualFilePointer = this.o(rowIndex))) != null && !virtualFile.isDirectory();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            if (columnIndex == 1 && (virtualFilePointer = EditLibraryDialog.this.myFileTableModel.o(rowIndex)) != null && aValue instanceof String) {
                this.o(virtualFilePointer, EditLibraryDialog.this.myCompactTypeName.equals(aValue));
            }
        }

        private int o(@NotNull VirtualFilePointer virtualFilePointer) {
            int n2;
            if (virtualFilePointer == null) {
                FileTableModel.o(0);
            }
            if ((n2 = this.myFilePointers.indexOf((Object)virtualFilePointer)) == -1) {
                this.myFilePointers.add((Object)virtualFilePointer);
                VirtualFile virtualFile = virtualFilePointer.getFile();
                if (virtualFile != null && !virtualFile.isDirectory() && EditLibraryDialog.this.myProvider.isCompact(virtualFile)) {
                    this.myCompactFilePointers.add(virtualFilePointer);
                }
                this.fireTableDataChanged();
                n2 = this.myFilePointers.indexOf((Object)virtualFilePointer);
            }
            return n2;
        }

        public void setFiles(@NotNull Set<VirtualFilePointer> sourceFilePointers, @NotNull Set<VirtualFilePointer> compactFilePointers) {
            if (sourceFilePointers == null) {
                FileTableModel.o(1);
            }
            if (compactFilePointers == null) {
                FileTableModel.o(2);
            }
            this.myFilePointers.clear();
            this.myFilePointers.addAll(sourceFilePointers);
            this.myFilePointers.addAll(compactFilePointers);
            for (VirtualFilePointer virtualFilePointer : sourceFilePointers) {
                this.o(virtualFilePointer, false, false);
            }
            for (VirtualFilePointer virtualFilePointer : compactFilePointers) {
                this.o(virtualFilePointer, true, false);
            }
        }

        private void o(@NotNull VirtualFilePointer virtualFilePointer, boolean bl) {
            if (virtualFilePointer == null) {
                FileTableModel.o(3);
            }
            this.o(virtualFilePointer, bl, true);
        }

        private void o(@NotNull VirtualFilePointer virtualFilePointer, boolean bl, boolean bl2) {
            if (virtualFilePointer == null) {
                FileTableModel.o(4);
            }
            boolean bl3 = false;
            VirtualFile virtualFile = virtualFilePointer.getFile();
            if (virtualFile != null && virtualFile.isValid() && virtualFile.isDirectory()) {
                bl = false;
            }
            if (bl) {
                if (!this.myCompactFilePointers.contains(virtualFilePointer)) {
                    this.myCompactFilePointers.add(virtualFilePointer);
                    bl3 = true;
                }
            } else if (this.myCompactFilePointers.contains(virtualFilePointer)) {
                this.myCompactFilePointers.remove(virtualFilePointer);
                bl3 = true;
            }
            if (bl3 && bl2) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.myFilePointers.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)this.myFilePointers.get(rowIndex);
            return switch (columnIndex) {
                case 0 -> virtualFilePointer.getFileName();
                case 1 -> {
                    if (this.myCompactFilePointers.contains(virtualFilePointer)) {
                        yield EditLibraryDialog.this.myCompactTypeName;
                    }
                    yield EditLibraryDialog.this.mySourceTypeName;
                }
                default -> "";
            };
        }

        @Nullable
        private VirtualFilePointer o(int n2) {
            if (n2 < 0 || n2 >= this.myFilePointers.size()) {
                return null;
            }
            return (VirtualFilePointer)this.myFilePointers.get(n2);
        }

        private void o(@NotNull List<VirtualFilePointer> list) {
            if (list == null) {
                FileTableModel.o(5);
            }
            if (this.myFilePointers.removeAll(list)) {
                this.fireTableDataChanged();
            }
        }

        @NotNull
        private List<VirtualFilePointer> o(boolean bl) {
            ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
            for (VirtualFilePointer virtualFilePointer : this.myFilePointers) {
                if (this.myCompactFilePointers.contains(virtualFilePointer) != bl) continue;
                arrayList.add(virtualFilePointer);
            }
            ArrayList<VirtualFilePointer> arrayList2 = arrayList;
            if (arrayList2 == null) {
                FileTableModel.o(6);
            }
            return arrayList2;
        }

        @NotNull
        public List<VirtualFilePointer> getCompactFilePointers() {
            return this.o(true);
        }

        @NotNull
        private List<VirtualFilePointer> o() {
            return this.o(false);
        }

        private static /* synthetic */ void o(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFilePointers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compactFilePointers";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointers";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePointers";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addFilePointer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFiles";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFilePointers";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyDocUrlListModel
    extends AbstractListModel<String> {
        private final List<String> myDocUrls = new ArrayList<String>();

        private MyDocUrlListModel() {
        }

        public void setDocUrls(Set<String> urls) {
            if (urls != null && !urls.isEmpty()) {
                this.myDocUrls.addAll(urls);
            }
        }

        @Override
        public int getSize() {
            return this.myDocUrls.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.myDocUrls.get(index);
        }

        public int addUrl(String url) {
            if (!this.myDocUrls.contains(url)) {
                this.myDocUrls.add(url);
                int n2 = this.myDocUrls.indexOf(url);
                this.fireIntervalAdded(this, n2, n2);
                return n2;
            }
            return this.myDocUrls.indexOf(url);
        }

        public void replaceUrl(String oldUrl, String newUrl) {
            if (oldUrl == null || !this.myDocUrls.contains(oldUrl)) {
                return;
            }
            int n2 = this.myDocUrls.indexOf(oldUrl);
            this.myDocUrls.remove(oldUrl);
            this.myDocUrls.add(n2, newUrl);
        }

        public int indexOf(String url) {
            return this.myDocUrls.indexOf(url);
        }

        public void remove(String url) {
            if (url == null || !this.myDocUrls.contains(url)) {
                return;
            }
            int n2 = this.myDocUrls.indexOf(url);
            this.myDocUrls.remove(url);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public boolean contains(String url) {
            return this.myDocUrls.contains(url);
        }

        public String[] getDocUrls() {
            return ArrayUtilRt.toStringArray(this.myDocUrls);
        }
    }

    private class TypeCellEditor
    extends AbstractTableCellEditor {
        private final JBComboBoxTableCellEditorComponent myEditorComponent = new JBComboBoxTableCellEditorComponent();

        TypeCellEditor() {
            this.myEditorComponent.setOptions(new Object[]{EditLibraryDialog.this.mySourceTypeName, EditLibraryDialog.this.myCompactTypeName});
            this.myEditorComponent.setToString(object -> (String)object);
        }

        public Object getCellEditorValue() {
            return this.myEditorComponent.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.myFileTableModel.o(row);
            this.myEditorComponent.setCell(table, row, column);
            if (virtualFilePointer != null) {
                Object object = EditLibraryDialog.this.myFileTableModel.getValueAt(row, 1);
                this.myEditorComponent.setDefaultValue(object);
            }
            return this.myEditorComponent;
        }
    }

    private class FileNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private FileNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(null);
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.myFileTableModel.o(row);
            if (virtualFilePointer != null) {
                this.setToolTipText(virtualFilePointer.getPresentableUrl());
                VirtualFile virtualFile = EditLibraryDialog.o(virtualFilePointer);
                this.setIcon(virtualFile == null ? AllIcons.FileTypes.Unknown : (virtualFile.isDirectory() ? EditLibraryDialog.this.myDirectoryIcon : EditLibraryDialog.this.myFileIcon));
                if (!(virtualFile != null && virtualFile.isValid() || isSelected)) {
                    this.setForeground((Color)JBColor.red);
                }
            }
            this.setBorder(null);
            return component;
        }
    }
}

