/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 79152868637703L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(916310370 + 14505, 916310370 + (char)-20275, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(916310370 + 14504, 916310370 + 15360, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 89599640581564L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.o();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1967098560 + -((char)-5746), 1967098560 + (char)-3641, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1967098560 + -((char)-5747), -1967098560 + -((char)-16279), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1967098560 + -((char)-5748), -1967098560 + -((char)-16039), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 30043198768213L;
                Object object = this.lock;
                String string = SshAgentIpcService.o();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2932), 97516080 - (char)-5356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2929), -97516080 - -((char)-13277), (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2930), -97516080 - -((char)-13435), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2943), -97516080 - -((char)-15439), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2944), -97516080 - -((char)-5844), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2941), 97516080 - (char)-3309, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2943), -97516080 - -((char)-15439), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-97516080 - -((char)-2942), 97516080 - (char)-12214, (int)l2));
            if (ActionTimestamp.o() == null) {
                SshAgentIpcService.o("hUjRpc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 34698447681832L;
                    string = SshAgentIpcService.o();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 53271025006419L;
                String string2 = SshAgentIpcService.o();
                this.assertConnectionThread();
                Object object3 = this.lock;
                string = string2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(545644410 - 22055, 545644410 - 11657, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(545644410 - 22051, 545644410 - 9459, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(545644410 - 22056, -545644410 - -20852, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(545644410 - 22051, 545644410 - 9459, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(545644410 - 22057, -545644410 - -6942, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(545644410 - 22055, 545644410 - 11657, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(545644410 - 22051, 545644410 - 9459, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(545644410 - 22058, 545644410 - 4136, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(545644410 - 22055, 545644410 - 11657, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(545644410 - 22051, 545644410 - 9459, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(545644410 - 22059, 545644410 - 5454, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(545644410 - 22051, 545644410 - 9459, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(545644410 - 22060, 545644410 - 4969, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string4 = WindowsNamedPipeAgentIpc.b(545644410 - 22051, 545644410 - 9459, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(545644410 - 22057, -545644410 - -6942, (int)l2) + this.state;
                throw new IllegalArgumentException(string4.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(545644410 - 22055, 545644410 - 11657, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(545644410 - 22051, 545644410 - 9459, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(545644410 - 22061, -545644410 - -11423, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 5384476425237L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1412541390 + -27707, -1412541390 + -21933, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 126184209443601L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1929743610 - -32236, -1929743610 - -((char)-32159), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00e7/\u009f\u008d\u0012\u00d1\u0085\u001f\u0006\u00dac\u00d2A\u00efb-\u00f8\u0088\u00cb\u0014\u00aa\u00a86{<\u00cd=\u0019\u0093\u001c\u0014\u00dem\u0097&\u00a9\u009d\u00de`i";
                        var4_3 = "\u00e7/\u009f\u008d\u0012\u00d1\u0085\u001f\u0006\u00dac\u00d2A\u00efb-\u00f8\u0088\u00cb\u0014\u00aa\u00a86{<\u00cd=\u0019\u0093\u001c\u0014\u00dem\u0097&\u00a9\u009d\u00de`i".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 63;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 19;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 98;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 13;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 111;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 39;
                                        break;
                                    }
                                    default: {
                                        v11 = 36;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x1BE2) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 139;
                            case 1 -> 247;
                            case 2 -> 192;
                            case 3 -> 207;
                            case 4 -> 188;
                            case 5 -> 175;
                            case 6 -> 12;
                            case 7 -> 78;
                            case 8 -> 31;
                            case 9 -> 116;
                            case 10 -> 131;
                            case 11 -> 126;
                            case 12 -> 59;
                            case 13 -> 218;
                            case 14 -> 96;
                            case 15 -> 204;
                            case 16 -> 236;
                            case 17 -> 90;
                            case 18 -> 27;
                            case 19 -> 81;
                            case 20 -> 33;
                            case 21 -> 76;
                            case 22 -> 214;
                            case 23 -> 208;
                            case 24 -> 130;
                            case 25 -> 174;
                            case 26 -> 195;
                            case 27 -> 60;
                            case 28 -> 215;
                            case 29 -> 99;
                            case 30 -> 221;
                            case 31 -> 15;
                            case 32 -> 43;
                            case 33 -> 146;
                            case 34 -> 141;
                            case 35 -> 10;
                            case 36 -> 201;
                            case 37 -> 178;
                            case 38 -> 74;
                            case 39 -> 75;
                            case 40 -> 182;
                            case 41 -> 157;
                            case 42 -> 242;
                            case 43 -> 117;
                            case 44 -> 50;
                            case 45 -> 17;
                            case 46 -> 226;
                            case 47 -> 77;
                            case 48 -> 154;
                            case 49 -> 110;
                            case 50 -> 255;
                            case 51 -> 95;
                            case 52 -> 219;
                            case 53 -> 88;
                            case 54 -> 181;
                            case 55 -> 253;
                            case 56 -> 229;
                            case 57 -> 4;
                            case 58 -> 158;
                            case 59 -> 103;
                            case 60 -> 185;
                            case 61 -> 184;
                            case 62 -> 39;
                            case 63 -> 162;
                            case 64 -> 220;
                            case 65 -> 37;
                            case 66 -> 48;
                            case 67 -> 41;
                            case 68 -> 113;
                            case 69 -> 173;
                            case 70 -> 133;
                            case 71 -> 89;
                            case 72 -> 46;
                            case 73 -> 24;
                            case 74 -> 66;
                            case 75 -> 38;
                            case 76 -> 16;
                            case 77 -> 248;
                            case 78 -> 29;
                            case 79 -> 251;
                            case 80 -> 61;
                            case 81 -> 177;
                            case 82 -> 180;
                            case 83 -> 108;
                            case 84 -> 129;
                            case 85 -> 64;
                            case 86 -> 166;
                            case 87 -> 3;
                            case 88 -> 125;
                            case 89 -> 152;
                            case 90 -> 128;
                            case 91 -> 189;
                            case 92 -> 23;
                            case 93 -> 138;
                            case 94 -> 203;
                            case 95 -> 45;
                            case 96 -> 194;
                            case 97 -> 25;
                            case 98 -> 234;
                            case 99 -> 186;
                            case 100 -> 121;
                            case 101 -> 241;
                            case 102 -> 109;
                            case 103 -> 160;
                            case 104 -> 85;
                            case 105 -> 127;
                            case 106 -> 57;
                            case 107 -> 232;
                            case 108 -> 228;
                            case 109 -> 163;
                            case 110 -> 245;
                            case 111 -> 62;
                            case 112 -> 137;
                            case 113 -> 134;
                            case 114 -> 19;
                            case 115 -> 150;
                            case 116 -> 217;
                            case 117 -> 197;
                            case 118 -> 8;
                            case 119 -> 124;
                            case 120 -> 98;
                            case 121 -> 170;
                            case 122 -> 65;
                            case 123 -> 213;
                            case 124 -> 91;
                            case 125 -> 222;
                            case 126 -> 223;
                            case 127 -> 84;
                            case 128 -> 161;
                            case 129 -> 35;
                            case 130 -> 2;
                            case 131 -> 252;
                            case 132 -> 73;
                            case 133 -> 145;
                            case 134 -> 142;
                            case 135 -> 83;
                            case 136 -> 49;
                            case 137 -> 246;
                            case 138 -> 164;
                            case 139 -> 92;
                            case 140 -> 69;
                            case 141 -> 22;
                            case 142 -> 53;
                            case 143 -> 249;
                            case 144 -> 94;
                            case 145 -> 26;
                            case 146 -> 159;
                            case 147 -> 5;
                            case 148 -> 148;
                            case 149 -> 183;
                            case 150 -> 72;
                            case 151 -> 40;
                            case 152 -> 202;
                            case 153 -> 193;
                            case 154 -> 167;
                            case 155 -> 56;
                            case 156 -> 238;
                            case 157 -> 100;
                            case 158 -> 82;
                            case 159 -> 97;
                            case 160 -> 132;
                            case 161 -> 227;
                            case 162 -> 210;
                            case 163 -> 67;
                            case 164 -> 11;
                            case 165 -> 144;
                            case 166 -> 123;
                            case 167 -> 118;
                            case 168 -> 237;
                            case 169 -> 32;
                            case 170 -> 18;
                            case 171 -> 198;
                            case 172 -> 9;
                            case 173 -> 239;
                            case 174 -> 114;
                            case 175 -> 172;
                            case 176 -> 54;
                            case 177 -> 107;
                            case 178 -> 209;
                            case 179 -> 58;
                            case 180 -> 80;
                            case 181 -> 68;
                            case 182 -> 42;
                            case 183 -> 165;
                            case 184 -> 136;
                            case 185 -> 200;
                            case 186 -> 233;
                            case 187 -> 196;
                            case 188 -> 36;
                            case 189 -> 199;
                            case 190 -> 7;
                            case 191 -> 106;
                            case 192 -> 104;
                            case 193 -> 63;
                            case 194 -> 205;
                            case 195 -> 169;
                            case 196 -> 206;
                            case 197 -> 86;
                            case 198 -> 28;
                            case 199 -> 240;
                            case 200 -> 171;
                            case 201 -> 244;
                            case 202 -> 6;
                            case 203 -> 235;
                            case 204 -> 254;
                            case 205 -> 212;
                            case 206 -> 101;
                            case 207 -> 115;
                            case 208 -> 52;
                            case 209 -> 190;
                            case 210 -> 176;
                            case 211 -> 120;
                            case 212 -> 168;
                            case 213 -> 1;
                            case 214 -> 79;
                            case 215 -> 30;
                            case 216 -> 44;
                            case 217 -> 135;
                            case 218 -> 147;
                            case 219 -> 179;
                            case 220 -> 102;
                            case 221 -> 243;
                            case 222 -> 153;
                            case 223 -> 225;
                            case 224 -> 105;
                            case 225 -> 34;
                            case 226 -> 140;
                            case 227 -> 216;
                            case 228 -> 21;
                            case 229 -> 55;
                            case 230 -> 112;
                            case 231 -> 187;
                            case 232 -> 87;
                            case 233 -> 13;
                            case 234 -> 230;
                            case 235 -> 0;
                            case 236 -> 14;
                            case 237 -> 51;
                            case 238 -> 211;
                            case 239 -> 191;
                            case 240 -> 151;
                            case 241 -> 93;
                            case 242 -> 71;
                            case 243 -> 70;
                            case 244 -> 250;
                            case 245 -> 119;
                            case 246 -> 155;
                            case 247 -> 231;
                            case 248 -> 122;
                            case 249 -> 47;
                            case 250 -> 111;
                            case 251 -> 143;
                            case 252 -> 149;
                            case 253 -> 224;
                            case 254 -> 20;
                            default -> 156;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.o("X7Hhs");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 89965903462150L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.o();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-776458680 + -((char)-21182), -776458680 + -29860, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-776458680 + -((char)-21178), -776458680 + -31606, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-776458680 + -((char)-21201), -776458680 + -20147, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-776458680 + -((char)-21182), -776458680 + -29860, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-776458680 + -((char)-21178), -776458680 + -31606, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-776458680 + -((char)-21206), 776458680 + 31892, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 49677705457964L;
                        String string3 = SshAgentIpcService.o();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(2113765890 - (char)-3379, 2113765890 - (char)-8060, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(2113765890 - (char)-3380, 2113765890 - (char)-2031, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 68965418462443L;
                String string2 = SshAgentIpcService.o();
                this.assertConnectionThread();
                Object object2 = this.lock;
                string = string2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5681, 1128643770 - (char)-11663, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5685, 1128643770 - (char)-9349, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5686, -1128512700 + -((char)-5509), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5685, 1128643770 - (char)-9349, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5679, -1128512700 + -((char)-7384), (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5681, 1128643770 - (char)-11663, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5685, 1128643770 - (char)-9349, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5701, 1128643770 - (char)-11481, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5681, 1128643770 - (char)-11663, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5685, 1128643770 - (char)-9349, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5700, 1128643770 - (char)-7404, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5681, 1128643770 - (char)-11663, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5685, 1128643770 - (char)-9349, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1128643770 - (char)-5699, -1128512700 + -((char)-11686), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 132162021712825L;
                    Object object = this.lock;
                    string = SshAgentIpcService.o();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1583063460 - 17387, 1583063460 - 15497, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1583063460 - 17383, 1583063460 - 13111, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1583063460 - 17398, 1583063460 - (char)-26119, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1583063460 - 17403, -1583063460 - -11003, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1583063460 - 17387, 1583063460 - 15497, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1583063460 - 17383, 1583063460 - 13111, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1583063460 - 17404, 1583063460 - 31664, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1583063460 - 17387, 1583063460 - 15497, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1583063460 - 17383, 1583063460 - 13111, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1583063460 - 17401, 1583063460 - 18627, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1583063460 - 17387, 1583063460 - 15497, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1583063460 - 17383, 1583063460 - 13111, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1583063460 - 17402, -1583063460 - -28099, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1583063460 - 17387, 1583063460 - 15497, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1583063460 - 17383, 1583063460 - 13111, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1583063460 - 17423, 1583063460 - 31625, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1583063460 - 17424, 1583063460 - 29116, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0018j\u00a3\u00b8A\u00bdf\u00fd\u0014\u00f5\u00cf&\u00eb\u000f_\u0000\u00bbc,\u00b7\u00b3?\u009f\u0012\u00af\u0019\u00f1\u0004\u00bc\u0006\u0001\u00e3\u0080\u0089O\u00da\u0018\u00c7O\u0000\u00cbI\u009e\u00caC\u00f2N\u008a\u008f\u00fe\u00e7x\"\u00fd)\u00b6:\u000bB\u0018\u0012\t\u00b1\u009bP\u00e0(d\u00feTH\u0005\u008cZ1\u00bec\bn\u00acm\u0011\u00ca\u00ae\u0011}\u00142g\u00a6er\u0086\u009a\u0017^d\u00bb\u000e\u00f4\u008b\u00d0\u00c0S\u00cf\u00b49\u0005A\u00d8\u0088\u00eeT\u001e\u00ff-J4\u0091\u00a5s^`\u00f9\u0093\u00fe\u0091\u00e97\u0087\u00f5\fej\u00ddg\u00ce{U\u00fc7\u00ac\u00c7\u00cd\u0010i\u009f|\u00a7\u0000\u00e5\u00b7\u00af\u0085u\u00a2\u0092\u00b11\u009c\u0003\t \u00a9\u00b4\u00b7\u00e7\u00a9!r]\u0010\u00baU\u0006\u00feO\u00ce^\u00ca\u00b8\u00d9\u0005\u0007E\u0083\u0002U?\u00ff\u00c1B\u00a9\u009d\u001fwe\u0091O\u00e8\u00d3A\u00ba\u0010\u00d4\u00d4\u0003<Nx\u00b1\u0001\u00c7\u00bc\u0083\u0007\u00f7\u00f6\u00f0\u00f7\u009cG\u00ce\u00c0\u00d6m\u009f\n\u00cb\u00cc\u00b2<\u00f4Hi\u00de\u00f8\u0019\u00eb\u0083\u00fd\u00ce\u00dbfKy\u0016\u00d1j\u00afgR\bh\u00d4\u00ad\u001e\u00d2O\u0012A\f\u0083K\u00c0\u00f6b0\u00ea\u00a9\u0007\u00fd\u00a0\u0087F\u0010E\u00b27,\b#\u00ae>\u0011\u008d\u00de{\u0013H\u00c7#\u0006\u00c2A\u00b5\u0002\u00bb\u0083\u00dd \u00d8\u0088\u00b26Ex-\u00e4O\u00b2F^\u00c47\u00868\u00fe^\u00ce\u00b9Z\u009fn\u00ff\u000b\u00d50H\u00af\"\u00dfO\u0093\u00fd\u00d4\u00fca\u001a\u00e3I1\u00b3\u000e7\u001fEO\u001dx{,.o\u00cb\u00df\u00e6:?l\u00e9\u0086U\u00c4\f\u00b9;\u009d\u00c5\u008fU\u00b2 \u00a98\u009c\u0016\u000b\u0016\u00c1r\u00a74\u001a \u00ec^Y\u0081\u0015\u0003%\u00d08g\u0081\u00a6\u00e2\u00b0x\u0094\u0005\u00cf'\u00ea\u00b9\u00ce\u00b7\u00a2\u00ae\u00d8)\u00ca@\u00ec\u0099E\u0010\u00e9\u00e83/\u00f9$\u00d8\u00a5\u008b\u00baF\u00cb\u00b5\u00ff\u00fc-\u00fb\u0081\u00fd:\u00e2\u00c0OEz(4K\n\u00ca\u00f0L\u0099\u00dc\u008e\u0007yp\u0090\u0085\u00ee\u00ce\u0007\u0007M\u00f9r\u00d8U\u008af(y\u0087\u00d6@\u00b2A\u00e1\u00e5BY\u00fd\u00dc{;\u00bd\u00ea\u0087l#HO\u00e5\u00e2SN\u00dc\"g`\u00d1D\u00a3\bQ\u0013$i\u00ec9;\u000f\t\u00ef\u0096dR\u00a9X;\u0000\u000f\u0014G\u00e6\u001c\u0090\"\u00b1\u00ca\u0083\u00c8\u00a8:T\u00ad\u0084\u0087\u000f1\u0005\u000bT\u00a1V\u0081=\u00f4\u0007L$\u00fd\u0095\u00e1\"es\u00c3_\u00ff\u00beB\u000e\u00aa\u009c\u00e2\n\u00dcd\u0089\u0082:8S\u00a1\u0002\u00ca\u001b\u00fa\u0007\u00ef|\u0086\u001fW\u00b1\u00b6\u00d9O\u009c\u00d1[\u00e8\u00bdi\u00a8gMwOY;qT\u00eb\n\u000bB\u0015\u00d3\u00cd\u000e\u00ed\u00b9J\u00ba\u0018\u00a5\u00ef\u0004l\u00fa\u00a1\u00f98}!\u00f4\u001c\u001f\u0018\u00cd\u00f4\u00ba\u0080\u00ca1\u00ba\u008b\u00bb\u00f0)-]\u0010:\u00dad\u001afM\u00fe6\u001e%\u00eb\u00ab\b<\u00e8%^\u00d4\t\u00b7\t\u0001\u00b9\u00e0\\\\\u008a\u00a3@*\u0098\u001c$\u00ec\u00b5\u001a\u00e3\u00fe\tnB}\u00d4\u00d4\n\u0011]\u00e6";
                var4_3 = "\u0018j\u00a3\u00b8A\u00bdf\u00fd\u0014\u00f5\u00cf&\u00eb\u000f_\u0000\u00bbc,\u00b7\u00b3?\u009f\u0012\u00af\u0019\u00f1\u0004\u00bc\u0006\u0001\u00e3\u0080\u0089O\u00da\u0018\u00c7O\u0000\u00cbI\u009e\u00caC\u00f2N\u008a\u008f\u00fe\u00e7x\"\u00fd)\u00b6:\u000bB\u0018\u0012\t\u00b1\u009bP\u00e0(d\u00feTH\u0005\u008cZ1\u00bec\bn\u00acm\u0011\u00ca\u00ae\u0011}\u00142g\u00a6er\u0086\u009a\u0017^d\u00bb\u000e\u00f4\u008b\u00d0\u00c0S\u00cf\u00b49\u0005A\u00d8\u0088\u00eeT\u001e\u00ff-J4\u0091\u00a5s^`\u00f9\u0093\u00fe\u0091\u00e97\u0087\u00f5\fej\u00ddg\u00ce{U\u00fc7\u00ac\u00c7\u00cd\u0010i\u009f|\u00a7\u0000\u00e5\u00b7\u00af\u0085u\u00a2\u0092\u00b11\u009c\u0003\t \u00a9\u00b4\u00b7\u00e7\u00a9!r]\u0010\u00baU\u0006\u00feO\u00ce^\u00ca\u00b8\u00d9\u0005\u0007E\u0083\u0002U?\u00ff\u00c1B\u00a9\u009d\u001fwe\u0091O\u00e8\u00d3A\u00ba\u0010\u00d4\u00d4\u0003<Nx\u00b1\u0001\u00c7\u00bc\u0083\u0007\u00f7\u00f6\u00f0\u00f7\u009cG\u00ce\u00c0\u00d6m\u009f\n\u00cb\u00cc\u00b2<\u00f4Hi\u00de\u00f8\u0019\u00eb\u0083\u00fd\u00ce\u00dbfKy\u0016\u00d1j\u00afgR\bh\u00d4\u00ad\u001e\u00d2O\u0012A\f\u0083K\u00c0\u00f6b0\u00ea\u00a9\u0007\u00fd\u00a0\u0087F\u0010E\u00b27,\b#\u00ae>\u0011\u008d\u00de{\u0013H\u00c7#\u0006\u00c2A\u00b5\u0002\u00bb\u0083\u00dd \u00d8\u0088\u00b26Ex-\u00e4O\u00b2F^\u00c47\u00868\u00fe^\u00ce\u00b9Z\u009fn\u00ff\u000b\u00d50H\u00af\"\u00dfO\u0093\u00fd\u00d4\u00fca\u001a\u00e3I1\u00b3\u000e7\u001fEO\u001dx{,.o\u00cb\u00df\u00e6:?l\u00e9\u0086U\u00c4\f\u00b9;\u009d\u00c5\u008fU\u00b2 \u00a98\u009c\u0016\u000b\u0016\u00c1r\u00a74\u001a \u00ec^Y\u0081\u0015\u0003%\u00d08g\u0081\u00a6\u00e2\u00b0x\u0094\u0005\u00cf'\u00ea\u00b9\u00ce\u00b7\u00a2\u00ae\u00d8)\u00ca@\u00ec\u0099E\u0010\u00e9\u00e83/\u00f9$\u00d8\u00a5\u008b\u00baF\u00cb\u00b5\u00ff\u00fc-\u00fb\u0081\u00fd:\u00e2\u00c0OEz(4K\n\u00ca\u00f0L\u0099\u00dc\u008e\u0007yp\u0090\u0085\u00ee\u00ce\u0007\u0007M\u00f9r\u00d8U\u008af(y\u0087\u00d6@\u00b2A\u00e1\u00e5BY\u00fd\u00dc{;\u00bd\u00ea\u0087l#HO\u00e5\u00e2SN\u00dc\"g`\u00d1D\u00a3\bQ\u0013$i\u00ec9;\u000f\t\u00ef\u0096dR\u00a9X;\u0000\u000f\u0014G\u00e6\u001c\u0090\"\u00b1\u00ca\u0083\u00c8\u00a8:T\u00ad\u0084\u0087\u000f1\u0005\u000bT\u00a1V\u0081=\u00f4\u0007L$\u00fd\u0095\u00e1\"es\u00c3_\u00ff\u00beB\u000e\u00aa\u009c\u00e2\n\u00dcd\u0089\u0082:8S\u00a1\u0002\u00ca\u001b\u00fa\u0007\u00ef|\u0086\u001fW\u00b1\u00b6\u00d9O\u009c\u00d1[\u00e8\u00bdi\u00a8gMwOY;qT\u00eb\n\u000bB\u0015\u00d3\u00cd\u000e\u00ed\u00b9J\u00ba\u0018\u00a5\u00ef\u0004l\u00fa\u00a1\u00f98}!\u00f4\u001c\u001f\u0018\u00cd\u00f4\u00ba\u0080\u00ca1\u00ba\u008b\u00bb\u00f0)-]\u0010:\u00dad\u001afM\u00fe6\u001e%\u00eb\u00ab\b<\u00e8%^\u00d4\t\u00b7\t\u0001\u00b9\u00e0\\\\\u008a\u00a3@*\u0098\u001c$\u00ec\u00b5\u001a\u00e3\u00fe\tnB}\u00d4\u00d4\n\u0011]\u00e6".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 101;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u008f\u0081\u0087b\u00eb\u00ac\u00ff\u00bc2f\u001a\u00cec2\u00a0\u00f0\u009e8\u00e2\u0003\u00ba^J\u00fe\u00d6\u0098H\u00fe\u001a\u0014\u00a2\u00d1\u000f\u00eb\u00e9\u009c\u001f\u0000C\u0098p\u00e6\u0004\u00f6\u00b6AN\u00ef-\u00bc";
                    var4_3 = "\u008f\u0081\u0087b\u00eb\u00ac\u00ff\u00bc2f\u001a\u00cec2\u00a0\u00f0\u009e8\u00e2\u0003\u00ba^J\u00fe\u00d6\u0098H\u00fe\u001a\u0014\u00a2\u00d1\u000f\u00eb\u00e9\u009c\u001f\u0000C\u0098p\u00e6\u0004\u00f6\u00b6AN\u00ef-\u00bc".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 10;
                            break;
                        }
                        case 1: {
                            v15 = 67;
                            break;
                        }
                        case 2: {
                            v15 = 38;
                            break;
                        }
                        case 3: {
                            v15 = 117;
                            break;
                        }
                        case 4: {
                            v15 = 22;
                            break;
                        }
                        case 5: {
                            v15 = 101;
                            break;
                        }
                        default: {
                            v15 = 107;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x3E0C) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 225;
                case 1 -> 107;
                case 2 -> 128;
                case 3 -> 8;
                case 4 -> 25;
                case 5 -> 72;
                case 6 -> 231;
                case 7 -> 186;
                case 8 -> 46;
                case 9 -> 136;
                case 10 -> 101;
                case 11 -> 188;
                case 12 -> 145;
                case 13 -> 15;
                case 14 -> 122;
                case 15 -> 55;
                case 16 -> 153;
                case 17 -> 125;
                case 18 -> 180;
                case 19 -> 209;
                case 20 -> 116;
                case 21 -> 134;
                case 22 -> 236;
                case 23 -> 233;
                case 24 -> 13;
                case 25 -> 198;
                case 26 -> 144;
                case 27 -> 66;
                case 28 -> 207;
                case 29 -> 205;
                case 30 -> 4;
                case 31 -> 77;
                case 32 -> 178;
                case 33 -> 245;
                case 34 -> 140;
                case 35 -> 219;
                case 36 -> 138;
                case 37 -> 0;
                case 38 -> 92;
                case 39 -> 36;
                case 40 -> 90;
                case 41 -> 248;
                case 42 -> 50;
                case 43 -> 222;
                case 44 -> 237;
                case 45 -> 57;
                case 46 -> 118;
                case 47 -> 221;
                case 48 -> 124;
                case 49 -> 19;
                case 50 -> 179;
                case 51 -> 204;
                case 52 -> 56;
                case 53 -> 202;
                case 54 -> 7;
                case 55 -> 200;
                case 56 -> 16;
                case 57 -> 70;
                case 58 -> 44;
                case 59 -> 5;
                case 60 -> 79;
                case 61 -> 121;
                case 62 -> 249;
                case 63 -> 26;
                case 64 -> 113;
                case 65 -> 147;
                case 66 -> 224;
                case 67 -> 170;
                case 68 -> 220;
                case 69 -> 206;
                case 70 -> 86;
                case 71 -> 216;
                case 72 -> 38;
                case 73 -> 112;
                case 74 -> 246;
                case 75 -> 52;
                case 76 -> 161;
                case 77 -> 189;
                case 78 -> 215;
                case 79 -> 62;
                case 80 -> 68;
                case 81 -> 47;
                case 82 -> 152;
                case 83 -> 133;
                case 84 -> 88;
                case 85 -> 78;
                case 86 -> 130;
                case 87 -> 42;
                case 88 -> 32;
                case 89 -> 250;
                case 90 -> 123;
                case 91 -> 184;
                case 92 -> 181;
                case 93 -> 226;
                case 94 -> 60;
                case 95 -> 172;
                case 96 -> 191;
                case 97 -> 20;
                case 98 -> 73;
                case 99 -> 243;
                case 100 -> 166;
                case 101 -> 17;
                case 102 -> 28;
                case 103 -> 76;
                case 104 -> 109;
                case 105 -> 65;
                case 106 -> 169;
                case 107 -> 177;
                case 108 -> 61;
                case 109 -> 242;
                case 110 -> 29;
                case 111 -> 41;
                case 112 -> 40;
                case 113 -> 59;
                case 114 -> 129;
                case 115 -> 49;
                case 116 -> 54;
                case 117 -> 71;
                case 118 -> 37;
                case 119 -> 33;
                case 120 -> 196;
                case 121 -> 51;
                case 122 -> 3;
                case 123 -> 75;
                case 124 -> 230;
                case 125 -> 94;
                case 126 -> 218;
                case 127 -> 58;
                case 128 -> 106;
                case 129 -> 120;
                case 130 -> 87;
                case 131 -> 108;
                case 132 -> 252;
                case 133 -> 199;
                case 134 -> 35;
                case 135 -> 127;
                case 136 -> 254;
                case 137 -> 173;
                case 138 -> 148;
                case 139 -> 83;
                case 140 -> 89;
                case 141 -> 234;
                case 142 -> 48;
                case 143 -> 27;
                case 144 -> 255;
                case 145 -> 34;
                case 146 -> 223;
                case 147 -> 239;
                case 148 -> 9;
                case 149 -> 99;
                case 150 -> 167;
                case 151 -> 110;
                case 152 -> 103;
                case 153 -> 210;
                case 154 -> 146;
                case 155 -> 139;
                case 156 -> 141;
                case 157 -> 217;
                case 158 -> 117;
                case 159 -> 137;
                case 160 -> 80;
                case 161 -> 10;
                case 162 -> 126;
                case 163 -> 156;
                case 164 -> 232;
                case 165 -> 171;
                case 166 -> 195;
                case 167 -> 142;
                case 168 -> 227;
                case 169 -> 175;
                case 170 -> 23;
                case 171 -> 102;
                case 172 -> 162;
                case 173 -> 164;
                case 174 -> 95;
                case 175 -> 214;
                case 176 -> 114;
                case 177 -> 201;
                case 178 -> 67;
                case 179 -> 131;
                case 180 -> 91;
                case 181 -> 97;
                case 182 -> 235;
                case 183 -> 158;
                case 184 -> 96;
                case 185 -> 74;
                case 186 -> 157;
                case 187 -> 53;
                case 188 -> 155;
                case 189 -> 135;
                case 190 -> 111;
                case 191 -> 119;
                case 192 -> 63;
                case 193 -> 143;
                case 194 -> 212;
                case 195 -> 149;
                case 196 -> 39;
                case 197 -> 2;
                case 198 -> 150;
                case 199 -> 165;
                case 200 -> 45;
                case 201 -> 213;
                case 202 -> 93;
                case 203 -> 194;
                case 204 -> 151;
                case 205 -> 11;
                case 206 -> 18;
                case 207 -> 85;
                case 208 -> 183;
                case 209 -> 241;
                case 210 -> 154;
                case 211 -> 24;
                case 212 -> 160;
                case 213 -> 240;
                case 214 -> 64;
                case 215 -> 132;
                case 216 -> 197;
                case 217 -> 159;
                case 218 -> 22;
                case 219 -> 168;
                case 220 -> 192;
                case 221 -> 30;
                case 222 -> 105;
                case 223 -> 98;
                case 224 -> 14;
                case 225 -> 211;
                case 226 -> 190;
                case 227 -> 182;
                case 228 -> 104;
                case 229 -> 12;
                case 230 -> 69;
                case 231 -> 238;
                case 232 -> 187;
                case 233 -> 228;
                case 234 -> 174;
                case 235 -> 100;
                case 236 -> 43;
                case 237 -> 176;
                case 238 -> 253;
                case 239 -> 229;
                case 240 -> 247;
                case 241 -> 82;
                case 242 -> 6;
                case 243 -> 251;
                case 244 -> 84;
                case 245 -> 185;
                case 246 -> 208;
                case 247 -> 244;
                case 248 -> 163;
                case 249 -> 193;
                case 250 -> 31;
                case 251 -> 81;
                case 252 -> 203;
                case 253 -> 1;
                case 254 -> 115;
                default -> 21;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 39795298039990L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1868927130 - -1895, -1868927130 + -23902, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 44224161264635L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.o();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1116978540 + -1299, -1116978540 + -8001, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1116978540 + -1298, -1116978540 + -3786, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1116978540 + -1297, -1116978540 + -1450, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00f9\u0015Z\u00e2\u00ef&\u00e7\f\u0010\u009flgl\u00f2L\u00bd\u0018\u00baF\u00f0e+\u009bM(";
                    var4_3 = "\u00f9\u0015Z\u00e2\u00ef&\u00e7\f\u0010\u009flgl\u00f2L\u00bd\u0018\u00baF\u00f0e+\u009bM(".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 53;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00f0\u0001\u0006\u001di5\u0083\u008e\u007f\u0080\u0094\u0095\u0014\u00f5\u0085=\u00f8\u00b7\u00a0VDf\u00f8T\u00c2\u0098\u0092\u0011\u00f3?K\u00dfK\u007f\u0010\u00d2BW\u00e1\u00a69e\u0094{\u00b9\u00d0\u00a7\u00d79\u00b3\u0005\u00a2i\u00ber*\u00feX\u00ec";
                        var4_3 = "\u00f0\u0001\u0006\u001di5\u0083\u008e\u007f\u0080\u0094\u0095\u0014\u00f5\u0085=\u00f8\u00b7\u00a0VDf\u00f8T\u00c2\u0098\u0092\u0011\u00f3?K\u00dfK\u007f\u0010\u00d2BW\u00e1\u00a69e\u0094{\u00b9\u00d0\u00a7\u00d79\u00b3\u0005\u00a2i\u00ber*\u00feX\u00ec".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 15;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 30;
                                break;
                            }
                            case 1: {
                                v15 = 7;
                                break;
                            }
                            case 2: {
                                v15 = 59;
                                break;
                            }
                            case 3: {
                                v15 = 18;
                                break;
                            }
                            case 4: {
                                v15 = 126;
                                break;
                            }
                            case 5: {
                                v15 = 3;
                                break;
                            }
                            default: {
                                v15 = 104;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xE7B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 37;
                    case 1 -> 79;
                    case 2 -> 93;
                    case 3 -> 58;
                    case 4 -> 193;
                    case 5 -> 183;
                    case 6 -> 221;
                    case 7 -> 14;
                    case 8 -> 246;
                    case 9 -> 174;
                    case 10 -> 124;
                    case 11 -> 3;
                    case 12 -> 230;
                    case 13 -> 178;
                    case 14 -> 99;
                    case 15 -> 153;
                    case 16 -> 139;
                    case 17 -> 223;
                    case 18 -> 74;
                    case 19 -> 212;
                    case 20 -> 150;
                    case 21 -> 8;
                    case 22 -> 236;
                    case 23 -> 203;
                    case 24 -> 130;
                    case 25 -> 96;
                    case 26 -> 241;
                    case 27 -> 184;
                    case 28 -> 214;
                    case 29 -> 157;
                    case 30 -> 252;
                    case 31 -> 64;
                    case 32 -> 121;
                    case 33 -> 41;
                    case 34 -> 48;
                    case 35 -> 205;
                    case 36 -> 20;
                    case 37 -> 180;
                    case 38 -> 86;
                    case 39 -> 24;
                    case 40 -> 5;
                    case 41 -> 137;
                    case 42 -> 127;
                    case 43 -> 166;
                    case 44 -> 167;
                    case 45 -> 202;
                    case 46 -> 109;
                    case 47 -> 207;
                    case 48 -> 91;
                    case 49 -> 103;
                    case 50 -> 6;
                    case 51 -> 102;
                    case 52 -> 191;
                    case 53 -> 225;
                    case 54 -> 254;
                    case 55 -> 222;
                    case 56 -> 239;
                    case 57 -> 77;
                    case 58 -> 72;
                    case 59 -> 248;
                    case 60 -> 234;
                    case 61 -> 115;
                    case 62 -> 164;
                    case 63 -> 27;
                    case 64 -> 0;
                    case 65 -> 76;
                    case 66 -> 19;
                    case 67 -> 65;
                    case 68 -> 35;
                    case 69 -> 67;
                    case 70 -> 255;
                    case 71 -> 1;
                    case 72 -> 89;
                    case 73 -> 147;
                    case 74 -> 9;
                    case 75 -> 31;
                    case 76 -> 245;
                    case 77 -> 85;
                    case 78 -> 206;
                    case 79 -> 190;
                    case 80 -> 220;
                    case 81 -> 224;
                    case 82 -> 18;
                    case 83 -> 226;
                    case 84 -> 118;
                    case 85 -> 182;
                    case 86 -> 92;
                    case 87 -> 169;
                    case 88 -> 163;
                    case 89 -> 60;
                    case 90 -> 101;
                    case 91 -> 94;
                    case 92 -> 219;
                    case 93 -> 138;
                    case 94 -> 247;
                    case 95 -> 13;
                    case 96 -> 22;
                    case 97 -> 170;
                    case 98 -> 128;
                    case 99 -> 199;
                    case 100 -> 88;
                    case 101 -> 141;
                    case 102 -> 162;
                    case 103 -> 250;
                    case 104 -> 70;
                    case 105 -> 231;
                    case 106 -> 10;
                    case 107 -> 50;
                    case 108 -> 165;
                    case 109 -> 145;
                    case 110 -> 187;
                    case 111 -> 36;
                    case 112 -> 171;
                    case 113 -> 200;
                    case 114 -> 39;
                    case 115 -> 69;
                    case 116 -> 227;
                    case 117 -> 232;
                    case 118 -> 2;
                    case 119 -> 73;
                    case 120 -> 233;
                    case 121 -> 194;
                    case 122 -> 155;
                    case 123 -> 106;
                    case 124 -> 33;
                    case 125 -> 144;
                    case 126 -> 53;
                    case 127 -> 175;
                    case 128 -> 192;
                    case 129 -> 122;
                    case 130 -> 80;
                    case 131 -> 158;
                    case 132 -> 87;
                    case 133 -> 188;
                    case 134 -> 152;
                    case 135 -> 168;
                    case 136 -> 134;
                    case 137 -> 196;
                    case 138 -> 173;
                    case 139 -> 15;
                    case 140 -> 116;
                    case 141 -> 25;
                    case 142 -> 235;
                    case 143 -> 49;
                    case 144 -> 57;
                    case 145 -> 209;
                    case 146 -> 105;
                    case 147 -> 90;
                    case 148 -> 23;
                    case 149 -> 107;
                    case 150 -> 204;
                    case 151 -> 198;
                    case 152 -> 54;
                    case 153 -> 251;
                    case 154 -> 140;
                    case 155 -> 40;
                    case 156 -> 161;
                    case 157 -> 71;
                    case 158 -> 56;
                    case 159 -> 47;
                    case 160 -> 125;
                    case 161 -> 97;
                    case 162 -> 132;
                    case 163 -> 142;
                    case 164 -> 7;
                    case 165 -> 249;
                    case 166 -> 30;
                    case 167 -> 66;
                    case 168 -> 78;
                    case 169 -> 112;
                    case 170 -> 51;
                    case 171 -> 215;
                    case 172 -> 156;
                    case 173 -> 62;
                    case 174 -> 117;
                    case 175 -> 81;
                    case 176 -> 228;
                    case 177 -> 104;
                    case 178 -> 83;
                    case 179 -> 148;
                    case 180 -> 213;
                    case 181 -> 176;
                    case 182 -> 238;
                    case 183 -> 17;
                    case 184 -> 185;
                    case 185 -> 82;
                    case 186 -> 46;
                    case 187 -> 59;
                    case 188 -> 211;
                    case 189 -> 195;
                    case 190 -> 108;
                    case 191 -> 154;
                    case 192 -> 208;
                    case 193 -> 119;
                    case 194 -> 149;
                    case 195 -> 111;
                    case 196 -> 68;
                    case 197 -> 136;
                    case 198 -> 21;
                    case 199 -> 45;
                    case 200 -> 98;
                    case 201 -> 172;
                    case 202 -> 29;
                    case 203 -> 63;
                    case 204 -> 34;
                    case 205 -> 189;
                    case 206 -> 55;
                    case 207 -> 110;
                    case 208 -> 151;
                    case 209 -> 242;
                    case 210 -> 28;
                    case 211 -> 95;
                    case 212 -> 113;
                    case 213 -> 181;
                    case 214 -> 244;
                    case 215 -> 26;
                    case 216 -> 177;
                    case 217 -> 133;
                    case 218 -> 126;
                    case 219 -> 186;
                    case 220 -> 43;
                    case 221 -> 218;
                    case 222 -> 229;
                    case 223 -> 16;
                    case 224 -> 197;
                    case 225 -> 160;
                    case 226 -> 61;
                    case 227 -> 131;
                    case 228 -> 210;
                    case 229 -> 4;
                    case 230 -> 216;
                    case 231 -> 114;
                    case 232 -> 12;
                    case 233 -> 42;
                    case 234 -> 100;
                    case 235 -> 253;
                    case 236 -> 123;
                    case 237 -> 84;
                    case 238 -> 129;
                    case 239 -> 52;
                    case 240 -> 75;
                    case 241 -> 146;
                    case 242 -> 243;
                    case 243 -> 135;
                    case 244 -> 237;
                    case 245 -> 120;
                    case 246 -> 201;
                    case 247 -> 179;
                    case 248 -> 217;
                    case 249 -> 11;
                    case 250 -> 44;
                    case 251 -> 240;
                    case 252 -> 159;
                    case 253 -> 38;
                    case 254 -> 32;
                    default -> 143;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 139935697548341L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "f?`a\u0019\u0019\u001d?\ta5skT[\u0000#s";
                    var5_4 = "f?`a\u0019\u0019\u001d?\ta5skT[\u0000#s".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 58;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 55;
                                    break;
                                }
                                case 1: {
                                    v11 = 96;
                                    break;
                                }
                                case 2: {
                                    v11 = 40;
                                    break;
                                }
                                case 3: {
                                    v11 = 53;
                                    break;
                                }
                                case 4: {
                                    v11 = 70;
                                    break;
                                }
                                case 5: {
                                    v11 = 79;
                                    break;
                                }
                                default: {
                                    v11 = 20;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 139777165146046L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "!\u0012l\u0003\u0000:B\u0004'\f`\u0019\n+\u0013k\u0019\f8Z\u0001\u0012b\t+\u0013k\u0019\f8Z\r\u0018\r,\u0015v\u0014\u00065@\r\u001fq\u001e\u0007<";
                    var5_4 = "!\u0012l\u0003\u0000:B\u0004'\f`\u0019\n+\u0013k\u0019\f8Z\u0001\u0012b\t+\u0013k\u0019\f8Z\r\u0018\r,\u0015v\u0014\u00065@\r\u001fq\u001e\u0007<".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 87;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "^e\u001fqu@<\u0006^e\u001fqyJ";
                        var5_4 = "^e\u001fqu@<\u0006^e\u001fqyJ".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 34;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 63;
                                break;
                            }
                            case 1: {
                                v15 = 43;
                                break;
                            }
                            case 2: {
                                v15 = 82;
                                break;
                            }
                            case 3: {
                                v15 = 32;
                                break;
                            }
                            case 4: {
                                v15 = 62;
                                break;
                            }
                            case 5: {
                                v15 = 12;
                                break;
                            }
                            default: {
                                v15 = 121;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 67598306426721L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-183891210 - -((char)-22332), 183891210 - (char)-7060, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 113908006723005L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00c6\u00b6\u000ew\u00d8\u0003\u00bc\u008d\u00f5\u0005\u00bf\u0097\u0007\u0097\u001a\r>$\u0001\u00ab/X\u00b8\u00c9\u00a6m\u00b5c\u001c\u0010c\u00b7m2\u009d\u00fe\u00c5 \u00c0\u00d4\u009a\u0019\u001f\u0081\u00a5\u001e\u0005\u0093\u0019\u0082F\u00aa3 \\\u00e5\u0099Y\u00cfm\u0012\u00a8o\u001cG\t\u001bKR\u00c1\u0091\u00c1$\u00bd\u0093x\u000f\u00a9\u0015\u00fa\u0098\u008b\u0092\u00e6Z\u00e7\u00a5\u00f1}\u007f\u00d2,\u00bc\u008c\u00e8^np3\u00fa\u00a2a\u008ad";
                    var4_3 = "\u00c6\u00b6\u000ew\u00d8\u0003\u00bc\u008d\u00f5\u0005\u00bf\u0097\u0007\u0097\u001a\r>$\u0001\u00ab/X\u00b8\u00c9\u00a6m\u00b5c\u001c\u0010c\u00b7m2\u009d\u00fe\u00c5 \u00c0\u00d4\u009a\u0019\u001f\u0081\u00a5\u001e\u0005\u0093\u0019\u0082F\u00aa3 \\\u00e5\u0099Y\u00cfm\u0012\u00a8o\u001cG\t\u001bKR\u00c1\u0091\u00c1$\u00bd\u0093x\u000f\u00a9\u0015\u00fa\u0098\u008b\u0092\u00e6Z\u00e7\u00a5\u00f1}\u007f\u00d2,\u00bc\u008c\u00e8^np3\u00fa\u00a2a\u008ad".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 113;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00c5\u00ee\u00f8Xn\u00f2\u00fa\u00e0f\u008d\u000fs\u00ec\u008d\u009a\u00deL,\u000f2\u00ae\u001d\u00e4\u00faL\u00ef\u008b\u0092\nQ,\u00be\u0093;9 \u0086\u00a8\u00e2\u00b1\u00c2\u00f2\u0006\u00f5}\u00d1&\u0003\u00e2\n\u001d|7\u00bd\u0004\u000fA\u009f\u00eb\u00b22\u00b9'IY\u00a4\u0080u0\u00eeEu\u00ea\u00b2\u00bcv\u00d7\u0091@\u00bdUG\u00b1\u008e3\u00b8\u00f0\u00d5\u00d8\u00b9o}\u00db";
                        var4_3 = "\u00c5\u00ee\u00f8Xn\u00f2\u00fa\u00e0f\u008d\u000fs\u00ec\u008d\u009a\u00deL,\u000f2\u00ae\u001d\u00e4\u00faL\u00ef\u008b\u0092\nQ,\u00be\u0093;9 \u0086\u00a8\u00e2\u00b1\u00c2\u00f2\u0006\u00f5}\u00d1&\u0003\u00e2\n\u001d|7\u00bd\u0004\u000fA\u009f\u00eb\u00b22\u00b9'IY\u00a4\u0080u0\u00eeEu\u00ea\u00b2\u00bcv\u00d7\u0091@\u00bdUG\u00b1\u008e3\u00b8\u00f0\u00d5\u00d8\u00b9o}\u00db".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 57;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 54;
                                break;
                            }
                            case 1: {
                                v15 = 48;
                                break;
                            }
                            case 2: {
                                v15 = 103;
                                break;
                            }
                            case 3: {
                                v15 = 29;
                                break;
                            }
                            case 4: {
                                v15 = 23;
                                break;
                            }
                            case 5: {
                                v15 = 87;
                                break;
                            }
                            default: {
                                v15 = 28;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xCDB) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 140;
                    case 1 -> 139;
                    case 2 -> 2;
                    case 3 -> 190;
                    case 4 -> 157;
                    case 5 -> 116;
                    case 6 -> 165;
                    case 7 -> 44;
                    case 8 -> 221;
                    case 9 -> 112;
                    case 10 -> 123;
                    case 11 -> 11;
                    case 12 -> 146;
                    case 13 -> 17;
                    case 14 -> 169;
                    case 15 -> 144;
                    case 16 -> 194;
                    case 17 -> 27;
                    case 18 -> 79;
                    case 19 -> 100;
                    case 20 -> 176;
                    case 21 -> 95;
                    case 22 -> 195;
                    case 23 -> 224;
                    case 24 -> 72;
                    case 25 -> 214;
                    case 26 -> 171;
                    case 27 -> 192;
                    case 28 -> 235;
                    case 29 -> 168;
                    case 30 -> 16;
                    case 31 -> 89;
                    case 32 -> 141;
                    case 33 -> 48;
                    case 34 -> 149;
                    case 35 -> 64;
                    case 36 -> 28;
                    case 37 -> 174;
                    case 38 -> 47;
                    case 39 -> 80;
                    case 40 -> 250;
                    case 41 -> 98;
                    case 42 -> 92;
                    case 43 -> 0;
                    case 44 -> 69;
                    case 45 -> 186;
                    case 46 -> 45;
                    case 47 -> 145;
                    case 48 -> 61;
                    case 49 -> 1;
                    case 50 -> 7;
                    case 51 -> 18;
                    case 52 -> 71;
                    case 53 -> 154;
                    case 54 -> 121;
                    case 55 -> 97;
                    case 56 -> 86;
                    case 57 -> 58;
                    case 58 -> 83;
                    case 59 -> 131;
                    case 60 -> 222;
                    case 61 -> 129;
                    case 62 -> 120;
                    case 63 -> 106;
                    case 64 -> 182;
                    case 65 -> 208;
                    case 66 -> 12;
                    case 67 -> 161;
                    case 68 -> 56;
                    case 69 -> 125;
                    case 70 -> 251;
                    case 71 -> 210;
                    case 72 -> 88;
                    case 73 -> 187;
                    case 74 -> 234;
                    case 75 -> 135;
                    case 76 -> 133;
                    case 77 -> 68;
                    case 78 -> 20;
                    case 79 -> 181;
                    case 80 -> 4;
                    case 81 -> 115;
                    case 82 -> 23;
                    case 83 -> 96;
                    case 84 -> 127;
                    case 85 -> 219;
                    case 86 -> 212;
                    case 87 -> 245;
                    case 88 -> 211;
                    case 89 -> 223;
                    case 90 -> 117;
                    case 91 -> 220;
                    case 92 -> 204;
                    case 93 -> 41;
                    case 94 -> 196;
                    case 95 -> 109;
                    case 96 -> 78;
                    case 97 -> 22;
                    case 98 -> 108;
                    case 99 -> 46;
                    case 100 -> 65;
                    case 101 -> 233;
                    case 102 -> 201;
                    case 103 -> 188;
                    case 104 -> 248;
                    case 105 -> 200;
                    case 106 -> 138;
                    case 107 -> 91;
                    case 108 -> 209;
                    case 109 -> 151;
                    case 110 -> 150;
                    case 111 -> 183;
                    case 112 -> 113;
                    case 113 -> 229;
                    case 114 -> 66;
                    case 115 -> 57;
                    case 116 -> 126;
                    case 117 -> 202;
                    case 118 -> 137;
                    case 119 -> 51;
                    case 120 -> 156;
                    case 121 -> 101;
                    case 122 -> 73;
                    case 123 -> 173;
                    case 124 -> 216;
                    case 125 -> 13;
                    case 126 -> 170;
                    case 127 -> 49;
                    case 128 -> 90;
                    case 129 -> 31;
                    case 130 -> 38;
                    case 131 -> 193;
                    case 132 -> 160;
                    case 133 -> 36;
                    case 134 -> 40;
                    case 135 -> 37;
                    case 136 -> 152;
                    case 137 -> 205;
                    case 138 -> 85;
                    case 139 -> 29;
                    case 140 -> 54;
                    case 141 -> 25;
                    case 142 -> 242;
                    case 143 -> 53;
                    case 144 -> 180;
                    case 145 -> 191;
                    case 146 -> 218;
                    case 147 -> 84;
                    case 148 -> 143;
                    case 149 -> 50;
                    case 150 -> 162;
                    case 151 -> 93;
                    case 152 -> 249;
                    case 153 -> 153;
                    case 154 -> 237;
                    case 155 -> 197;
                    case 156 -> 70;
                    case 157 -> 110;
                    case 158 -> 75;
                    case 159 -> 15;
                    case 160 -> 24;
                    case 161 -> 122;
                    case 162 -> 253;
                    case 163 -> 30;
                    case 164 -> 8;
                    case 165 -> 213;
                    case 166 -> 77;
                    case 167 -> 74;
                    case 168 -> 254;
                    case 169 -> 34;
                    case 170 -> 87;
                    case 171 -> 185;
                    case 172 -> 9;
                    case 173 -> 35;
                    case 174 -> 217;
                    case 175 -> 82;
                    case 176 -> 158;
                    case 177 -> 33;
                    case 178 -> 114;
                    case 179 -> 6;
                    case 180 -> 155;
                    case 181 -> 94;
                    case 182 -> 128;
                    case 183 -> 236;
                    case 184 -> 124;
                    case 185 -> 148;
                    case 186 -> 19;
                    case 187 -> 99;
                    case 188 -> 62;
                    case 189 -> 246;
                    case 190 -> 231;
                    case 191 -> 76;
                    case 192 -> 228;
                    case 193 -> 132;
                    case 194 -> 206;
                    case 195 -> 247;
                    case 196 -> 42;
                    case 197 -> 14;
                    case 198 -> 240;
                    case 199 -> 63;
                    case 200 -> 203;
                    case 201 -> 167;
                    case 202 -> 118;
                    case 203 -> 134;
                    case 204 -> 241;
                    case 205 -> 175;
                    case 206 -> 147;
                    case 207 -> 159;
                    case 208 -> 119;
                    case 209 -> 5;
                    case 210 -> 207;
                    case 211 -> 107;
                    case 212 -> 199;
                    case 213 -> 21;
                    case 214 -> 103;
                    case 215 -> 243;
                    case 216 -> 81;
                    case 217 -> 178;
                    case 218 -> 164;
                    case 219 -> 226;
                    case 220 -> 252;
                    case 221 -> 10;
                    case 222 -> 111;
                    case 223 -> 136;
                    case 224 -> 244;
                    case 225 -> 230;
                    case 226 -> 102;
                    case 227 -> 39;
                    case 228 -> 166;
                    case 229 -> 43;
                    case 230 -> 239;
                    case 231 -> 130;
                    case 232 -> 184;
                    case 233 -> 198;
                    case 234 -> 104;
                    case 235 -> 189;
                    case 236 -> 238;
                    case 237 -> 172;
                    case 238 -> 59;
                    case 239 -> 215;
                    case 240 -> 67;
                    case 241 -> 179;
                    case 242 -> 163;
                    case 243 -> 255;
                    case 244 -> 177;
                    case 245 -> 55;
                    case 246 -> 225;
                    case 247 -> 142;
                    case 248 -> 105;
                    case 249 -> 60;
                    case 250 -> 232;
                    case 251 -> 32;
                    case 252 -> 3;
                    case 253 -> 26;
                    case 254 -> 52;
                    default -> 227;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 19162505223522L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1638768210 + -((char)-4202), -1638899280 - -((char)-12424), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 57558781025024L;
                    String string = SshAgentIpcService.o();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1924238670 + (char)-22739, -1924238670 + -30158, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 4777368912590L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00b1\u008d\u0010K\u00ba\u0003\u0087\u00dd\u0080";
                var4_3 = "\u00b1\u008d\u0010K\u00ba\u0003\u0087\u00dd\u0080".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 91;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 107;
                                break;
                            }
                            case 1: {
                                v11 = 115;
                                break;
                            }
                            case 2: {
                                v11 = 83;
                                break;
                            }
                            case 3: {
                                v11 = 65;
                                break;
                            }
                            case 4: {
                                v11 = 95;
                                break;
                            }
                            case 5: {
                                v11 = 86;
                                break;
                            }
                            default: {
                                v11 = 49;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x6F7A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 39;
                    case 1 -> 64;
                    case 2 -> 63;
                    case 3 -> 164;
                    case 4 -> 215;
                    case 5 -> 121;
                    case 6 -> 1;
                    case 7 -> 9;
                    case 8 -> 87;
                    case 9 -> 137;
                    case 10 -> 33;
                    case 11 -> 251;
                    case 12 -> 115;
                    case 13 -> 110;
                    case 14 -> 102;
                    case 15 -> 179;
                    case 16 -> 184;
                    case 17 -> 40;
                    case 18 -> 167;
                    case 19 -> 30;
                    case 20 -> 157;
                    case 21 -> 70;
                    case 22 -> 86;
                    case 23 -> 174;
                    case 24 -> 46;
                    case 25 -> 223;
                    case 26 -> 134;
                    case 27 -> 54;
                    case 28 -> 10;
                    case 29 -> 99;
                    case 30 -> 12;
                    case 31 -> 25;
                    case 32 -> 250;
                    case 33 -> 169;
                    case 34 -> 80;
                    case 35 -> 175;
                    case 36 -> 108;
                    case 37 -> 197;
                    case 38 -> 118;
                    case 39 -> 210;
                    case 40 -> 111;
                    case 41 -> 214;
                    case 42 -> 88;
                    case 43 -> 147;
                    case 44 -> 84;
                    case 45 -> 14;
                    case 46 -> 245;
                    case 47 -> 18;
                    case 48 -> 241;
                    case 49 -> 168;
                    case 50 -> 183;
                    case 51 -> 93;
                    case 52 -> 239;
                    case 53 -> 190;
                    case 54 -> 90;
                    case 55 -> 72;
                    case 56 -> 201;
                    case 57 -> 160;
                    case 58 -> 56;
                    case 59 -> 204;
                    case 60 -> 254;
                    case 61 -> 127;
                    case 62 -> 47;
                    case 63 -> 16;
                    case 64 -> 27;
                    case 65 -> 247;
                    case 66 -> 148;
                    case 67 -> 82;
                    case 68 -> 74;
                    case 69 -> 53;
                    case 70 -> 58;
                    case 71 -> 109;
                    case 72 -> 189;
                    case 73 -> 128;
                    case 74 -> 59;
                    case 75 -> 122;
                    case 76 -> 232;
                    case 77 -> 227;
                    case 78 -> 75;
                    case 79 -> 76;
                    case 80 -> 77;
                    case 81 -> 117;
                    case 82 -> 158;
                    case 83 -> 154;
                    case 84 -> 146;
                    case 85 -> 203;
                    case 86 -> 130;
                    case 87 -> 248;
                    case 88 -> 252;
                    case 89 -> 49;
                    case 90 -> 144;
                    case 91 -> 107;
                    case 92 -> 228;
                    case 93 -> 226;
                    case 94 -> 218;
                    case 95 -> 195;
                    case 96 -> 51;
                    case 97 -> 52;
                    case 98 -> 198;
                    case 99 -> 83;
                    case 100 -> 116;
                    case 101 -> 177;
                    case 102 -> 3;
                    case 103 -> 238;
                    case 104 -> 205;
                    case 105 -> 159;
                    case 106 -> 67;
                    case 107 -> 186;
                    case 108 -> 142;
                    case 109 -> 180;
                    case 110 -> 135;
                    case 111 -> 26;
                    case 112 -> 35;
                    case 113 -> 15;
                    case 114 -> 187;
                    case 115 -> 156;
                    case 116 -> 193;
                    case 117 -> 222;
                    case 118 -> 13;
                    case 119 -> 176;
                    case 120 -> 89;
                    case 121 -> 103;
                    case 122 -> 42;
                    case 123 -> 171;
                    case 124 -> 66;
                    case 125 -> 216;
                    case 126 -> 21;
                    case 127 -> 139;
                    case 128 -> 112;
                    case 129 -> 106;
                    case 130 -> 7;
                    case 131 -> 153;
                    case 132 -> 141;
                    case 133 -> 194;
                    case 134 -> 199;
                    case 135 -> 233;
                    case 136 -> 229;
                    case 137 -> 79;
                    case 138 -> 100;
                    case 139 -> 61;
                    case 140 -> 114;
                    case 141 -> 44;
                    case 142 -> 162;
                    case 143 -> 55;
                    case 144 -> 38;
                    case 145 -> 235;
                    case 146 -> 37;
                    case 147 -> 246;
                    case 148 -> 138;
                    case 149 -> 104;
                    case 150 -> 113;
                    case 151 -> 23;
                    case 152 -> 211;
                    case 153 -> 92;
                    case 154 -> 120;
                    case 155 -> 224;
                    case 156 -> 28;
                    case 157 -> 236;
                    case 158 -> 192;
                    case 159 -> 172;
                    case 160 -> 43;
                    case 161 -> 125;
                    case 162 -> 98;
                    case 163 -> 220;
                    case 164 -> 212;
                    case 165 -> 249;
                    case 166 -> 181;
                    case 167 -> 24;
                    case 168 -> 208;
                    case 169 -> 225;
                    case 170 -> 71;
                    case 171 -> 124;
                    case 172 -> 68;
                    case 173 -> 221;
                    case 174 -> 244;
                    case 175 -> 0;
                    case 176 -> 165;
                    case 177 -> 209;
                    case 178 -> 123;
                    case 179 -> 50;
                    case 180 -> 182;
                    case 181 -> 5;
                    case 182 -> 6;
                    case 183 -> 32;
                    case 184 -> 17;
                    case 185 -> 243;
                    case 186 -> 196;
                    case 187 -> 131;
                    case 188 -> 240;
                    case 189 -> 185;
                    case 190 -> 213;
                    case 191 -> 145;
                    case 192 -> 95;
                    case 193 -> 151;
                    case 194 -> 129;
                    case 195 -> 91;
                    case 196 -> 161;
                    case 197 -> 60;
                    case 198 -> 143;
                    case 199 -> 217;
                    case 200 -> 85;
                    case 201 -> 20;
                    case 202 -> 41;
                    case 203 -> 230;
                    case 204 -> 4;
                    case 205 -> 132;
                    case 206 -> 96;
                    case 207 -> 191;
                    case 208 -> 140;
                    case 209 -> 73;
                    case 210 -> 136;
                    case 211 -> 65;
                    case 212 -> 234;
                    case 213 -> 8;
                    case 214 -> 219;
                    case 215 -> 62;
                    case 216 -> 105;
                    case 217 -> 36;
                    case 218 -> 149;
                    case 219 -> 150;
                    case 220 -> 101;
                    case 221 -> 155;
                    case 222 -> 29;
                    case 223 -> 178;
                    case 224 -> 200;
                    case 225 -> 94;
                    case 226 -> 126;
                    case 227 -> 170;
                    case 228 -> 45;
                    case 229 -> 19;
                    case 230 -> 11;
                    case 231 -> 242;
                    case 232 -> 22;
                    case 233 -> 166;
                    case 234 -> 81;
                    case 235 -> 69;
                    case 236 -> 206;
                    case 237 -> 237;
                    case 238 -> 163;
                    case 239 -> 34;
                    case 240 -> 48;
                    case 241 -> 255;
                    case 242 -> 173;
                    case 243 -> 231;
                    case 244 -> 78;
                    case 245 -> 2;
                    case 246 -> 97;
                    case 247 -> 207;
                    case 248 -> 152;
                    case 249 -> 57;
                    case 250 -> 188;
                    case 251 -> 253;
                    case 252 -> 133;
                    case 253 -> 119;
                    case 254 -> 202;
                    default -> 31;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

