// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.psi.xml

import com.intellij.platform.syntax.psi.ElementTypeConverter
import com.intellij.platform.syntax.psi.ElementTypeConverterFactory
import com.intellij.platform.syntax.psi.elementTypeConverterOf
import com.intellij.xml.syntax.XmlSyntaxElementType
import com.intellij.xml.syntax.XmlSyntaxTokenType
import org.jetbrains.annotations.ApiStatus

internal class XmlElementTypeConverterExtension : ElementTypeConverterFactory {
  override fun getElementTypeConverter(): ElementTypeConverter = xmlElementTypeConverter
}

@ApiStatus.Internal
val xmlElementTypeConverter: ElementTypeConverter = elementTypeConverterOf(
  XmlSyntaxElementType.XML_DOCUMENT to XmlElementType.XML_DOCUMENT,
  XmlSyntaxElementType.XML_PROLOG to XmlElementType.XML_PROLOG,
  XmlSyntaxElementType.XML_DECL to XmlElementType.XML_DECL,
  XmlSyntaxElementType.XML_DOCTYPE to XmlElementType.XML_DOCTYPE,
  XmlSyntaxElementType.XML_ATTRIBUTE to XmlElementType.XML_ATTRIBUTE,
  XmlSyntaxElementType.XML_COMMENT to XmlElementType.XML_COMMENT,
  XmlSyntaxElementType.XML_TAG to XmlElementType.XML_TAG,
  XmlSyntaxElementType.XML_ELEMENT_DECL to XmlElementType.XML_ELEMENT_DECL,
  XmlSyntaxElementType.XML_CONDITIONAL_SECTION to XmlElementType.XML_CONDITIONAL_SECTION,
  XmlSyntaxElementType.XML_ATTLIST_DECL to XmlElementType.XML_ATTLIST_DECL,
  XmlSyntaxElementType.XML_NOTATION_DECL to XmlElementType.XML_NOTATION_DECL,
  XmlSyntaxElementType.XML_ENTITY_DECL to XmlElementType.XML_ENTITY_DECL,
  XmlSyntaxElementType.XML_ELEMENT_CONTENT_SPEC to XmlElementType.XML_ELEMENT_CONTENT_SPEC,
  XmlSyntaxElementType.XML_ELEMENT_CONTENT_GROUP to XmlElementType.XML_ELEMENT_CONTENT_GROUP,
  XmlSyntaxElementType.XML_ATTRIBUTE_DECL to XmlElementType.XML_ATTRIBUTE_DECL,
  XmlSyntaxElementType.XML_ATTRIBUTE_VALUE to XmlElementType.XML_ATTRIBUTE_VALUE,
  XmlSyntaxElementType.XML_ENTITY_REF to XmlElementType.XML_ENTITY_REF,
  XmlSyntaxElementType.XML_ENUMERATED_TYPE to XmlElementType.XML_ENUMERATED_TYPE,
  XmlSyntaxElementType.XML_PROCESSING_INSTRUCTION to XmlElementType.XML_PROCESSING_INSTRUCTION,
  XmlSyntaxElementType.XML_CDATA to XmlElementType.XML_CDATA,
  XmlSyntaxElementType.HTML_DOCUMENT to XmlElementType.HTML_DOCUMENT,
  XmlSyntaxElementType.HTML_TAG to XmlElementType.HTML_TAG,
  XmlSyntaxElementType.HTML_EMBEDDED_CONTENT to XmlElementType.HTML_EMBEDDED_CONTENT,
  XmlSyntaxElementType.XML_TEXT to XmlElementType.XML_TEXT,
  XmlSyntaxElementType.XML_FILE to XmlElementType.XML_FILE,
  XmlSyntaxElementType.XHTML_FILE to XmlElementType.XHTML_FILE,
  XmlSyntaxElementType.DTD_FILE to XmlElementType.DTD_FILE,
  XmlSyntaxElementType.XML_MARKUP_DECL to XmlElementType.XML_MARKUP_DECL,

    XmlSyntaxTokenType.XML_START_TAG_START to XmlTokenType.XML_START_TAG_START,
    XmlSyntaxTokenType.XML_END_TAG_START to XmlTokenType.XML_END_TAG_START,
    XmlSyntaxTokenType.XML_TAG_END to XmlTokenType.XML_TAG_END,
    XmlSyntaxTokenType.XML_EMPTY_ELEMENT_END to XmlTokenType.XML_EMPTY_ELEMENT_END,
    XmlSyntaxTokenType.XML_TAG_NAME to XmlTokenType.XML_TAG_NAME,
    XmlSyntaxTokenType.XML_NAME to XmlTokenType.XML_NAME,
    XmlSyntaxTokenType.XML_ATTRIBUTE_VALUE_TOKEN to XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN,
    XmlSyntaxTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER to XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER,
    XmlSyntaxTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER to XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER,
    XmlSyntaxTokenType.XML_EQ to XmlTokenType.XML_EQ,
    XmlSyntaxTokenType.XML_DATA_CHARACTERS to XmlTokenType.XML_DATA_CHARACTERS,
    XmlSyntaxTokenType.XML_TAG_CHARACTERS to XmlTokenType.XML_TAG_CHARACTERS,
    XmlSyntaxTokenType.XML_WHITE_SPACE to XmlTokenType.XML_WHITE_SPACE,
    XmlSyntaxTokenType.XML_REAL_WHITE_SPACE to XmlTokenType.XML_REAL_WHITE_SPACE,
    XmlSyntaxTokenType.XML_COMMENT_START to XmlTokenType.XML_COMMENT_START,
    XmlSyntaxTokenType.XML_COMMENT_END to XmlTokenType.XML_COMMENT_END,
    XmlSyntaxTokenType.XML_COMMENT_CHARACTERS to XmlTokenType.XML_COMMENT_CHARACTERS,
    XmlSyntaxTokenType.XML_DECL_START to XmlTokenType.XML_DECL_START,
    XmlSyntaxTokenType.XML_DECL_END to XmlTokenType.XML_DECL_END,
    XmlSyntaxTokenType.XML_DOCTYPE_START to XmlTokenType.XML_DOCTYPE_START,
    XmlSyntaxTokenType.XML_DOCTYPE_END to XmlTokenType.XML_DOCTYPE_END,
    XmlSyntaxTokenType.XML_DOCTYPE_SYSTEM to XmlTokenType.XML_DOCTYPE_SYSTEM,
    XmlSyntaxTokenType.XML_DOCTYPE_PUBLIC to XmlTokenType.XML_DOCTYPE_PUBLIC,
    XmlSyntaxTokenType.XML_MARKUP_START to XmlTokenType.XML_MARKUP_START,
    XmlSyntaxTokenType.XML_MARKUP_END to XmlTokenType.XML_MARKUP_END,
    XmlSyntaxTokenType.XML_CDATA_START to XmlTokenType.XML_CDATA_START,
    XmlSyntaxTokenType.XML_CONDITIONAL_SECTION_START to XmlTokenType.XML_CONDITIONAL_SECTION_START,
    XmlSyntaxTokenType.XML_CONDITIONAL_INCLUDE to XmlTokenType.XML_CONDITIONAL_INCLUDE,
    XmlSyntaxTokenType.XML_CONDITIONAL_IGNORE to XmlTokenType.XML_CONDITIONAL_IGNORE,
    XmlSyntaxTokenType.XML_CDATA_END to XmlTokenType.XML_CDATA_END,
    XmlSyntaxTokenType.XML_CONDITIONAL_SECTION_END to XmlTokenType.XML_CONDITIONAL_SECTION_END,
    XmlSyntaxTokenType.XML_ELEMENT_DECL_START to XmlTokenType.XML_ELEMENT_DECL_START,
    XmlSyntaxTokenType.XML_NOTATION_DECL_START to XmlTokenType.XML_NOTATION_DECL_START,
    XmlSyntaxTokenType.XML_ATTLIST_DECL_START to XmlTokenType.XML_ATTLIST_DECL_START,
    XmlSyntaxTokenType.XML_ENTITY_DECL_START to XmlTokenType.XML_ENTITY_DECL_START,
    XmlSyntaxTokenType.XML_PCDATA to XmlTokenType.XML_PCDATA,
    XmlSyntaxTokenType.XML_LEFT_PAREN to XmlTokenType.XML_LEFT_PAREN,
    XmlSyntaxTokenType.XML_RIGHT_PAREN to XmlTokenType.XML_RIGHT_PAREN,
    XmlSyntaxTokenType.XML_CONTENT_EMPTY to XmlTokenType.XML_CONTENT_EMPTY,
    XmlSyntaxTokenType.XML_CONTENT_ANY to XmlTokenType.XML_CONTENT_ANY,
    XmlSyntaxTokenType.XML_QUESTION to XmlTokenType.XML_QUESTION,
    XmlSyntaxTokenType.XML_STAR to XmlTokenType.XML_STAR,
    XmlSyntaxTokenType.XML_PLUS to XmlTokenType.XML_PLUS,
    XmlSyntaxTokenType.XML_BAR to XmlTokenType.XML_BAR,
    XmlSyntaxTokenType.XML_COMMA to XmlTokenType.XML_COMMA,
    XmlSyntaxTokenType.XML_AMP to XmlTokenType.XML_AMP,
    XmlSyntaxTokenType.XML_SEMI to XmlTokenType.XML_SEMI,
    XmlSyntaxTokenType.XML_PERCENT to XmlTokenType.XML_PERCENT,
    XmlSyntaxTokenType.XML_ATT_IMPLIED to XmlTokenType.XML_ATT_IMPLIED,
    XmlSyntaxTokenType.XML_ATT_REQUIRED to XmlTokenType.XML_ATT_REQUIRED,
    XmlSyntaxTokenType.XML_ATT_FIXED to XmlTokenType.XML_ATT_FIXED,
    XmlSyntaxTokenType.XML_ENTITY_REF_TOKEN to XmlTokenType.XML_ENTITY_REF_TOKEN,
    XmlSyntaxTokenType.TAG_WHITE_SPACE to XmlTokenType.TAG_WHITE_SPACE,
    XmlSyntaxTokenType.XML_PI_START to XmlTokenType.XML_PI_START,
    XmlSyntaxTokenType.XML_PI_END to XmlTokenType.XML_PI_END,
    XmlSyntaxTokenType.XML_PI_TARGET to XmlTokenType.XML_PI_TARGET,
    XmlSyntaxTokenType.XML_CHAR_ENTITY_REF to XmlTokenType.XML_CHAR_ENTITY_REF,
    XmlSyntaxTokenType.XML_BAD_CHARACTER to XmlTokenType.XML_BAD_CHARACTER,
    XmlSyntaxTokenType.XML_CONDITIONAL_COMMENT_START to XmlTokenType.XML_CONDITIONAL_COMMENT_START,
    XmlSyntaxTokenType.XML_CONDITIONAL_COMMENT_START_END to XmlTokenType.XML_CONDITIONAL_COMMENT_START_END,
    XmlSyntaxTokenType.XML_CONDITIONAL_COMMENT_END_START to XmlTokenType.XML_CONDITIONAL_COMMENT_END_START,
    XmlSyntaxTokenType.XML_CONDITIONAL_COMMENT_END to XmlTokenType.XML_CONDITIONAL_COMMENT_END,
)