// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.xml.psi.codeInsight;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface XmlAutoPopupEnabler {

  ExtensionPointName<XmlAutoPopupEnabler> EP_NAME = new ExtensionPointName<>("com.intellij.xml.autoPopupEnabler");

  boolean shouldShowPopup(PsiFile file, int offset);
}
