/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import com.github.dockerjava.core.dockerfile.Dockerfile;
import com.github.dockerjava.core.util.FilePathUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;

public class BuildImageCmdImpl
extends AbstrAsyncDockerCmd<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd {
    private InputStream tarInputStream;
    @Deprecated
    private String tag;
    private Set<String> tags;
    private Set<String> cacheFrom;
    private Boolean noCache;
    private Boolean remove = true;
    private Boolean quiet;
    private Boolean pull;
    private AuthConfigurations buildAuthConfigs;
    private File dockerFile;
    private String dockerFilePath;
    private File baseDirectory;
    private String cpusetcpus;
    private Long memory;
    private String cpushares;
    private Boolean forcerm;
    private Long memswap;
    private Long shmsize;
    private URI remote;
    private Map<String, String> buildArgs;
    private Map<String, String> labels;
    private String networkMode;
    private String platform;
    private String target;
    private Set<String> extraHosts;

    public BuildImageCmdImpl(BuildImageCmd.Exec exec2) {
        super(exec2);
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec2, File dockerFileOrFolder) {
        super(exec2);
        Objects.requireNonNull(dockerFileOrFolder, "dockerFolder is null");
        if (dockerFileOrFolder.isDirectory()) {
            this.withBaseDirectory(dockerFileOrFolder);
            this.withDockerfile(new File(dockerFileOrFolder, "Dockerfile"));
        } else {
            this.withDockerfile(dockerFileOrFolder);
        }
    }

    public BuildImageCmdImpl(BuildImageCmd.Exec exec2, InputStream tarInputStream) {
        super(exec2);
        Objects.requireNonNull(tarInputStream, "tarInputStream is null");
        this.withTarInputStream(tarInputStream);
    }

    @Override
    @Deprecated
    public String getTag() {
        return this.tag;
    }

    @Override
    @CheckForNull
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    @CheckForNull
    public Set<String> getCacheFrom() {
        return this.cacheFrom;
    }

    @Override
    public URI getRemote() {
        return this.remote;
    }

    @Override
    public Boolean hasNoCacheEnabled() {
        return this.noCache;
    }

    @Override
    public Boolean hasRemoveEnabled() {
        return this.remove;
    }

    @Override
    public Boolean isForcerm() {
        return this.forcerm;
    }

    @Override
    public Boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public Boolean hasPullEnabled() {
        return this.pull;
    }

    @Override
    public String getPathToDockerfile() {
        if (this.dockerFilePath != null) {
            return this.dockerFilePath;
        }
        if (this.baseDirectory != null && this.dockerFile != null) {
            return FilePathUtil.relativize(this.baseDirectory, this.dockerFile);
        }
        return null;
    }

    @Override
    public Long getMemory() {
        return this.memory;
    }

    @Override
    public Long getMemswap() {
        return this.memswap;
    }

    @Override
    public String getCpushares() {
        return this.cpushares;
    }

    @Override
    public String getCpusetcpus() {
        return this.cpusetcpus;
    }

    @Override
    public Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public String getNetworkMode() {
        return this.networkMode;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public AuthConfigurations getBuildAuthConfigs() {
        return this.buildAuthConfigs;
    }

    @Override
    public InputStream getTarInputStream() {
        return this.tarInputStream;
    }

    @Override
    public Long getShmsize() {
        return this.shmsize;
    }

    @Override
    public Set<String> getExtraHosts() {
        return this.extraHosts;
    }

    @Override
    @Deprecated
    public BuildImageCmdImpl withTag(String tag) {
        this.tag = Objects.requireNonNull(tag, "Tag is null");
        return this;
    }

    @Override
    public BuildImageCmd withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public BuildImageCmd withCacheFrom(Set<String> cacheFrom) {
        this.cacheFrom = cacheFrom;
        return this;
    }

    @Override
    public BuildImageCmd withRemote(URI remote) {
        this.remote = remote;
        return this;
    }

    @Override
    public BuildImageCmdImpl withNoCache(Boolean noCache2) {
        this.noCache = noCache2;
        return this;
    }

    @Override
    public BuildImageCmdImpl withRemove(Boolean rm2) {
        this.remove = rm2;
        return this;
    }

    @Override
    public BuildImageCmd withForcerm(Boolean forcerm) {
        this.forcerm = forcerm;
        return this;
    }

    @Override
    public BuildImageCmdImpl withQuiet(Boolean quiet2) {
        this.quiet = quiet2;
        return this;
    }

    @Override
    public BuildImageCmdImpl withPull(Boolean pull2) {
        this.pull = pull2;
        return this;
    }

    @Override
    public BuildImageCmd withMemory(Long memory2) {
        this.memory = memory2;
        return this;
    }

    @Override
    public BuildImageCmd withMemswap(Long memswap) {
        this.memswap = memswap;
        return this;
    }

    @Override
    public BuildImageCmd withCpushares(String cpushares) {
        this.cpushares = cpushares;
        return this;
    }

    @Override
    public BuildImageCmd withCpusetcpus(String cpusetcpus) {
        this.cpusetcpus = cpusetcpus;
        return this;
    }

    @Override
    public BuildImageCmd withBuildArg(String key, String value) {
        if (this.buildArgs == null) {
            this.buildArgs = new HashMap<String, String>();
        }
        this.buildArgs.put(key, value);
        return this;
    }

    @Override
    public BuildImageCmd withBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        return this;
    }

    @Override
    public BuildImageCmdImpl withDockerfile(File dockerfile) {
        Objects.requireNonNull(dockerfile);
        if (!dockerfile.exists()) {
            throw new IllegalArgumentException("Dockerfile does not exist");
        }
        if (!dockerfile.isFile()) {
            throw new IllegalArgumentException("Dockerfile is not a file");
        }
        if (this.baseDirectory == null) {
            this.withBaseDirectory(dockerfile.getParentFile());
        }
        this.dockerFile = dockerfile;
        try {
            this.withTarInputStream(new Dockerfile(dockerfile, this.baseDirectory).parse().buildDockerFolderTar());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public BuildImageCmd withDockerfilePath(String dockerfilePath) {
        this.dockerFilePath = Objects.requireNonNull(dockerfilePath, "dockerfilePath is null");
        return this;
    }

    @Override
    public BuildImageCmdImpl withTarInputStream(InputStream tarInputStream) {
        this.tarInputStream = Objects.requireNonNull(tarInputStream, "tarInputStream is null");
        return this;
    }

    @Override
    public BuildImageCmd withBuildAuthConfigs(AuthConfigurations authConfigs) {
        this.buildAuthConfigs = Objects.requireNonNull(authConfigs, "authConfig is null");
        return this;
    }

    @Override
    public BuildImageCmd withShmsize(Long shmsize) {
        this.shmsize = shmsize;
        return this;
    }

    @Override
    public BuildImageCmd withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public BuildImageCmd withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    @Override
    public BuildImageCmd withPlatform(String platform2) {
        this.platform = platform2;
        return this;
    }

    @Override
    public BuildImageCmd withTarget(String target2) {
        this.target = target2;
        return this;
    }

    @Override
    public BuildImageCmd withExtraHosts(Set<String> extraHosts) {
        this.extraHosts = extraHosts;
        return this;
    }

    @Override
    public void close() {
        super.close();
        try {
            this.tarInputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

