/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudConfigurationKt;
import com.intellij.docker.agent.DockerCliConnectionHintKt;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.cli.CliExecutor;
import com.intellij.docker.cli.DockerComposeCli;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/cli/DockerComposeCli;", "", "<init>", "()V", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerCliExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerCliExecutor.kt\ncom/intellij/docker/cli/DockerComposeCli\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,159:1\n14#2:160\n*S KotlinDebug\n*F\n+ 1 DockerCliExecutor.kt\ncom/intellij/docker/cli/DockerComposeCli\n*L\n26#1:160\n*E\n"})
public final class DockerComposeCli {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VERSION_COMMAND = "version";
    @NotNull
    private static final String SHORT_FLAG = "--short";
    @NotNull
    private static final Logger logger;

    private DockerComposeCli() {
    }

    @JvmStatic
    @NotNull
    public static final String getVersion(@NotNull DockerCloudConfiguration config2, @Nullable ProgressIndicator indicator) throws ExecutionException {
        return Companion.getVersion(config2, indicator);
    }

    @JvmStatic
    private static final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
        return DockerComposeCli.Companion.runCommand(indicator, cmd);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerComposeCli.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DockerComposeCli.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/docker/cli/DockerComposeCli$Companion;", "", "<init>", "()V", "VERSION_COMMAND", "", "SHORT_FLAG", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createExecutor", "Lcom/intellij/docker/cli/CliExecutor;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "additionalEnvs", "", "overrideComposeExePath", "(Lcom/intellij/docker/DockerCloudConfiguration;Ljava/util/Map;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getVersion", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runCommand", "Lcom/intellij/execution/process/ProcessOutput;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object createExecutor(@NotNull DockerCloudConfiguration var1_1, @NotNull Map<String, String> var2_2, @Nullable String var3_3, @NotNull Continuation<? super CliExecutor> $completion) {
            if (!($completion instanceof createExecutor.1)) ** GOTO lbl-1000
            var9_5 = $completion;
            if ((var9_5.label & -2147483648) != 0) {
                var9_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.createExecutor(null, null, null, (Continuation<? super CliExecutor>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = config;
                    $continuation.L$1 = additionalEnvs;
                    $continuation.L$2 = overrideComposeExePath;
                    $continuation.label = 1;
                    v0 = DockerCloudConfigurationKt.updateBinaryPaths(config, (Continuation<? super Unit>)$continuation);
                    if (v0 == var10_7) {
                        return var10_7;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    overrideComposeExePath = (String)$continuation.L$2;
                    additionalEnvs = (Map)$continuation.L$1;
                    config = (DockerCloudConfiguration)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    envVars = MapsKt.plus(DockerCliConnectionHintKt.createEnvVars(config.getCliConnectionHint()), (Map)additionalEnvs);
                    if (DockerComposeCliUtil.isUseComposeV2(config)) {
                        v1 = overrideComposeExePath;
                        if (v1 == null && (v1 = config.getDockerComposeExePath()) == null) {
                            throw new IllegalStateException("Docker compose exe path should be specified".toString());
                        }
                        var6_9 = v1;
                        var7_10 = config.getCliProcessCreator$intellij_clouds_docker();
                        v2 = (CliExecutor)new DockerCli(envVars, var6_9, var7_10){};
                    } else {
                        v3 = overrideComposeExePath;
                        if (v3 == null && (v3 = config.getDockerComposeExePath()) == null) {
                            throw new IllegalStateException("Docker compose exe path should be specified".toString());
                        }
                        v2 = new CliExecutor(v3, envVars, config.getCliProcessCreator$intellij_clouds_docker());
                    }
                    return v2;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static /* synthetic */ Object createExecutor$default(Companion companion, DockerCloudConfiguration dockerCloudConfiguration, Map map2, String string, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                string = null;
            }
            return companion.createExecutor(dockerCloudConfiguration, map2, string, (Continuation<? super CliExecutor>)continuation);
        }

        @JvmStatic
        @NotNull
        public final String getVersion(@NotNull DockerCloudConfiguration config2, @Nullable ProgressIndicator indicator) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
            Object[] objectArray = new String[]{DockerComposeCli.VERSION_COMMAND, DockerComposeCli.SHORT_FLAG};
            GeneralCommandLine generalCommandLine = DockerComposeCliUtil.createDockerComposeCommandlineBlocking$default(config2, null, false, 6, null).withParameters((String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
            GeneralCommandLine cmd = generalCommandLine;
            ProcessOutput processOutput2 = this.runCommand(indicator, cmd);
            if (processOutput2.getExitCode() != 0 || processOutput2.isTimeout()) {
                if (processOutput2.isTimeout()) {
                    logger.debug(processOutput2.getStderr() + "\nTimed out");
                    throw new ExecutionException(DockerBundle.message("DockerComposeCli.error.version.command.time.out", new Object[0]));
                }
                logger.debug(processOutput2.getStderr() + "\nExit code " + processOutput2.getExitCode());
                objectArray = new Object[]{processOutput2.getExitCode()};
                throw new ExecutionException(DockerBundle.message("DockerComposeCli.error.version.command.nonzero.exit.code", objectArray));
            }
            String string = processOutput2.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String stdout = string;
            if (StringsKt.isBlank((CharSequence)stdout)) {
                Object[] objectArray2 = new Object[]{stdout};
                throw new ExecutionException(DockerBundle.message("DockerComposeCli.error.cant.find.version.in.output", objectArray2));
            }
            return ((Object)StringsKt.trim((CharSequence)stdout)).toString();
        }

        public static /* synthetic */ String getVersion$default(Companion companion, DockerCloudConfiguration dockerCloudConfiguration, ProgressIndicator progressIndicator, int n, Object object) throws ExecutionException {
            if ((n & 2) != 0) {
                progressIndicator = null;
            }
            return companion.getVersion(dockerCloudConfiguration, progressIndicator);
        }

        @JvmStatic
        private final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(cmd.getCommandLineList(null));
            Process process = null;
            try {
                process = processBuilder.start();
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            CapturingProcessHandler processHandler = new CapturingProcessHandler(process, cmd.getCharset(), cmd.getCommandLineString());
            if (indicator != null) {
                ProcessOutput processOutput2 = processHandler.runProcessWithProgressIndicator(indicator);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcessWithProgressIndicator(...)");
                return processOutput2;
            }
            ProcessOutput processOutput3 = processHandler.runProcess();
            Intrinsics.checkNotNullExpressionValue((Object)processOutput3, (String)"runProcess(...)");
            return processOutput3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

