/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.TerminalEventsHandler;
import com.intellij.terminal.frontend.TerminalInput;
import com.intellij.terminal.frontend.TerminalKeyEncodingManager;
import com.intellij.terminal.frontend.TerminalOutputScrollingModel;
import com.intellij.terminal.frontend.TimedKeyEvent;
import com.intellij.terminal.session.TerminalState;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalUsageLocalStorage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0010\u0018\u0000 ;2\u00020\u0001:\u0001;B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020 H\u0002J \u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J \u0010+\u001a\u00020\u00192\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J \u0010,\u001a\u00020\u00192\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J \u0010-\u001a\u00020\u00192\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J \u0010.\u001a\u00020\u00192\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020/H\u0016J!\u00100\u001a\u00020\u00112\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020302\"\u000203H\u0002\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u00106\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u00107\u001a\u00020#H\u0002J \u00108\u001a\u0002092\u0006\u0010:\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006<"}, d2={"Lcom/intellij/terminal/frontend/TerminalEventsHandlerImpl;", "Lcom/intellij/terminal/frontend/TerminalEventsHandler;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "encodingManager", "Lcom/intellij/terminal/frontend/TerminalKeyEncodingManager;", "terminalInput", "Lcom/intellij/terminal/frontend/TerminalInput;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "scrollingModel", "Lcom/intellij/terminal/frontend/TerminalOutputScrollingModel;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/terminal/frontend/TerminalKeyEncodingManager;Lcom/intellij/terminal/frontend/TerminalInput;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/frontend/TerminalOutputScrollingModel;)V", "ignoreNextKeyTypedEvent", "", "lastMotionReport", "Ljava/awt/Point;", "terminalState", "Lcom/intellij/terminal/session/TerminalState;", "getTerminalState", "()Lcom/intellij/terminal/session/TerminalState;", "keyTyped", "", "e", "Lcom/intellij/terminal/frontend/TimedKeyEvent;", "keyPressed", "processTerminalKeyPressed", "processCharacter", "isAltPressedOnly", "Ljava/awt/event/KeyEvent;", "isCodeThatScrolls", "keycode", "", "simpleMapKeyCodeToChar", "", "mousePressed", "x", "y", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseMoved", "mouseDragged", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "shouldSendMouseData", "eligibleModes", "", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "([Lcom/jediterm/terminal/emulator/mouse/MouseMode;)Z", "createButtonCode", "applyModifierKeys", "cb", "mouseReport", "", "button", "Companion", "intellij.terminal.frontend"})
public class TerminalEventsHandlerImpl
implements TerminalEventsHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalKeyEncodingManager encodingManager;
    @NotNull
    private final TerminalInput terminalInput;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @Nullable
    private final TerminalOutputScrollingModel scrollingModel;
    private boolean ignoreNextKeyTypedEvent;
    @Nullable
    private Point lastMotionReport;
    @NotNull
    private static final Logger LOG;

    public TerminalEventsHandlerImpl(@NotNull TerminalSessionModel sessionModel, @NotNull EditorEx editor, @NotNull TerminalKeyEncodingManager encodingManager, @NotNull TerminalInput terminalInput, @NotNull JBTerminalSystemSettingsProviderBase settings, @Nullable TerminalOutputScrollingModel scrollingModel) {
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)encodingManager, (String)"encodingManager");
        Intrinsics.checkNotNullParameter((Object)terminalInput, (String)"terminalInput");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.sessionModel = sessionModel;
        this.editor = editor;
        this.encodingManager = encodingManager;
        this.terminalInput = terminalInput;
        this.settings = settings;
        this.scrollingModel = scrollingModel;
    }

    private final TerminalState getTerminalState() {
        return (TerminalState)this.sessionModel.getTerminalState().getValue();
    }

    @Override
    public void keyTyped(@NotNull TimedKeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SelectionModel selectionModel = this.editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            selectionModel2.removeSelection();
        }
        if (this.ignoreNextKeyTypedEvent) {
            e.getOriginal().consume();
            return;
        }
        if (!Character.isISOControl(e.getOriginal().getKeyChar())) {
            try {
                if (this.processCharacter(e)) {
                    e.getOriginal().consume();
                }
            }
            catch (Exception ex) {
                LOG.error("Error sending typed key to emulator", (Throwable)ex);
            }
        }
    }

    @Override
    public void keyPressed(@NotNull TimedKeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ignoreNextKeyTypedEvent = false;
        if (this.processTerminalKeyPressed(e)) {
            e.getOriginal().consume();
            this.ignoreNextKeyTypedEvent = true;
        }
    }

    private final boolean processTerminalKeyPressed(TimedKeyEvent e) {
        try {
            int keyCode = e.getOriginal().getKeyCode();
            char keyChar = e.getOriginal().getKeyChar();
            if (keyCode == 127 && keyChar == '.') {
                byte[] byArray = new byte[]{46};
                this.terminalInput.sendBytes(byArray);
                return true;
            }
            if (keyChar == ' ' && (e.getOriginal().getModifiersEx() & 0x80) != 0) {
                byte[] byArray = new byte[]{0};
                this.terminalInput.sendBytes(byArray);
                return true;
            }
            byte[] code = this.encodingManager.getCode(keyCode, e.getOriginal().getModifiers());
            if (code != null) {
                this.terminalInput.sendBytes(code);
                if (this.isCodeThatScrolls(keyCode)) {
                    TerminalOutputScrollingModel terminalOutputScrollingModel = this.scrollingModel;
                    if (terminalOutputScrollingModel != null) {
                        terminalOutputScrollingModel.scrollToCursor(true);
                    }
                }
                if (keyCode == 10) {
                    TerminalUsageLocalStorage.Companion.getInstance().recordEnterKeyPressed();
                }
                return true;
            }
            if (this.isAltPressedOnly(e.getOriginal()) && Character.isDefined(keyChar) && this.settings.altSendsEscape()) {
                char[] cArray = new char[]{'\u001b', this.simpleMapKeyCodeToChar(e.getOriginal())};
                String string = new String(cArray);
                this.terminalInput.sendString(string);
                return true;
            }
            if (Character.isISOControl(keyChar)) {
                return this.processCharacter(e);
            }
        }
        catch (Exception ex) {
            LOG.error("Error sending pressed key to emulator", (Throwable)ex);
        }
        return false;
    }

    private final boolean processCharacter(TimedKeyEvent e) {
        block4: {
            if (this.isAltPressedOnly(e.getOriginal()) && this.settings.altSendsEscape()) {
                return false;
            }
            char keyChar = e.getOriginal().getKeyChar();
            if (keyChar == '`' && (e.getOriginal().getModifiersEx() & 0x100) != 0) {
                return false;
            }
            if (e.getOriginal().getID() == 400) {
                this.terminalInput.sendTrackedString(String.valueOf(keyChar), e.getInitTime());
            } else {
                this.terminalInput.sendString(String.valueOf(keyChar));
            }
            TerminalOutputScrollingModel terminalOutputScrollingModel = this.scrollingModel;
            if (terminalOutputScrollingModel == null) break block4;
            terminalOutputScrollingModel.scrollToCursor(true);
        }
        return true;
    }

    private final boolean isAltPressedOnly(KeyEvent e) {
        int modifiersEx = e.getModifiersEx();
        return (modifiersEx & 0x200) != 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) == 0;
    }

    private final boolean isCodeThatScrolls(int keycode) {
        return keycode == 38 || keycode == 40 || keycode == 37 || keycode == 39 || keycode == 8 || keycode == 155 || keycode == 127 || keycode == 10 || keycode == 36 || keycode == 35 || keycode == 33 || keycode == 34;
    }

    private final char simpleMapKeyCodeToChar(KeyEvent e) {
        char keyChar = (char)e.getKeyCode();
        return (e.getModifiersEx() & 0x40) != 0 ? Character.toUpperCase(keyChar) : Character.toLowerCase(keyChar);
    }

    @Override
    public void mousePressed(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            switch (code) {
                case 4: 
                case 5: {
                    int offset = 4;
                    code -= offset;
                    code |= 0x40;
                }
            }
            code = this.applyModifierKeys(event, code);
            this.terminalInput.sendBytes(this.mouseReport(code, x + 1, y + 1));
        }
    }

    @Override
    public void mouseReleased(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_NORMAL, MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code = this.getTerminalState().getMouseFormat() == MouseFormat.MOUSE_FORMAT_SGR ? code | 0x80 : 3;
            code = this.applyModifierKeys(event, code);
            this.terminalInput.sendBytes(this.mouseReport(code, x + 1, y + 1));
        }
        this.lastMotionReport = null;
    }

    @Override
    public void mouseMoved(int x, int y, @NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_ALL_MOTION};
        if (this.shouldSendMouseData(mouseModeArray)) {
            this.terminalInput.sendBytes(this.mouseReport(3, x + 1, y + 1));
        }
        this.lastMotionReport = new Point(x, y);
    }

    @Override
    public void mouseDragged(int x, int y, @NotNull MouseEvent event) {
        int code;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)this.lastMotionReport, (Object)new Point(x, y))) {
            return;
        }
        MouseMode[] mouseModeArray = new MouseMode[]{MouseMode.MOUSE_REPORTING_BUTTON_MOTION};
        if (this.shouldSendMouseData(mouseModeArray) && (code = this.createButtonCode(event)) != -1) {
            code |= 0x20;
            code = this.applyModifierKeys(event, code);
            this.terminalInput.sendBytes(this.mouseReport(code, x + 1, y + 1));
        }
        this.lastMotionReport = new Point(x, y);
    }

    @Override
    public void mouseWheelMoved(int x, int y, @NotNull MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.settings.enableMouseReporting() && this.getTerminalState().getMouseMode() != MouseMode.MOUSE_REPORTING_NONE && !event.isShiftDown()) {
            this.editor.getSelectionModel().removeSelection();
            this.mousePressed(x, y, event);
        }
        if (this.getTerminalState().isAlternateScreenBuffer() && this.settings.sendArrowKeysInAlternativeMode()) {
            byte[] arrowKeys = event.getWheelRotation() < 0 ? this.encodingManager.getCode(38, 0) : this.encodingManager.getCode(40, 0);
            int n = Math.abs(event.getUnitsToScroll());
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)arrowKeys);
                this.terminalInput.sendBytes(arrowKeys);
            }
            event.consume();
        }
    }

    private final boolean shouldSendMouseData(MouseMode ... eligibleModes) {
        MouseMode mode = this.getTerminalState().getMouseMode();
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> ArraysKt.contains((Object[])eligibleModes, (Object)mode);
        };
    }

    private final int createButtonCode(MouseEvent event) {
        int n;
        if (SwingUtilities.isLeftMouseButton(event)) {
            n = 0;
        } else if (SwingUtilities.isMiddleMouseButton(event)) {
            n = 1;
        } else if (SwingUtilities.isRightMouseButton(event)) {
            n = -1;
        } else if (event instanceof MouseWheelEvent) {
            n = ((MouseWheelEvent)event).getWheelRotation() > 0 ? 5 : 4;
        } else {
            return -1;
        }
        return n;
    }

    private final int applyModifierKeys(MouseEvent event, int cb) {
        int code = cb;
        if (event.isControlDown()) {
            code |= 0x10;
        }
        if (event.isShiftDown()) {
            code |= 4;
        }
        if ((event.getModifiersEx() & 4) != 0) {
            code |= 8;
        }
        return code;
    }

    private final byte[] mouseReport(int button2, int x, int y) {
        String string;
        String charset = "UTF-8";
        MouseFormat mouseFormat = this.getTerminalState().getMouseFormat();
        switch (WhenMappings.$EnumSwitchMapping$1[mouseFormat.ordinal()]) {
            case 1: {
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button2)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                break;
            }
            case 2: {
                String string2 = "\u001b[%d;%d;%dM";
                Object[] objectArray = new Object[]{32 + button2, x, y};
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                break;
            }
            case 3: {
                Object[] objectArray;
                String string2;
                if ((button2 & 0x80) != 0) {
                    string2 = "\u001b[<%d;%d;%dm";
                    objectArray = new Object[]{button2 ^ 0x80, x, y};
                    String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                    break;
                }
                string2 = "\u001b[<%d;%d;%dM";
                objectArray = new Object[]{button2, x, y};
                String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                break;
            }
            default: {
                charset = "ISO-8859-1";
                String string2 = "\u001b[M%c%c%c";
                Object[] objectArray = new Object[]{Character.valueOf((char)(32 + button2)), Character.valueOf((char)(32 + x)), Character.valueOf((char)(32 + y))};
                String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
            }
        }
        String command2 = string;
        LOG.debug(mouseFormat + " (" + charset + ") report : " + button2 + ", " + x + "x" + y + " = " + command2);
        String string8 = command2;
        Charset charset2 = Charset.forName(charset);
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
        byte[] byArray = string8.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    static {
        Logger logger = Logger.getInstance(TerminalEventsHandlerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/terminal/frontend/TerminalEventsHandlerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MouseMode.values().length];
            try {
                nArray[MouseMode.MOUSE_REPORTING_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseMode.MOUSE_REPORTING_ALL_MOTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MouseFormat.values().length];
            try {
                nArray[MouseFormat.MOUSE_FORMAT_XTERM_EXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_URXVT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MouseFormat.MOUSE_FORMAT_SGR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

