/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.DatesInterval;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00060\u0004j\u0002`\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0011\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u0012\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0004j\u0002`\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001b\u0010\u0005\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcirclet/common/calendar/TimeIntervalDTO;", "", "start", "Lcirclet/platform/api/ADateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "end", "<init>", "(Lcirclet/platform/api/KotlinXDateTime;Lcirclet/platform/api/KotlinXDateTime;)V", "getStart", "()Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "getEnd", "toDates", "Lcirclet/common/calendar/DatesInterval;", "timezone", "Lcirclet/platform/api/ATimeZone;", "component1", "component2", "copy", "(Lcirclet/platform/api/KotlinXDateTime;Lcirclet/platform/api/KotlinXDateTime;)Lcirclet/common/calendar/TimeIntervalDTO;", "equals", "", "other", "hashCode", "", "toString", "", "spaceport-common"})
@SourceDebugExtension(value={"SMAP\nEventCounters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventCounters.kt\ncirclet/common/calendar/TimeIntervalDTO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,876:1\n1#2:877\n*E\n"})
public final class TimeIntervalDTO {
    @NotNull
    private final KotlinXDateTime start;
    @Nullable
    private final KotlinXDateTime end;

    public TimeIntervalDTO(@NotNull KotlinXDateTime start2, @Nullable KotlinXDateTime end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        this.start = start2;
        this.end = end;
        if (!(this.end == null || this.start.compareTo(this.end) <= 0)) {
            boolean bl = false;
            String string = this.start + " > " + this.end;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final KotlinXDateTime getStart() {
        return this.start;
    }

    @Nullable
    public final KotlinXDateTime getEnd() {
        return this.end;
    }

    @NotNull
    public final DatesInterval toDates(@NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        Comparable<KotlinXDateTime> comparable = this.end;
        KotlinXDate endDate = comparable != null && (comparable = ADateJvmKt.withZone(comparable, timezone)) != null && (comparable = ADateJvmKt.toDate(comparable)) != null ? ADateJvmKt.plusDays((KotlinXDate)comparable, 1) : null;
        return new DatesInterval(ADateJvmKt.toDate(ADateJvmKt.withZone(this.start, timezone)), endDate);
    }

    @NotNull
    public final KotlinXDateTime component1() {
        return this.start;
    }

    @Nullable
    public final KotlinXDateTime component2() {
        return this.end;
    }

    @NotNull
    public final TimeIntervalDTO copy(@NotNull KotlinXDateTime start2, @Nullable KotlinXDateTime end) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        return new TimeIntervalDTO(start2, end);
    }

    public static /* synthetic */ TimeIntervalDTO copy$default(TimeIntervalDTO timeIntervalDTO, KotlinXDateTime kotlinXDateTime, KotlinXDateTime kotlinXDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            kotlinXDateTime = timeIntervalDTO.start;
        }
        if ((n & 2) != 0) {
            kotlinXDateTime2 = timeIntervalDTO.end;
        }
        return timeIntervalDTO.copy(kotlinXDateTime, kotlinXDateTime2);
    }

    @NotNull
    public String toString() {
        return "TimeIntervalDTO(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + (this.end == null ? 0 : this.end.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeIntervalDTO)) {
            return false;
        }
        TimeIntervalDTO timeIntervalDTO = (TimeIntervalDTO)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)timeIntervalDTO.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)timeIntervalDTO.end);
    }
}

