/*
 * Decompiled with CFR 0.152.
 */
package circlet.pipelines.config.localM2;

import circlet.pipelines.config.localM2.MavenSettingsXmlParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\n\u0010\u0003\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\n\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"findLocalM2RepoPathString", "", "readFromSystemProperty", "parseFromUserHomeM2Settings", "parseFromM2HomeConfSettings", "parseLocalRepoIfExists", "settingsXml", "Ljava/nio/file/Path;", "libraries-local-m2-finder"})
@SourceDebugExtension(value={"SMAP\nLocalM2RepositoryFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalM2RepositoryFinder.kt\ncirclet/pipelines/config/localM2/LocalM2RepositoryFinderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class LocalM2RepositoryFinderKt {
    private static final String findLocalM2RepoPathString() {
        Object object = LocalM2RepositoryFinderKt.readFromSystemProperty();
        if (object == null && (object = LocalM2RepositoryFinderKt.parseFromUserHomeM2Settings()) == null && (object = LocalM2RepositoryFinderKt.parseFromM2HomeConfSettings()) == null) {
            object = System.getProperty("user.home") + "/.m2/repository";
        }
        return object;
    }

    private static final String readFromSystemProperty() {
        String string;
        String string2 = System.getProperty("maven.repo.local");
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final String parseFromUserHomeM2Settings() {
        String string = System.getProperty("user.home");
        if (string == null) {
            return null;
        }
        String userHome = string;
        Path path = Paths.get(userHome + "/.m2/settings.xml", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path userHomeSettingsXml = path;
        return LocalM2RepositoryFinderKt.parseLocalRepoIfExists(userHomeSettingsXml);
    }

    private static final String parseFromM2HomeConfSettings() {
        String string;
        block4: {
            block3: {
                String string2;
                string = System.getenv("M2_HOME");
                if (string == null) break block3;
                String it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block4;
            }
            return null;
        }
        String m2Home = string;
        Path path = Paths.get(m2Home + "/conf/settings.xml", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path m2HomeSettingsXml = path;
        return LocalM2RepositoryFinderKt.parseLocalRepoIfExists(m2HomeSettingsXml);
    }

    private static final String parseLocalRepoIfExists(Path settingsXml) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(settingsXml, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? MavenSettingsXmlParser.Companion.parseLocalRepo(settingsXml) : null;
    }

    public static final /* synthetic */ String access$findLocalM2RepoPathString() {
        return LocalM2RepositoryFinderKt.findLocalM2RepoPathString();
    }
}

