/*
 * Decompiled with CFR 0.152.
 */
package circlet.pipelines.config.localM2;

import circlet.pipelines.config.localM2.LocalRepositoryFoundEarly;
import circlet.pipelines.config.localM2.MavenSettingsXmlParserKt;
import java.nio.file.Path;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J&\u0010\u0016\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcirclet/pipelines/config/localM2/MavenSettingsXmlParser;", "Lorg/xml/sax/helpers/DefaultHandler;", "<init>", "()V", "readingLocalRepo", "", "localRepoBuilder", "Ljava/lang/StringBuilder;", "startElement", "", "uri", "", "localName", "qName", "attributes", "Lorg/xml/sax/Attributes;", "characters", "ch", "", "start", "", "length", "endElement", "Companion", "libraries-local-m2-finder"})
public final class MavenSettingsXmlParser
extends DefaultHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean readingLocalRepo;
    @NotNull
    private final StringBuilder localRepoBuilder = new StringBuilder();
    @NotNull
    private static final String LOCAL_REPOSITORY_TAG = "localRepository";

    private MavenSettingsXmlParser() {
    }

    @Override
    public void startElement(@Nullable String uri, @Nullable String localName, @Nullable String qName, @Nullable Attributes attributes) {
        if (Intrinsics.areEqual((Object)qName, (Object)LOCAL_REPOSITORY_TAG)) {
            this.readingLocalRepo = true;
        }
    }

    @Override
    public void characters(@NotNull char[] ch, int start2, int length) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        if (this.readingLocalRepo) {
            StringBuilder stringBuilder = this.localRepoBuilder;
            int n = start2 + length;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(ch, start2, n - start2), (String)"append(...)");
        }
    }

    @Override
    public void endElement(@Nullable String uri, @Nullable String localName, @Nullable String qName) {
        if (Intrinsics.areEqual((Object)qName, (Object)LOCAL_REPOSITORY_TAG)) {
            String string = this.localRepoBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new LocalRepositoryFoundEarly(MavenSettingsXmlParserKt.access$substituteProperties(string));
        }
    }

    public /* synthetic */ MavenSettingsXmlParser(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcirclet/pipelines/config/localM2/MavenSettingsXmlParser$Companion;", "", "<init>", "()V", "LOCAL_REPOSITORY_TAG", "", "parseLocalRepo", "settingsXml", "Ljava/nio/file/Path;", "libraries-local-m2-finder"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String parseLocalRepo(@NotNull Path settingsXml) {
            String string;
            Intrinsics.checkNotNullParameter((Object)settingsXml, (String)"settingsXml");
            try {
                SAXParserFactory.newInstance().newSAXParser().parse(settingsXml.toFile(), (DefaultHandler)new MavenSettingsXmlParser(null));
                string = null;
            }
            catch (LocalRepositoryFoundEarly e) {
                string = e.getRepoPath();
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

