/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.gateway;

import com.intellij.spaceport.gateway.SpaceKt;
import com.intellij.spaceport.gateway.SpaceportGatewayIcons;
import com.intellij.spaceport.gateway.spaceport.SpaceportGatewayContext;
import com.intellij.spaceport.gateway.spaceport.ui.SpaceportGatewayWelcomeScreenTab;
import com.intellij.spaceport.gateway.ui.PromoKt;
import com.intellij.spaceport.gateway.ui.SpaceGatewayConnectorView;
import com.intellij.spaceport.gateway.ui.SpaceGatewayExplorePlace;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayConnectorAction;
import com.jetbrains.gateway.api.GatewayConnectorDocumentationPage;
import com.jetbrains.gateway.api.GatewayConnectorView;
import com.jetbrains.gateway.api.GatewayRecentConnections;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/spaceport/gateway/SpaceportGatewayConnector;", "Lcom/jetbrains/gateway/api/GatewayConnector;", "<init>", "()V", "context", "Lcom/intellij/spaceport/gateway/spaceport/SpaceportGatewayContext;", "getContext", "()Lcom/intellij/spaceport/gateway/spaceport/SpaceportGatewayContext;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "getTitle", "", "getActionText", "getDescription", "createView", "Lcom/jetbrains/gateway/api/GatewayConnectorView;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/intellij/spaceport/gateway/RdLifetime;", "isAvailable", "", "getRecentConnections", "Lcom/jetbrains/gateway/api/GatewayRecentConnections;", "setContentCallback", "Lkotlin/Function1;", "Ljava/awt/Component;", "", "getConnectorId", "getDocumentationAction", "Lcom/jetbrains/gateway/api/GatewayConnectorDocumentationPage;", "userWasConnectedToSpace", "OpenSpaceTabConnectorAction", "intellij.spaceport.gateway"})
public final class SpaceportGatewayConnector
implements GatewayConnector {
    @NotNull
    private final SpaceportGatewayContext context = SpaceportGatewayContext.INSTANCE;
    @NotNull
    private final Icon icon;

    public SpaceportGatewayConnector() {
        Icon icon = SpaceportGatewayIcons.Icons.Main_64;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Main_64");
        this.icon = icon;
        this.context.connectionService();
    }

    @NotNull
    public final SpaceportGatewayContext getContext() {
        return this.context;
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public String getTitle() {
        return this.context.bundle().message("connector.title", new Object[0]);
    }

    @NotNull
    public String getActionText() {
        return this.context.bundle().message("connector.action.text", new Object[0]);
    }

    @NotNull
    public String getDescription() {
        return this.context.bundle().message("connector.description", new Object[0]);
    }

    @NotNull
    public GatewayConnectorView createView(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        return this.userWasConnectedToSpace() ? (GatewayConnectorView)new OpenSpaceTabConnectorAction() : (GatewayConnectorView)new SpaceGatewayConnectorView(SpaceKt.spaceLifetime(lifetime), this.context);
    }

    public boolean isAvailable() {
        return true;
    }

    @Nullable
    public GatewayRecentConnections getRecentConnections(@NotNull Function1<? super Component, Unit> setContentCallback) {
        Intrinsics.checkNotNullParameter(setContentCallback, (String)"setContentCallback");
        return new SpaceportGatewayWelcomeScreenTab(setContentCallback);
    }

    @NotNull
    public String getConnectorId() {
        return "codecanvas.connector";
    }

    @NotNull
    public GatewayConnectorDocumentationPage getDocumentationAction() {
        return new GatewayConnectorDocumentationPage(PromoKt.getExploreUrl(SpaceGatewayExplorePlace.MAIN_GATEWAY));
    }

    private final boolean userWasConnectedToSpace() {
        return this.context.settings().getServerSettings().getEnabled();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/spaceport/gateway/SpaceportGatewayConnector$OpenSpaceTabConnectorAction;", "Lcom/jetbrains/gateway/api/GatewayConnectorAction;", "<init>", "(Lcom/intellij/spaceport/gateway/SpaceportGatewayConnector;)V", "invoke", "", "intellij.spaceport.gateway"})
    private final class OpenSpaceTabConnectorAction
    implements GatewayConnectorAction {
        public void invoke() {
            SpaceportGatewayConnector.this.getContext().getNavigation().showMainGatewayConnectorScreen();
        }
    }
}

