/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.wiremock;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.wiremock.WireMockPluginSuggestion;
import com.jetbrains.jsonSchema.wiremock.WireMockSuggestionProviderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/jsonSchema/wiremock/WireMockSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.json"})
public final class WireMockSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileTypeManager.getInstance().isFileOfType(file, (FileType)JsonFileType.INSTANCE)) {
            return null;
        }
        if (WireMockSuggestionProviderKt.access$isPluginSuggestionDismissed() || PluginAdvertiserServiceKt.tryUltimateIsDisabled()) {
            return null;
        }
        PluginId pluginId = PluginId.getId((String)"com.intellij.wiremock");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        PluginId requiredPluginId = pluginId;
        if (PluginManager.isPluginInstalled((PluginId)requiredPluginId)) {
            return null;
        }
        String string = ApplicationInfoImpl.getShadowInstanceImpl().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String thisProductCode = string;
        boolean isWireMockFile = WireMockSuggestionProviderKt.access$detectWireMockStubs(project, file);
        if (!isWireMockFile) {
            return null;
        }
        return new WireMockPluginSuggestion(project, thisProductCode);
    }
}

