/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.HelpIdProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InclusionListener;
import com.intellij.openapi.vcs.changes.InclusionModel;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.ChangeListChangesSupplier;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.DefaultCommitChangeListDialog;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.SplitterWithSecondHideable;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.CommitChangeListDialogWorkflow;
import com.intellij.vcs.commit.CommitChecksResult;
import com.intellij.vcs.commit.CommitExecutorListener;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.CommitOptions;
import com.intellij.vcs.commit.CommitOptionsKt;
import com.intellij.vcs.commit.CommitOptionsPanel;
import com.intellij.vcs.commit.CommitOptionsUi;
import com.intellij.vcs.commit.CommitWorkflowUiStateListener;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflow;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowHandler;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowUi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function0;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommitChangeListDialog
extends DialogWrapper
implements SingleChangeListCommitWorkflowUi,
ComponentContainer {
    @NlsContexts.DialogTitle
    public static final String DIALOG_TITLE = VcsBundle.message((String)"commit.dialog.title", (Object[])new Object[0]);
    private static final String HELP_ID = "reference.dialogs.vcs.commit";
    private static final int LAYOUT_VERSION = 2;
    @ApiStatus.Internal
    public static final String DIMENSION_SERVICE_KEY = "CommitChangelistDialog2";
    private static final String SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.SPLITTER_PROPORTION_2";
    private static final String DETAILS_SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_2";
    private static final String DETAILS_SHOW_OPTION = "CommitChangeListDialog.DETAILS_SHOW_OPTION_";
    private static final float SPLITTER_PROPORTION_OPTION_DEFAULT = 0.5f;
    private static final float DETAILS_SPLITTER_PROPORTION_OPTION_DEFAULT = 0.6f;
    private static final boolean DETAILS_SHOW_OPTION_DEFAULT = true;
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommitChangeListDialogWorkflow myWorkflow;
    @NotNull
    private final EventDispatcher<CommitWorkflowUiStateListener> myStateEventDispatcher;
    @NotNull
    private final EventDispatcher<CommitExecutorListener> myExecutorEventDispatcher;
    @NotNull
    private final List<DataProvider> myDataProviders;
    @NotNull
    private final EventDispatcher<InclusionListener> myInclusionEventDispatcher;
    @NotNull
    @NlsContexts.Button
    private String myDefaultCommitActionName;
    @Nullable
    private CommitAction myCommitAction;
    @NotNull
    private final List<CommitExecutorAction> myExecutorActions;
    @NotNull
    private final CommitOptionsPanel myCommitOptions;
    @NotNull
    private final JComponent myCommitOptionsPanel;
    @NotNull
    private final ChangeInfoCalculator myChangesInfoCalculator;
    @NotNull
    private final JComponent myBrowserBottomPanel;
    @NotNull
    private final MyChangeProcessor myDiffDetails;
    @NotNull
    private final CommitMessage myCommitMessageArea;
    @NotNull
    private final CommitLegendPanel myLegend;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final SplitterWithSecondHideable myDetailsSplitter;
    @NotNull
    private final JBLabel myWarningLabel;
    @Nullable
    private final String myHelpId;
    @NotNull
    private final Alarm okButtonUpdateAlarm;
    @NotNull
    private final Runnable myUpdateButtonsRunnable;
    private boolean myDisposed;
    private boolean myUpdateDisabled;

    @Deprecated
    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> included, @Nullable LocalChangeList initialChangeList, @Nullable CommitExecutor executor, @Nullable String comment) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(0);
        }
        if (included == null) {
            CommitChangeListDialog.$$$reportNull$$$0(1);
        }
        if (executor != null) {
            return CommitChangeListDialog.commitWithExecutor(project, included, initialChangeList, executor, comment, null);
        }
        return CommitChangeListDialog.commitVcsChanges(project, included, initialChangeList, comment, null);
    }

    @NotNull
    private static Set<AbstractVcs> getVcsesForLocalChanges(@NotNull Project project, boolean showVcsCommit) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(2);
        }
        HashSet<AbstractVcs> affectedVcses = new HashSet<AbstractVcs>();
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        Collection localChanges = manager.getAllChanges();
        affectedVcses.addAll(ChangesUtil.getAffectedVcses((Collection)localChanges, (Project)project));
        if (showVcsCommit) {
            List unversionedFiles = manager.getUnversionedFilesPaths();
            affectedVcses.addAll(ChangesUtil.getAffectedVcsesForFilePaths((Collection)unversionedFiles, (Project)project));
        }
        HashSet<AbstractVcs> hashSet = affectedVcses;
        if (hashSet == null) {
            CommitChangeListDialog.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public static boolean commitWithExecutor(@NotNull Project project, @NotNull Collection<?> included, @Nullable LocalChangeList initialChangeList, @NotNull CommitExecutor executor, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        boolean showVcsCommit;
        Set<AbstractVcs> affectedVcses;
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(4);
        }
        if (included == null) {
            CommitChangeListDialog.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            CommitChangeListDialog.$$$reportNull$$$0(6);
        }
        if ((affectedVcses = CommitChangeListDialog.getVcsesForLocalChanges(project, showVcsCommit = false)).isEmpty()) {
            CommitChangeListDialog.showNothingToCommitMessage(project);
            return false;
        }
        List<CommitExecutor> executors = Collections.singletonList(executor);
        return CommitChangeListDialog.showCommitDialog(project, affectedVcses, included, initialChangeList, executors, showVcsCommit, comment, customResultHandler);
    }

    public static boolean commitVcsChanges(@NotNull Project project, @NotNull Collection<?> included, @Nullable LocalChangeList initialChangeList, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        boolean showVcsCommit;
        Set<AbstractVcs> affectedVcses;
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(7);
        }
        if (included == null) {
            CommitChangeListDialog.$$$reportNull$$$0(8);
        }
        if ((affectedVcses = CommitChangeListDialog.getVcsesForLocalChanges(project, showVcsCommit = true)).isEmpty()) {
            CommitChangeListDialog.showNothingToCommitMessage(project);
            return false;
        }
        List<CommitExecutor> executors = AbstractCommitWorkflow.getCommitExecutors(project, affectedVcses);
        return CommitChangeListDialog.showCommitDialog(project, affectedVcses, included, initialChangeList, executors, showVcsCommit, comment, customResultHandler);
    }

    public static boolean showCommitDialog(@NotNull Project project, @NotNull Set<AbstractVcs> affectedVcses, @NotNull Collection<?> included, @Nullable LocalChangeList initialChangeList, @NotNull List<? extends CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(9);
        }
        if (affectedVcses == null) {
            CommitChangeListDialog.$$$reportNull$$$0(10);
        }
        if (included == null) {
            CommitChangeListDialog.$$$reportNull$$$0(11);
        }
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(12);
        }
        List changes = ContainerUtil.filterIsInstance(included, Change.class);
        for (BaseCheckinHandlerFactory factory : AbstractCommitWorkflow.getCommitHandlerFactories(affectedVcses)) {
            BeforeCheckinDialogHandler handler = factory.createSystemReadyHandler(project);
            if (handler == null || handler.beforeCommitDialogShown(project, changes, executors, showVcsCommit)) continue;
            return false;
        }
        SingleChangeListCommitWorkflow workflow = new SingleChangeListCommitWorkflow(project, affectedVcses, initialChangeList, executors, showVcsCommit, customResultHandler);
        DefaultCommitChangeListDialog dialog = new DefaultCommitChangeListDialog(workflow);
        return new SingleChangeListCommitWorkflowHandler(workflow, dialog, comment, included).activate();
    }

    public static void showNothingToCommitMessage(@NotNull Project project) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(13);
        }
        Messages.showInfoMessage((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
    }

    protected CommitChangeListDialog(@NotNull CommitChangeListDialogWorkflow workflow) {
        if (workflow == null) {
            CommitChangeListDialog.$$$reportNull$$$0(14);
        }
        super(workflow.getProject(), true, DialogWrapper.IdeModalityType.IDE);
        this.myStateEventDispatcher = EventDispatcher.create(CommitWorkflowUiStateListener.class);
        this.myExecutorEventDispatcher = EventDispatcher.create(CommitExecutorListener.class);
        this.myDataProviders = new ArrayList<DataProvider>();
        this.myInclusionEventDispatcher = EventDispatcher.create(InclusionListener.class);
        this.myDefaultCommitActionName = "";
        this.myExecutorActions = new ArrayList<CommitExecutorAction>();
        this.myBrowserBottomPanel = JBBox.createHorizontalBox();
        this.okButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myUpdateButtonsRunnable = () -> {
            this.updateButtons();
            this.updateLegend();
        };
        this.myDisposed = false;
        this.myUpdateDisabled = false;
        this.myWorkflow = workflow;
        this.myProject = this.myWorkflow.getProject();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this);
        List<CommitExecutor> executors = this.myWorkflow.getCommitExecutors();
        if (!this.isDefaultCommitEnabled() && ContainerUtil.isEmpty(executors)) {
            throw new IllegalArgumentException("nothing found to execute commit with");
        }
        this.setTitle(this.isDefaultCommitEnabled() ? DIALOG_TITLE : AbstractCommitWorkflowKt.cleanActionText(executors.get(0).getActionText(), true));
        this.myHelpId = this.isDefaultCommitEnabled() ? HELP_ID : CommitChangeListDialog.getHelpId(executors);
        this.myDiffDetails = new MyChangeProcessor(this.myProject, this.myWorkflow.isPartialCommitEnabled());
        this.myCommitMessageArea = new CommitMessage(this.myProject, true, true, this.isDefaultCommitEnabled());
        this.myChangesInfoCalculator = new ChangeInfoCalculator();
        this.myLegend = new CommitLegendPanel(this.myChangesInfoCalculator);
        this.mySplitter = new Splitter(true);
        boolean nonFocusable = !UISettings.getInstance().getDisableMnemonicsInControls();
        this.myCommitOptions = new CommitOptionsPanel(this.myProject, (Function0<String>)((Function0)() -> this.getDefaultCommitActionName()), nonFocusable, false);
        this.myCommitOptionsPanel = this.myCommitOptions.component;
        this.myWarningLabel = new JBLabel();
        JPanel mainPanel = new JPanel((LayoutManager)((Object)new MyOptionsLayout((JComponent)this.mySplitter, this.myCommitOptions, JBUIScale.scale((int)150), JBUIScale.scale((int)400))));
        mainPanel.add((Component)this.mySplitter);
        mainPanel.add(this.myCommitOptionsPanel);
        BorderLayoutPanel rootPane = JBUI.Panels.simplePanel((Component)mainPanel).addToBottom((Component)this.myWarningLabel);
        this.myDetailsSplitter = this.createDetailsSplitter((JPanel)rootPane);
    }

    @NotNull
    public abstract CommitDialogChangesBrowser getBrowser();

    public boolean activate() {
        this.beforeInit();
        this.init();
        this.afterInit();
        return this.showAndGet();
    }

    @Override
    public void deactivate() {
        this.close(0);
    }

    @Override
    public void addStateListener(@NotNull CommitWorkflowUiStateListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(15);
        }
        if (parent == null) {
            CommitChangeListDialog.$$$reportNull$$$0(16);
        }
        this.myStateEventDispatcher.addListener((EventListener)listener2, parent);
    }

    private void beforeInit() {
        this.getBrowser().setInclusionChangedListener(() -> WriteIntentReadAction.run(() -> ((InclusionListener)this.myInclusionEventDispatcher.getMulticaster()).inclusionChanged()));
        this.addInclusionListener(() -> this.updateButtons(), (Disposable)this);
        this.getBrowser().getViewer().addSelectionListener(() -> this.refreshDetails(this.getBrowser().getViewer().isModelUpdateInProgress(), true));
        this.initCommitActions(this.myWorkflow.getCommitExecutors());
        this.myCommitOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.myBrowserBottomPanel.add((Component)this.myLegend.getComponent());
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel().addToCenter((Component)this.getBrowser()).addToBottom((Component)this.myBrowserBottomPanel);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)topPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myCommitMessageArea);
        this.mySplitter.setProportion(PropertiesComponent.getInstance().getFloat(SPLITTER_PROPORTION_OPTION, 0.5f));
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.myWarningLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        this.updateWarning();
    }

    protected void afterInit() {
        this.updateButtons();
        this.updateLegend();
        this.myCommitMessageArea.setChangesSupplier(new ChangeListChangesSupplier((ChangeList)this.getChangeList()));
        this.myCommitMessageArea.requestFocusInMessage();
        for (EditChangelistSupport support : EditChangelistSupport.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            support.installSearch(this.myCommitMessageArea.getEditorField(), this.myCommitMessageArea.getEditorField());
        }
        this.showDetailsIfSaved();
        LaterInvocator.markTransparent((ModalityState)ModalityState.stateForComponent((Component)this.getComponent()));
    }

    @NotNull
    private SplitterWithSecondHideable createDetailsSplitter(@NotNull JPanel rootPane) {
        if (rootPane == null) {
            CommitChangeListDialog.$$$reportNull$$$0(17);
        }
        SplitterWithSecondHideable.OnOffListener listener2 = new SplitterWithSecondHideable.OnOffListener(){

            public void on(int hideableHeight) {
                if (hideableHeight == 0) {
                    return;
                }
                CommitChangeListDialog.this.getWindow().addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        e.getComponent().removeComponentListener(this);
                        CommitChangeListDialog.this.refreshDetails(false, true);
                    }
                });
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height + hideableHeight);
                CommitChangeListDialog.this.repaint();
            }

            public void off(int hideableHeight) {
                if (hideableHeight == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.clear();
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height - hideableHeight);
                CommitChangeListDialog.this.repaint();
            }
        };
        return new SplitterWithSecondHideable(true, VcsBundle.message((String)"changes.diff.separator", (Object[])new Object[0]), rootPane, listener2){

            protected RefreshablePanel createDetails() {
                BorderLayoutPanel panel = JBUI.Panels.simplePanel((Component)CommitChangeListDialog.this.myDiffDetails.getComponent());
                return new RefreshablePanel(){
                    final /* synthetic */ JPanel val$panel;
                    {
                        this.val$panel = jPanel;
                    }

                    public void refresh() {
                    }

                    public JPanel getPanel() {
                        return this.val$panel;
                    }
                };
            }

            protected float getSplitterInitialProportion() {
                float value = PropertiesComponent.getInstance().getFloat(CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_OPTION, 0.6f);
                return (double)value <= 0.05 || (double)value >= 0.95 ? 0.6f : value;
            }
        };
    }

    private void initCommitActions(@NotNull List<? extends CommitExecutor> executors) {
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(18);
        }
        this.myExecutorActions.addAll(this.createExecutorActions(executors));
        if (this.isDefaultCommitEnabled()) {
            this.myCommitAction = new CommitAction(this.getDefaultCommitActionName());
            this.myCommitAction.setOptions(this.myExecutorActions);
        } else {
            this.myCommitAction = null;
            this.myExecutorActions.get(0).putValue("DefaultAction", Boolean.TRUE);
        }
    }

    @NotNull
    private List<CommitExecutorAction> createExecutorActions(@NotNull List<? extends CommitExecutor> executors) {
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(19);
        }
        if (executors.isEmpty()) {
            List<CommitExecutorAction> list = Collections.emptyList();
            if (list == null) {
                CommitChangeListDialog.$$$reportNull$$$0(20);
            }
            return list;
        }
        ArrayList<CommitExecutorAction> result2 = new ArrayList<CommitExecutorAction>();
        if (this.isDefaultCommitEnabled() && UISettings.getInstance().getAllowMergeButtons()) {
            ActionManager actionManager = ActionManager.getInstance();
            DefaultActionGroup primaryActions = (DefaultActionGroup)actionManager.getAction("Vcs.Commit.PrimaryCommitActions");
            DefaultActionGroup executorActions = (DefaultActionGroup)actionManager.getAction("Vcs.CommitExecutor.Actions");
            result2.addAll(ContainerUtil.map((Object[])primaryActions.getChildren(actionManager), x$0 -> new CommitExecutorAction((AnAction)x$0)));
            result2.addAll(ContainerUtil.map((Object[])executorActions.getChildren(actionManager), x$0 -> new CommitExecutorAction((AnAction)x$0)));
            result2.addAll(ContainerUtil.map((Collection)ContainerUtil.filter(executors, CommitExecutor::useDefaultAction), x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        } else {
            result2.addAll(ContainerUtil.map(executors, x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        }
        ArrayList<CommitExecutorAction> arrayList = result2;
        if (arrayList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    private static String getHelpId(@NotNull List<? extends CommitExecutor> executors) {
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(22);
        }
        return StreamEx.of(executors).select(HelpIdProvider.class).map(HelpIdProvider::getHelpId).nonNull().findFirst().orElse(null);
    }

    private void showDetailsIfSaved() {
        boolean showDetails = PropertiesComponent.getInstance().getBoolean(DETAILS_SHOW_OPTION, true);
        if (showDetails) {
            this.myDetailsSplitter.initOn();
            this.myDetailsSplitter.setInitialProportion();
            UIUtil.runWhenWindowOpened((Window)this.getWindow(), () -> {
                this.myDetailsSplitter.setInitialProportion();
                this.refreshDetails(false, false);
            });
        }
    }

    protected void updateWarning() {
        if (this.myWarningLabel != null) {
            Object[] messages;
            this.myWarningLabel.setVisible(false);
            VcsException updateException = ChangeListManagerImpl.getInstanceImpl(this.myProject).getUpdateException();
            if (updateException != null && !ArrayUtil.isEmpty((Object[])(messages = updateException.getMessages()))) {
                String message = VcsBundle.message((String)"changes.warning.not.all.local.changes.may.be.shown.due.to.an.error", (Object[])new Object[]{messages[0]});
                String htmlMessage = SwingHelper.buildHtml((String)UIUtil.getCssFontDeclaration((Font)StartupUiUtil.getLabelFont()), (String)UIUtil.getHtmlBody((String)StringUtil.escapeXmlEntities((String)message)));
                this.myWarningLabel.setText(htmlMessage);
                this.myWarningLabel.setVisible(true);
            }
        }
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myCommitAction != null ? this.myCommitAction : (Action)this.myExecutorActions.get(0);
        if (action == null) {
            CommitChangeListDialog.$$$reportNull$$$0(23);
        }
        return action;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> result2 = new ArrayList<Action>();
        if (this.myCommitAction != null) {
            result2.add(this.myCommitAction);
        } else {
            result2.addAll(this.myExecutorActions);
        }
        result2.add(this.getCancelAction());
        if (this.myHelpId != null) {
            result2.add(this.getHelpAction());
        }
        Action[] actionArray = result2.toArray(new Action[0]);
        if (actionArray == null) {
            CommitChangeListDialog.$$$reportNull$$$0(24);
        }
        return actionArray;
    }

    public void dispose() {
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.getBrowser());
        Disposer.dispose((Disposable)this.myCommitMessageArea);
        Disposer.dispose((Disposable)this.okButtonUpdateAlarm);
        super.dispose();
        Disposer.dispose((Disposable)this.myDiffDetails);
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION_OPTION, this.mySplitter.getProportion(), 0.5f);
        float usedProportion = this.myDetailsSplitter.getUsedProportion();
        if (usedProportion > 0.0f) {
            PropertiesComponent.getInstance().setValue(DETAILS_SPLITTER_PROPORTION_OPTION, usedProportion, 0.6f);
        }
        PropertiesComponent.getInstance().setValue(DETAILS_SHOW_OPTION, this.myDetailsSplitter.isOn(), true);
    }

    private void stopUpdate() {
        this.myUpdateDisabled = true;
    }

    private void restartUpdate() {
        this.myUpdateDisabled = false;
        this.myUpdateButtonsRunnable.run();
    }

    public void doCancelAction() {
        ((CommitWorkflowUiStateListener)this.myStateEventDispatcher.getMulticaster()).cancelled();
        super.doCancelAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Splitter splitter = this.myDetailsSplitter.getComponent();
        if (splitter == null) {
            CommitChangeListDialog.$$$reportNull$$$0(25);
        }
        return splitter;
    }

    public boolean hasDiffs() {
        return !this.getIncludedChanges().isEmpty() || !this.getIncludedUnversionedFiles().isEmpty();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(26);
        }
        return project;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public String getCommitMessage() {
        String string = this.myCommitMessageArea.getText();
        if (string == null) {
            CommitChangeListDialog.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        List list = SequencesKt.toList(CommitOptionsKt.getAllOptions(this.getCommitOptions()));
        if (list == null) {
            CommitChangeListDialog.$$$reportNull$$$0(28);
        }
        return list;
    }

    private void updateButtons() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        boolean enabled = this.hasDiffs();
        if (this.myCommitAction != null) {
            this.myCommitAction.setEnabled(enabled);
        }
        this.myExecutorActions.forEach(action -> action.updateEnabled(enabled));
        this.okButtonUpdateAlarm.cancelAllRequests();
        this.okButtonUpdateAlarm.addRequest(this.myUpdateButtonsRunnable, 300, ModalityState.stateForComponent((Component)this.getBrowser()));
    }

    private void updateLegend() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        this.myChangesInfoCalculator.update(this.getDisplayedChanges(), this.getIncludedChanges(), this.getDisplayedUnversionedFiles().size(), this.getIncludedUnversionedFiles().size());
        this.myLegend.update();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessageArea.getEditorField();
    }

    @NotNull
    public JComponent getComponent() {
        Splitter splitter = this.mySplitter;
        if (splitter == null) {
            CommitChangeListDialog.$$$reportNull$$$0(29);
        }
        return splitter;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getPreferredFocusedComponent();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            CommitChangeListDialog.$$$reportNull$$$0(30);
        }
        DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)this.getBrowser());
        for (DataProvider provider : this.myDataProviders) {
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)provider);
        }
    }

    @NotNull
    public CommitMessageUi getCommitMessageUi() {
        CommitMessage commitMessage = this.myCommitMessageArea;
        if (commitMessage == null) {
            CommitChangeListDialog.$$$reportNull$$$0(31);
        }
        return commitMessage;
    }

    @Override
    @NotNull
    public CommitOptionsUi getCommitOptionsUi() {
        CommitOptionsPanel commitOptionsPanel = this.myCommitOptions;
        if (commitOptionsPanel == null) {
            CommitChangeListDialog.$$$reportNull$$$0(32);
        }
        return commitOptionsPanel;
    }

    @NotNull
    @NlsContexts.Button
    public String getDefaultCommitActionName() {
        String string = this.myDefaultCommitActionName;
        if (string == null) {
            CommitChangeListDialog.$$$reportNull$$$0(33);
        }
        return string;
    }

    public void setDefaultCommitActionName(@NotNull @NlsContexts.Button String defaultCommitActionName) {
        if (defaultCommitActionName == null) {
            CommitChangeListDialog.$$$reportNull$$$0(34);
        }
        this.myDefaultCommitActionName = defaultCommitActionName;
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            CommitChangeListDialog.$$$reportNull$$$0(35);
        }
        this.myDataProviders.add(provider);
    }

    public void addExecutorListener(@NotNull CommitExecutorListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(36);
        }
        if (parent == null) {
            CommitChangeListDialog.$$$reportNull$$$0(37);
        }
        this.myExecutorEventDispatcher.addListener((EventListener)listener2, parent);
    }

    @Override
    public void refreshDataBeforeCommit() {
        this.getBrowser().updateDisplayedChangeLists();
    }

    @Override
    @NotNull
    public LocalChangeList getChangeList() {
        LocalChangeList localChangeList = this.getBrowser().getSelectedChangeList();
        if (localChangeList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(38);
        }
        return localChangeList;
    }

    @NotNull
    public List<Change> getDisplayedChanges() {
        List<Change> list = this.getBrowser().getDisplayedChanges();
        if (list == null) {
            CommitChangeListDialog.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public List<Change> getIncludedChanges() {
        List<Change> list = this.getBrowser().getIncludedChanges();
        if (list == null) {
            CommitChangeListDialog.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public List<FilePath> getDisplayedUnversionedFiles() {
        List<FilePath> list = this.getBrowser().getDisplayedUnversionedFiles();
        if (list == null) {
            CommitChangeListDialog.$$$reportNull$$$0(41);
        }
        return list;
    }

    @NotNull
    public List<FilePath> getIncludedUnversionedFiles() {
        List<FilePath> list = this.getBrowser().getIncludedUnversionedFiles();
        if (list == null) {
            CommitChangeListDialog.$$$reportNull$$$0(42);
        }
        return list;
    }

    @Override
    @NotNull
    public InclusionModel getInclusionModel() {
        InclusionModel inclusionModel = this.getBrowser().getViewer().getInclusionModel();
        if (inclusionModel == null) {
            CommitChangeListDialog.$$$reportNull$$$0(43);
        }
        return inclusionModel;
    }

    public void addInclusionListener(@NotNull InclusionListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(44);
        }
        if (parent == null) {
            CommitChangeListDialog.$$$reportNull$$$0(45);
        }
        this.myInclusionEventDispatcher.addListener((EventListener)listener2, parent);
    }

    @Override
    public boolean confirmCommitWithEmptyMessage() {
        Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"error.text.check.in.with.empty.comment", (Object[])new Object[0]), (String)VcsBundle.message((String)"error.title.check.in.with.empty.comment", (Object[])new Object[0]));
        return false;
    }

    public void startBeforeCommitChecks() {
        this.stopUpdate();
    }

    public void endBeforeCommitChecks(@NotNull CommitChecksResult result2) {
        if (result2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(46);
        }
        if (result2.getShouldCommit()) {
            return;
        }
        if (result2.getShouldCloseWindow()) {
            this.doCancelAction();
        } else {
            this.restartUpdate();
        }
    }

    @NotNull
    private CommitOptions getCommitOptions() {
        CommitOptions commitOptions = this.myWorkflow.getCommitOptions();
        if (commitOptions == null) {
            CommitChangeListDialog.$$$reportNull$$$0(47);
        }
        return commitOptions;
    }

    public boolean isDefaultCommitEnabled() {
        return this.myWorkflow.isDefaultCommitEnabled();
    }

    @NotNull
    CommitMessage getCommitMessageComponent() {
        CommitMessage commitMessage = this.myCommitMessageArea;
        if (commitMessage == null) {
            CommitChangeListDialog.$$$reportNull$$$0(48);
        }
        return commitMessage;
    }

    @NotNull
    JComponent getBrowserBottomPanel() {
        JComponent jComponent = this.myBrowserBottomPanel;
        if (jComponent == null) {
            CommitChangeListDialog.$$$reportNull$$$0(49);
        }
        return jComponent;
    }

    private void refreshDetails(boolean fromModelRefresh, boolean async) {
        Runnable task2 = () -> {
            if (this.myDetailsSplitter.isOn()) {
                this.myDiffDetails.refresh(fromModelRefresh);
            }
        };
        if (async) {
            ApplicationManager.getApplication().invokeLater(task2, ModalityState.stateForComponent((Component)this.getRootPane()));
        } else {
            task2.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 20, 21, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 38, 39, 40, 41, 42, 43, 47, 48, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "included";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedVcses";
                break;
            }
            case 12: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executors";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workflow";
                break;
            }
            case 15: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 16: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCommitActionName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsesForLocalChanges";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorActions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessage";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalComponents";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessageUi";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitOptionsUi";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCommitActionName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedChanges";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedUnversionedFiles";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedUnversionedFiles";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getInclusionModel";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitOptions";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessageComponent";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserBottomPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVcsesForLocalChanges";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commitWithExecutor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "commitVcsChanges";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showCommitDialog";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showNothingToCommitMessage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addStateListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsSplitter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initCommitActions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorActions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCommitActionName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addDataProvider";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addExecutorListener";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addInclusionListener";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "endBeforeCommitChecks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 20, 21, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 38, 39, 40, 41, 42, 43, 47, 48, 49 -> new IllegalStateException(string);
        };
    }

    private class MyChangeProcessor
    extends ChangeViewDiffRequestProcessor {
        MyChangeProcessor(Project project, boolean enablePartialCommit) {
            if (project == null) {
                MyChangeProcessor.$$$reportNull$$$0(0);
            }
            super(project, "CommitDialog");
            this.putContextUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK, true);
            this.putContextUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, enablePartialCommit);
            this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        }

        @NotNull
        public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges() {
            return MyChangeProcessor.wrap(CommitChangeListDialog.this.getBrowser().getSelectedChanges(), CommitChangeListDialog.this.getBrowser().getSelectedUnversionedFiles());
        }

        @NotNull
        public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges() {
            return MyChangeProcessor.wrap(CommitChangeListDialog.this.getDisplayedChanges(), CommitChangeListDialog.this.getDisplayedUnversionedFiles());
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            if (change == null) {
                MyChangeProcessor.$$$reportNull$$$0(1);
            }
            CommitChangeListDialog.this.getBrowser().selectEntries(Collections.singletonList(change.getUserObject()));
        }

        @NotNull
        private static Iterable<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull Collection<? extends Change> changes, @NotNull Collection<? extends FilePath> unversioned) {
            if (changes == null) {
                MyChangeProcessor.$$$reportNull$$$0(2);
            }
            if (unversioned == null) {
                MyChangeProcessor.$$$reportNull$$$0(3);
            }
            JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from(changes).map(ChangeViewDiffRequestProcessor.ChangeWrapper::new)).append((Iterable)JBIterable.from(unversioned).map(ChangeViewDiffRequestProcessor.UnversionedFileWrapper::new));
            if (jBIterable == null) {
                MyChangeProcessor.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @NotNull
        protected Runnable createAfterNavigateCallback() {
            Runnable runnable = () -> CommitChangeListDialog.this.doCancelAction();
            if (runnable == null) {
                MyChangeProcessor.$$$reportNull$$$0(5);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unversioned";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAfterNavigateCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChange";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyOptionsLayout
    extends AbstractLayoutManager {
        @NotNull
        private final JComponent myPanel;
        @NotNull
        private final CommitOptionsPanel myOptions;
        @NotNull
        private final JComponent myOptionsPanel;
        private final int myMinOptionsWidth;
        private final int myMaxOptionsWidth;

        MyOptionsLayout(@NotNull JComponent panel, @NotNull CommitOptionsPanel options, int minOptionsWidth, int maxOptionsWidth) {
            if (panel == null) {
                MyOptionsLayout.$$$reportNull$$$0(0);
            }
            if (options == null) {
                MyOptionsLayout.$$$reportNull$$$0(1);
            }
            this.myPanel = panel;
            this.myOptions = options;
            this.myOptionsPanel = options.component;
            this.myMinOptionsWidth = minOptionsWidth;
            this.myMaxOptionsWidth = maxOptionsWidth;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size1 = this.myPanel.getPreferredSize();
            Dimension size2 = this.myOptionsPanel.getPreferredSize();
            return new Dimension(size1.width + size2.width, Math.max(size1.height, size2.height));
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                MyOptionsLayout.$$$reportNull$$$0(2);
            }
            Rectangle bounds = parent.getBounds();
            int preferredWidth = this.myOptionsPanel.getPreferredSize().width;
            int optionsWidth = this.myOptions.isEmpty() ? 0 : MathUtil.clamp((int)preferredWidth, (int)this.myMinOptionsWidth, (int)this.myMaxOptionsWidth);
            this.myPanel.setBounds(new Rectangle(0, 0, bounds.width - optionsWidth, bounds.height));
            this.myOptionsPanel.setBounds(new Rectangle(bounds.width - optionsWidth, 0, optionsWidth, bounds.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyOptionsLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutContainer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CommitAction
    extends AbstractAction
    implements OptionAction {
        private Action @NotNull [] myOptions;

        private CommitAction(String okActionText) {
            super(okActionText);
            this.myOptions = new Action[0];
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CommitExecutorListener)CommitChangeListDialog.this.myExecutorEventDispatcher.getMulticaster()).executorCalled(null);
        }

        public Action @NotNull [] getOptions() {
            if (this.myOptions == null) {
                CommitAction.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        public void setOptions(@NotNull List<? extends Action> actions) {
            if (actions == null) {
                CommitAction.$$$reportNull$$$0(1);
            }
            this.myOptions = actions.toArray(new Action[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setOptions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private class CommitExecutorAction
    extends AbstractAction {
        @Nullable
        private final CommitExecutor myCommitExecutor;

        CommitExecutorAction(AnAction anAction) {
            if (anAction == null) {
                CommitExecutorAction.$$$reportNull$$$0(0);
            }
            this.putValue("AnAction", anAction);
            this.myCommitExecutor = null;
        }

        CommitExecutorAction(CommitExecutor commitExecutor) {
            if (commitExecutor == null) {
                CommitExecutorAction.$$$reportNull$$$0(1);
            }
            super(commitExecutor.getActionText());
            this.myCommitExecutor = commitExecutor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myCommitExecutor != null) {
                ((CommitExecutorListener)CommitChangeListDialog.this.myExecutorEventDispatcher.getMulticaster()).executorCalled(this.myCommitExecutor);
            }
        }

        public void updateEnabled(boolean hasDiffs) {
            if (this.myCommitExecutor != null) {
                this.setEnabled(hasDiffs || !this.myCommitExecutor.areChangesRequired());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commitExecutor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitExecutorAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

