/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.Document;
import circlet.client.api.DocumentContainerInfo;
import circlet.client.api.DocumentFolder;
import circlet.client.api.DraftsKt;
import circlet.client.api.FolderRecordPermissionsChecker;
import circlet.client.api.PersonalDocumentContainerInfo;
import circlet.client.api.RefResolverExtKt;
import circlet.client.api.TD_MemberProfile;
import circlet.common.documents.DocumentPermissionChecker;
import circlet.common.documents.FolderPermissionChecker;
import circlet.common.permissions.CreateDocuments;
import circlet.common.permissions.DocumentFolderRight;
import circlet.common.permissions.DocumentRight;
import circlet.common.permissions.ViewFoldersMetadata;
import circlet.platform.api.Ref;
import circlet.platform.api.RefResolver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcirclet/client/api/DocumentRecordPermissionsChecker;", "Lcirclet/common/documents/DocumentPermissionChecker;", "document", "Lcirclet/client/api/Document;", "me", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TD_MemberProfile;", "refResolver", "Lcirclet/platform/api/RefResolver;", "grantedRights", "", "", "<init>", "(Lcirclet/client/api/Document;Lcirclet/platform/api/Ref;Lcirclet/platform/api/RefResolver;Ljava/util/List;)V", "hasPermission", "", "right", "Lcirclet/common/permissions/DocumentRight;", "hasPermissionInParentContext", "Lcirclet/common/permissions/DocumentFolderRight;", "isArchived", "isOwner", "getParentFolderChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "isContainerAccessible", "spaceport-client-api"})
@SourceDebugExtension(value={"SMAP\nDrafts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Drafts.kt\ncirclet/client/api/DocumentRecordPermissionsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1731:1\n1755#2,3:1732\n1755#2,3:1736\n1#3:1735\n*S KotlinDebug\n*F\n+ 1 Drafts.kt\ncirclet/client/api/DocumentRecordPermissionsChecker\n*L\n1584#1:1732,3\n1588#1:1736,3\n*E\n"})
public final class DocumentRecordPermissionsChecker
implements DocumentPermissionChecker {
    @NotNull
    private final Document document;
    @NotNull
    private final Ref<TD_MemberProfile> me;
    @NotNull
    private final RefResolver refResolver;
    @NotNull
    private final List<String> grantedRights;

    public DocumentRecordPermissionsChecker(@NotNull Document document2, @NotNull Ref<TD_MemberProfile> me2, @NotNull RefResolver refResolver, @NotNull List<String> grantedRights) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter(me2, (String)"me");
        Intrinsics.checkNotNullParameter((Object)refResolver, (String)"refResolver");
        Intrinsics.checkNotNullParameter(grantedRights, (String)"grantedRights");
        this.document = document2;
        this.me = me2;
        this.refResolver = refResolver;
        this.grantedRights = grantedRights;
    }

    public /* synthetic */ DocumentRecordPermissionsChecker(Document document2, Ref ref2, RefResolver refResolver, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list2 = document2.getGrantedRights();
        }
        this(document2, ref2, refResolver, list2);
    }

    @Override
    public boolean hasPermission(@NotNull DocumentRight right) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Iterable $this$any$iv = this.grantedRights;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)right.getUniqueCode-lTrUgfw())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean hasPermissionInParentContext(@NotNull DocumentFolderRight right) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Ref<DocumentFolder> ref2 = this.document.getFolderRef();
            if (ref2 != null) {
                Ref<DocumentFolder> it = ref2;
                boolean bl2 = false;
                Iterable $this$any$iv = RefResolverExtKt.resolveWith(it, this.refResolver).getGrantedRights();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2, (Object)right.getUniqueCode-lTrUgfw())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = this.isOwner();
            }
        }
        return bl;
    }

    @Override
    public boolean isArchived() {
        return this.document.getArchived();
    }

    private final boolean isOwner() {
        DocumentContainerInfo documentContainerInfo = this.document.getContainerInfo();
        PersonalDocumentContainerInfo personalDocumentContainerInfo = documentContainerInfo instanceof PersonalDocumentContainerInfo ? (PersonalDocumentContainerInfo)documentContainerInfo : null;
        return Intrinsics.areEqual(personalDocumentContainerInfo != null ? personalDocumentContainerInfo.getOwner() : null, this.me);
    }

    @Override
    @Nullable
    public FolderPermissionChecker getParentFolderChecker() {
        FolderRecordPermissionsChecker folderRecordPermissionsChecker;
        Ref<DocumentFolder> ref2 = this.document.getFolderRef();
        if (ref2 != null) {
            Ref<DocumentFolder> it = ref2;
            boolean bl = false;
            folderRecordPermissionsChecker = new FolderRecordPermissionsChecker(RefResolverExtKt.resolveWith(it, this.refResolver), this.refResolver, null, 4, null);
        } else {
            folderRecordPermissionsChecker = null;
        }
        return folderRecordPermissionsChecker;
    }

    @Override
    public boolean isContainerAccessible() {
        boolean bl;
        List<String> list2 = DraftsKt.getContainerInfo(this.document).getGrantedRights();
        if (list2 != null) {
            List<String> it = list2;
            boolean bl2 = false;
            bl = it.contains(ViewFoldersMetadata.INSTANCE.getUniqueCode-lTrUgfw()) || it.contains(CreateDocuments.INSTANCE.getUniqueCode-lTrUgfw());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canRestore() {
        return DocumentPermissionChecker.DefaultImpls.canRestore(this);
    }
}

