/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstantDeserializer<T extends Temporal>
extends JSR310DateTimeDeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    private static final boolean DEFAULT_NORMALIZE_ZONE_ID = JavaTimeFeature.NORMALIZE_DESERIALIZED_ZONE_ID.enabledByDefault();
    private static final boolean DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS = JavaTimeFeature.ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS.enabledByDefault();
    protected static final Pattern ISO8601_COLONLESS_OFFSET_REGEX = Pattern.compile("[+-][0-9]{4}(?=\\[|$)");
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null, true, DEFAULT_NORMALIZE_ZONE_ID, DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.isEqual(OffsetDateTime.MIN) || d.isEqual(OffsetDateTime.MAX) ? d : d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), true, DEFAULT_NORMALIZE_ZONE_ID, DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, a -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), ZonedDateTime::withZoneSameInstant, false, DEFAULT_NORMALIZE_ZONE_ID, DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;
    protected final boolean replaceZeroOffsetAsZ;
    protected final Boolean _adjustToContextTZOverride;
    protected final Boolean _readTimestampsAsNanosOverride;
    protected final boolean _normalizeZoneId;
    protected final boolean _alwaysAllowStringifiedDateTimestamps;

    protected InstantDeserializer(Class<T> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust, boolean replaceZeroOffsetAsZ, boolean normalizeZoneId, boolean readNumericStringsAsTimestamp) {
        super(supportedType, formatter);
        this.parsedToValue = parsedToValue;
        this.fromMilliseconds = fromMilliseconds;
        this.fromNanoseconds = fromNanoseconds;
        this.adjust = adjust == null ? (d, z) -> d : adjust;
        this.replaceZeroOffsetAsZ = replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = null;
        this._readTimestampsAsNanosOverride = null;
        this._normalizeZoneId = normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = readNumericStringsAsTimestamp;
    }

    @Deprecated
    protected InstantDeserializer(Class<T> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust, boolean replaceZeroOffsetAsZ) {
        this(supportedType, formatter, parsedToValue, fromMilliseconds, fromNanoseconds, adjust, replaceZeroOffsetAsZ, DEFAULT_NORMALIZE_ZONE_ID, DEFAULT_ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    }

    protected InstantDeserializer(InstantDeserializer<T> base, DateTimeFormatter f) {
        super(base.handledType(), f);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base._adjustToContextTZOverride;
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
        this._normalizeZoneId = base._normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = base._alwaysAllowStringifiedDateTimestamps;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, Boolean adjustToContextTimezoneOverride) {
        super(base.handledType(), base._formatter);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = base.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = adjustToContextTimezoneOverride;
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
        this._normalizeZoneId = base._normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = base._alwaysAllowStringifiedDateTimestamps;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, DateTimeFormatter f, Boolean leniency) {
        super(base.handledType(), f, leniency);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base._adjustToContextTZOverride;
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
        this._normalizeZoneId = base._normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = base._alwaysAllowStringifiedDateTimestamps;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape, Boolean adjustToContextTimezoneOverride, Boolean readTimestampsAsNanosOverride) {
        super(base, leniency, formatter, shape);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = base.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = adjustToContextTimezoneOverride;
        this._readTimestampsAsNanosOverride = readTimestampsAsNanosOverride;
        this._normalizeZoneId = base._normalizeZoneId;
        this._alwaysAllowStringifiedDateTimestamps = base._alwaysAllowStringifiedDateTimestamps;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, JacksonFeatureSet<JavaTimeFeature> features2) {
        super(base.handledType(), base._formatter);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = base.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = base._adjustToContextTZOverride;
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
        this._normalizeZoneId = features2.isEnabled((JacksonFeature)JavaTimeFeature.NORMALIZE_DESERIALIZED_ZONE_ID);
        this._alwaysAllowStringifiedDateTimestamps = features2.isEnabled((JacksonFeature)JavaTimeFeature.ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS);
    }

    @Override
    protected InstantDeserializer<T> withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dtf);
    }

    @Override
    protected InstantDeserializer<T> withLeniency(Boolean leniency) {
        return new InstantDeserializer<T>(this, this._formatter, leniency);
    }

    public InstantDeserializer<T> withFeatures(JacksonFeatureSet<JavaTimeFeature> features2) {
        if (this._normalizeZoneId == features2.isEnabled((JacksonFeature)JavaTimeFeature.NORMALIZE_DESERIALIZED_ZONE_ID) && this._alwaysAllowStringifiedDateTimestamps == features2.isEnabled((JacksonFeature)JavaTimeFeature.ALWAYS_ALLOW_STRINGIFIED_DATE_TIMESTAMPS)) {
            return this;
        }
        return new InstantDeserializer<T>(this, features2);
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext ctxt, BeanProperty property2, JsonFormat.Value formatOverrides) {
        InstantDeserializer deser = (InstantDeserializer)super._withFormatOverrides(ctxt, property2, formatOverrides);
        Boolean adjustToContextTZOverride = formatOverrides.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        Boolean readTimestampsAsNanosOverride = formatOverrides.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        if (!Objects.equals(adjustToContextTZOverride, deser._adjustToContextTZOverride) || !Objects.equals(readTimestampsAsNanosOverride, deser._readTimestampsAsNanosOverride)) {
            return new InstantDeserializer<T>(deser, deser._isLenient, deser._formatter, deser._shape, adjustToContextTZOverride, readTimestampsAsNanosOverride);
        }
        return deser;
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.currentTokenId()) {
            case 8: {
                return this._fromDecimal(context, parser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(context, parser.getLongValue());
            }
            case 6: {
                return this._fromString(parser, context, parser.getText());
            }
            case 1: {
                return this._fromString(parser, context, context.extractScalarFromObject(parser, (JsonDeserializer)this, this.handledType()));
            }
            case 12: {
                return (T)((Temporal)parser.getEmbeddedObject());
            }
            case 3: {
                return (T)((Temporal)this._deserializeFromArray(parser, context));
            }
        }
        return (T)((Temporal)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT));
    }

    protected boolean shouldAdjustToContextTimezone(DeserializationContext context) {
        return this._adjustToContextTZOverride != null ? this._adjustToContextTZOverride.booleanValue() : context.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext context) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    protected int _countPeriods(String str) {
        int commas = 0;
        int end = str.length();
        for (int i = 0; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            if (ch == '.') {
                ++commas;
                continue;
            }
            return -1;
        }
        return commas;
    }

    protected T _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        Temporal value2;
        String string = string0.trim();
        if (string.length() == 0) {
            return (T)((Temporal)this._fromEmptyString(p, ctxt, string));
        }
        if (this._alwaysAllowStringifiedDateTimestamps || this._formatter == DateTimeFormatter.ISO_INSTANT || this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            int dots = this._countPeriods(string);
            if (dots >= 0) {
                try {
                    if (dots == 0) {
                        return this._fromLong(ctxt, NumberInput.parseLong((String)string));
                    }
                    if (dots == 1) {
                        return this._fromDecimal(ctxt, NumberInput.parseBigDecimal((String)string, (boolean)false));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string = this.replaceZeroOffsetAsZIfNecessary(string);
        }
        if (this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            string = this.addInColonToOffsetIfMissing(string);
        }
        try {
            TemporalAccessor acc = this._formatter.parse(string);
            value2 = (Temporal)this.parsedToValue.apply(acc);
            if (this.shouldAdjustToContextTimezone(ctxt)) {
                return (T)((Temporal)this.adjust.apply(value2, this.getZone(ctxt)));
            }
        }
        catch (DateTimeException e) {
            value2 = (Temporal)this._handleDateTimeException(ctxt, e, string);
        }
        return (T)value2;
    }

    protected T _fromLong(DeserializationContext context, long timestamp) {
        if (this.shouldReadTimestampsAsNanoseconds(context)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(timestamp, 0, this.getZone(context))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(timestamp, this.getZone(context))));
    }

    protected T _fromDecimal(DeserializationContext context, BigDecimal value2) {
        FromDecimalArguments args = DecimalUtils.extractSecondsAndNanos(value2, (s, ns) -> new FromDecimalArguments((long)s, (int)ns, this.getZone(context)));
        return (T)((Temporal)this.fromNanoseconds.apply(args));
    }

    private ZoneId getZone(DeserializationContext context) {
        if (this._valueClass == Instant.class) {
            return null;
        }
        ZoneId zoneId = context.getTimeZone().toZoneId();
        return this._normalizeZoneId ? zoneId.normalized() : zoneId;
    }

    private String replaceZeroOffsetAsZIfNecessary(String text2) {
        if (this.replaceZeroOffsetAsZ) {
            return InstantDeserializer.replaceZeroOffsetAsZ(text2);
        }
        return text2;
    }

    private static String replaceZeroOffsetAsZ(String text2) {
        int plusIndex = text2.lastIndexOf(43);
        if (plusIndex < 0) {
            return text2;
        }
        int maybeOffsetIndex = plusIndex + 1;
        int remaining = text2.length() - maybeOffsetIndex;
        switch (remaining) {
            case 2: {
                return text2.regionMatches(maybeOffsetIndex, "00", 0, remaining) ? text2.substring(0, plusIndex) + 'Z' : text2;
            }
            case 4: {
                return text2.regionMatches(maybeOffsetIndex, "0000", 0, remaining) ? text2.substring(0, plusIndex) + 'Z' : text2;
            }
            case 5: {
                return text2.regionMatches(maybeOffsetIndex, "00:00", 0, remaining) ? text2.substring(0, plusIndex) + 'Z' : text2;
            }
        }
        return text2;
    }

    private String addInColonToOffsetIfMissing(String text2) {
        Matcher matcher2 = ISO8601_COLONLESS_OFFSET_REGEX.matcher(text2);
        if (matcher2.find()) {
            StringBuilder sb = new StringBuilder(matcher2.group(0));
            sb.insert(3, ":");
            return matcher2.replaceFirst(sb.toString());
        }
        return text2;
    }

    public static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        FromDecimalArguments(long integer, int fraction, ZoneId zoneId) {
            this.integer = integer;
            this.fraction = fraction;
            this.zoneId = zoneId;
        }
    }

    public static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        FromIntegerArguments(long value2, ZoneId zoneId) {
            this.value = value2;
            this.zoneId = zoneId;
        }
    }
}

