/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.auth;

import circlet.common.oauth.OAuthClientConfig;
import circlet.platform.api.oauth.OAuthTokenResponse;
import circlet.platform.workspaces.WorkspaceConfiguration;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.spaceport.auth.SpaceOAuthCredentials;
import com.intellij.spaceport.auth.SpaceOAuthCredentialsAcquirer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH$J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/spaceport/auth/AbstractSpaceOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lcom/intellij/spaceport/auth/SpaceOAuthCredentials;", "wsConfig", "Lcirclet/platform/workspaces/WorkspaceConfiguration;", "clientConfig", "Lcirclet/common/oauth/OAuthClientConfig;", "<init>", "(Lcirclet/platform/workspaces/WorkspaceConfiguration;Lcirclet/common/oauth/OAuthClientConfig;)V", "port", "", "serviceName", "", "server", "getServer", "()Ljava/lang/String;", "redirectUriRaw", "acquireCredentials", "Lcirclet/platform/api/oauth/OAuthTokenResponse;", "code", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "getAuthorizationCodeUrl", "()Lcom/intellij/util/Url;", "credentialsAcquirer", "Lcom/intellij/spaceport/auth/SpaceOAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/spaceport/auth/SpaceOAuthCredentialsAcquirer;", "authUrlWithParameters", "getAuthUrlWithParameters", "intellij.spaceport"})
public abstract class AbstractSpaceOAuthRequest
implements OAuthRequest<SpaceOAuthCredentials> {
    @NotNull
    private final WorkspaceConfiguration wsConfig;
    @NotNull
    private final OAuthClientConfig clientConfig;
    private final int port;
    @NotNull
    private final String server;
    @NotNull
    private final String redirectUriRaw;
    @NotNull
    private final Url authorizationCodeUrl;
    @NotNull
    private final SpaceOAuthCredentialsAcquirer credentialsAcquirer;
    @NotNull
    private final Url authUrlWithParameters;

    public AbstractSpaceOAuthRequest(@NotNull WorkspaceConfiguration wsConfig, @NotNull OAuthClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter((Object)wsConfig, (String)"wsConfig");
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        this.wsConfig = wsConfig;
        this.clientConfig = clientConfig;
        this.port = BuiltInServerManager.Companion.getInstance().getPort();
        this.server = this.wsConfig.getServer();
        Object object = (String)SequencesKt.firstOrNull(this.clientConfig.getRedirectURIs());
        if (object == null) {
            object = "http://localhost:" + this.port + "/api/" + this.serviceName() + "/authorization_code";
        }
        this.redirectUriRaw = object;
        this.authorizationCodeUrl = Urls.newFromEncoded((String)this.redirectUriRaw);
        this.credentialsAcquirer = new SpaceOAuthCredentialsAcquirer(this.wsConfig, this.redirectUriRaw);
        String string = this.getAuthorizationCodeUrl().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        this.authUrlWithParameters = Urls.newFromEncoded((String)this.wsConfig.codeFlowURL(string));
    }

    @NotNull
    protected abstract String serviceName();

    @NotNull
    public final String getServer() {
        return this.server;
    }

    @Nullable
    public final Object acquireCredentials(@NotNull String code, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        return WorkspaceConfiguration.DefaultImpls.handleCodeFlowRedirect$default(this.wsConfig, this.redirectUriRaw + "?code=" + code, this.redirectUriRaw, null, $completion, 4, null);
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        return this.authorizationCodeUrl;
    }

    @NotNull
    public SpaceOAuthCredentialsAcquirer getCredentialsAcquirer() {
        return this.credentialsAcquirer;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        return this.authUrlWithParameters;
    }
}

