/*
 * Decompiled with CFR 0.152.
 */
package runtime.date;

import java.time.temporal.WeekFields;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.Months;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormatter;
import runtime.date.DateFormat;
import runtime.date.DateTimeMode;
import runtime.date.TimeOfDay;
import runtime.stringUtils.StringUtilsKt;
import runtime.stringUtils.Symbols;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001f\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000b\u001a\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000e\u001a\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0010\u001a)\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0016\u001a\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0017\u001a&\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0017\u001a\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u001c\u001a\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007\u001a\u0016\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t\u001a\u000e\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007\u001a\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0007\u001a\u0016\u0010*\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t\u001a\u001e\u0010+\u001a\u00020\u0017*\u00020\u000e2\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010(\u001a\u0012\u0010/\u001a\u00020\u0017*\u00020\u00172\u0006\u0010,\u001a\u00020-\u001a\n\u0010,\u001a\u00020-*\u00020\u0017\"\u001b\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0018\u001a\u00020\t*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00060\u00b2\u0006\n\u00101\u001a\u00020\u0019X\u008a\u0084\u0002\u00b2\u0006\n\u00102\u001a\u000203X\u008a\u0084\u0002\u00b2\u0006\n\u00104\u001a\u000203X\u008a\u0084\u0002\u00b2\u0006\n\u00105\u001a\u000203X\u008a\u0084\u0002"}, d2={"DATE_LOCALE", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "getDATE_LOCALE", "()Ljava/util/Locale;", "Ljava/util/Locale;", "formatDate", "", "epochMillis", "", "nowMillis", "(JLjava/lang/Long;)Ljava/lang/String;", "formatTime", "date", "Lorg/joda/time/LocalDate;", "now", "Lkotlinx/datetime/LocalDate;", "formatFullDate", "dateTime", "formatDateTime", "mode", "Lruntime/date/DateTimeMode;", "(JLruntime/date/DateTimeMode;Ljava/lang/Long;)Ljava/lang/String;", "Lorg/joda/time/DateTime;", "standardWeeks", "Lorg/joda/time/Duration;", "getStandardWeeks", "(Lorg/joda/time/Duration;)J", "Lkotlinx/datetime/LocalDateTime;", "zone", "Lkotlinx/datetime/TimeZone;", "formatFullDateTime", "setDefaultTimeZone", "", "name", "formatTimeSpan", "from", "to", "setDefaultLocale", "dateTimeZoneForIdOrNull", "Lorg/joda/time/DateTimeZone;", "id", "formatDateSpan", "toDateTime", "timeOfDay", "Lruntime/date/TimeOfDay;", "timezone", "withTime", "platform-runtime", "durationBetweenDayStart", "yearsBetween", "", "monthsBetween", "weeksBetween"})
@SourceDebugExtension(value={"SMAP\nDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dates.kt\nruntime/date/DatesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
public final class DatesKt {
    private static final Locale DATE_LOCALE = Locale.ENGLISH;

    public static final Locale getDATE_LOCALE() {
        return DATE_LOCALE;
    }

    @NotNull
    public static final String formatDate(long epochMillis, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Long l = nowMillis;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            dateTime2 = new DateTime(it);
        } else {
            dateTime2 = new DateTime();
        }
        DateTime now = dateTime2;
        DateTime dateTime3 = new DateTime(epochMillis);
        LocalDate localDate = dateTime3.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        LocalDate localDate2 = now.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"toLocalDate(...)");
        return DatesKt.formatDate(localDate, localDate2);
    }

    public static /* synthetic */ String formatDate$default(long l, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = null;
        }
        return DatesKt.formatDate(l, l2);
    }

    @NotNull
    public static final String formatTime(long epochMillis) {
        DateTime dateTime2 = new DateTime(epochMillis);
        String string = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2.toLocalTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        return string;
    }

    @NotNull
    public static final String formatDate(@NotNull LocalDate date2, @NotNull LocalDate now) {
        String string;
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (date2.getYear() == now.getYear()) {
            String string2 = DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print(date2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"print(...)");
        } else {
            string = DatesKt.formatFullDate(date2);
        }
        return string;
    }

    @NotNull
    public static final String formatDate(@NotNull kotlinx.datetime.LocalDate date2, @NotNull kotlinx.datetime.LocalDate now) {
        String string;
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (date2.getYear() == now.getYear()) {
            String string2 = ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)date2).format(DateFormat.NO_YEAR_DATE_NON_BREAKING.getJavaFormatter());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else {
            string = DatesKt.formatFullDate(date2);
        }
        return string;
    }

    @NotNull
    public static final String formatFullDate(@NotNull LocalDate dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        String string = DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        return string;
    }

    @NotNull
    public static final String formatFullDate(@NotNull kotlinx.datetime.LocalDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        String string = ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)date2).format(DateFormat.DATE_NON_BREAKING.getJavaFormatter());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String formatDateTime(long epochMillis, @NotNull DateTimeMode mode, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Long l = nowMillis;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            dateTime2 = new DateTime(it);
        } else {
            dateTime2 = new DateTime();
        }
        DateTime now = dateTime2;
        DateTime dateTime3 = new DateTime(epochMillis);
        return DatesKt.formatDateTime(dateTime3, mode, now);
    }

    public static /* synthetic */ String formatDateTime$default(long l, DateTimeMode dateTimeMode, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeMode = DateTimeMode.DEFAULT;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        return DatesKt.formatDateTime(l, dateTimeMode, l2);
    }

    @NotNull
    public static final String formatDateTime(@NotNull DateTime dateTime2, @NotNull DateTimeMode mode, @NotNull DateTime now) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Duration duration = new Duration(dateTime2, now);
        Lazy durationBetweenDayStart$delegate = LazyKt.lazy(() -> DatesKt.formatDateTime$lambda$2(dateTime2, now));
        if (now.isBefore(dateTime2)) {
            String string;
            if ((mode.isDefault$platform_runtime() || mode.isCompact$platform_runtime()) && Intrinsics.areEqual((Object)dateTime2.withTimeAtStartOfDay(), (Object)now.withTimeAtStartOfDay())) {
                String string2 = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"print(...)");
            } else {
                String string3 = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"print(...)");
            }
            return string;
        }
        if (mode.isDefault$platform_runtime() && duration.getStandardMinutes() < 1L) {
            object = "just now";
        } else if (mode.isDefault$platform_runtime() && duration.getStandardHours() < 1L) {
            object = duration.getStandardMinutes() + "m" + Symbols.Nbsp + "ago";
        } else if (mode.isDefault$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.withTimeAtStartOfDay(), (Object)now.withTimeAtStartOfDay())) {
            String string = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isDefault$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string = DateFormat.NO_YEAR_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isAbsolute$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string = DateFormat.NO_YEAR_ABSOLUTE_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isAbsolute$platform_runtime()) {
            String string = DateFormat.ABSOLUTE_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.dayOfYear(), (Object)now.dayOfYear()) && Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year())) {
            String string = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.weekOfWeekyear(), (Object)now.weekOfWeekyear())) {
            String string = DateFormat.WEEKDAY.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isCompact$platform_runtime() && (Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year()) || duration.getStandardDays() < 120L)) {
            String string = DateFormat.MONTH_DAY.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isCompact$platform_runtime()) {
            String string = DateFormat.YEAR.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isTable$platform_runtime()) {
            String string = DateFormat.DASHED_DATE_TIME.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else if (mode.isRelative$platform_runtime()) {
            Lazy yearsBetween$delegate = LazyKt.lazy(() -> DatesKt.formatDateTime$lambda$4(dateTime2, now));
            Lazy monthsBetween$delegate = LazyKt.lazy(() -> DatesKt.formatDateTime$lambda$6(dateTime2, now));
            Lazy weeksBetween$delegate = LazyKt.lazy(() -> DatesKt.formatDateTime$lambda$8(dateTime2, now));
            object = duration.getStandardMinutes() < 1L ? "just now" : (duration.getStandardMinutes() < 60L ? duration.getStandardMinutes() + "m" + Symbols.Nbsp + "ago" : (duration.getStandardHours() < 24L ? duration.getStandardHours() + "h" + Symbols.Nbsp + "ago" : (DatesKt.formatDateTime$lambda$3((Lazy<Duration>)durationBetweenDayStart$delegate).getStandardDays() < 2L ? "yesterday" : (DatesKt.formatDateTime$lambda$3((Lazy<Duration>)durationBetweenDayStart$delegate).getStandardDays() < 7L ? DatesKt.formatDateTime$lambda$3((Lazy<Duration>)durationBetweenDayStart$delegate).getStandardDays() + "d" + Symbols.Nbsp + "ago" : (DatesKt.formatDateTime$lambda$9((Lazy<Integer>)weeksBetween$delegate) < 5 ? "" + DatesKt.formatDateTime$lambda$9((Lazy<Integer>)weeksBetween$delegate) + Symbols.Nbsp + StringUtilsKt.pluralize("week", DatesKt.formatDateTime$lambda$9((Lazy<Integer>)weeksBetween$delegate)) + Symbols.Nbsp + "ago" : (DatesKt.formatDateTime$lambda$7((Lazy<Integer>)monthsBetween$delegate) < 12 ? "" + DatesKt.formatDateTime$lambda$7((Lazy<Integer>)monthsBetween$delegate) + Symbols.Nbsp + StringUtilsKt.pluralize("month", DatesKt.formatDateTime$lambda$7((Lazy<Integer>)monthsBetween$delegate)) + Symbols.Nbsp + "ago" : "" + DatesKt.formatDateTime$lambda$5((Lazy<Integer>)yearsBetween$delegate) + Symbols.Nbsp + StringUtilsKt.pluralize("year", DatesKt.formatDateTime$lambda$5((Lazy<Integer>)yearsBetween$delegate)) + Symbols.Nbsp + "ago"))))));
        } else {
            String string = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        }
        return object;
    }

    private static final long getStandardWeeks(Duration $this$standardWeeks) {
        return $this$standardWeeks.getMillis() / (long)604800000;
    }

    @NotNull
    public static final String formatDateTime(@NotNull LocalDateTime dateTime2, @NotNull DateTimeMode mode, @NotNull LocalDateTime now, @NotNull TimeZone zone) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        DateTimePeriod period = InstantJvmKt.periodUntil((Instant)TimeZoneKt.toInstant((LocalDateTime)dateTime2, (TimeZone)zone), (Instant)TimeZoneKt.toInstant((LocalDateTime)now, (TimeZone)zone), (TimeZone)zone);
        int periodMinutes = period.getHours() * 60 + period.getMinutes();
        if (now.compareTo(dateTime2) < 0) {
            String string;
            if ((mode.isDefault$platform_runtime() || mode.isCompact$platform_runtime()) && Intrinsics.areEqual((Object)dateTime2.getDate(), (Object)now.getDate())) {
                String string2 = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            } else {
                String string3 = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            }
            return string;
        }
        if (mode.isDefault$platform_runtime() && periodMinutes < 1) {
            object = "just now";
        } else if (mode.isDefault$platform_runtime() && period.getHours() < 1) {
            object = periodMinutes + "m" + Symbols.Nbsp + "ago";
        } else if (mode.isDefault$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.getDate(), (Object)now.getDate())) {
            String string = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (mode.isDefault$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string = DateFormat.NO_YEAR_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (mode.isAbsolute$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string = DateFormat.NO_YEAR_ABSOLUTE_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (mode.isAbsolute$platform_runtime()) {
            String string = DateFormat.ABSOLUTE_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (mode.isCompact$platform_runtime() && dateTime2.getDayOfYear() == now.getDayOfYear() && dateTime2.getYear() == now.getYear()) {
            String string = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (mode.isCompact$platform_runtime() && ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2).get(WeekFields.ISO.weekOfYear()) == ConvertersKt.toJavaLocalDateTime((LocalDateTime)now).get(WeekFields.ISO.weekOfYear())) {
            String string = DateFormat.WEEKDAY.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (mode.isCompact$platform_runtime() && (dateTime2.getYear() == now.getYear() || period.getDays() < 120)) {
            String string = DateFormat.MONTH_DAY.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (mode.isCompact$platform_runtime()) {
            String string = DateFormat.YEAR.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else {
            String string = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        }
        return object;
    }

    @NotNull
    public static final String formatFullDateTime(long epochMillis) {
        String string = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(epochMillis);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        return string;
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull DateTime dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        return DatesKt.formatFullDateTime(dateTime2.getMillis());
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull LocalDateTime dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        String string = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static final void setDefaultTimeZone(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        java.util.TimeZone.setDefault(java.util.TimeZone.getTimeZone(name));
    }

    @NotNull
    public static final String formatTimeSpan(long from, long to) {
        Object object;
        LocalDate nowDate = new LocalDate();
        LocalDate fromDate = new LocalDate(from);
        LocalDate toDate = new LocalDate(to);
        DateTimeFormatter mainFormat = nowDate.getYear() != fromDate.getYear() ? DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter() : DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter();
        if (fromDate.getYear() != toDate.getYear()) {
            object = mainFormat.print(fromDate) + "\u2009\u2013\u2009" + mainFormat.print(toDate);
        } else if (!Intrinsics.areEqual((Object)fromDate.monthOfYear(), (Object)toDate.monthOfYear())) {
            object = DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print(fromDate) + "\u2009\u2013\u2009" + mainFormat.print(toDate);
        } else if (fromDate.getDayOfMonth() != toDate.getDayOfMonth()) {
            object = DateFormat.DAY.getJodaTimeFormatter().print(fromDate) + "\u2013" + mainFormat.print(toDate);
        } else {
            String string = mainFormat.print(fromDate);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        }
        return object;
    }

    public static final void setDefaultLocale(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
    }

    @Nullable
    public static final DateTimeZone dateTimeZoneForIdOrNull(@NotNull String id2) {
        DateTimeZone dateTimeZone;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        try {
            dateTimeZone = DateTimeZone.forID(id2);
        }
        catch (Throwable th) {
            dateTimeZone = null;
        }
        return dateTimeZone;
    }

    @NotNull
    public static final String formatDateSpan(long from, long to) {
        Object object;
        LocalDate start2 = new LocalDate(from);
        LocalDate end = new LocalDate(to);
        if (start2.getYear() == end.getYear() && start2.getDayOfYear() == end.getDayOfYear()) {
            String string = DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(start2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        } else {
            object = start2.getYear() == end.getYear() && start2.getMonthOfYear() == end.getMonthOfYear() ? DateFormat.DAY.getJodaTimeFormatter().print(start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(end) : (start2.getYear() == end.getYear() ? DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print(start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(end) : DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(end));
        }
        return object;
    }

    @NotNull
    public static final DateTime toDateTime(@NotNull LocalDate $this$toDateTime, @NotNull TimeOfDay timeOfDay, @Nullable DateTimeZone timezone) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$toDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$toDateTime.plusDays(1).toDateTimeAtStartOfDay(timezone);
            Intrinsics.checkNotNull((Object)dateTime3);
            dateTime2 = dateTime3;
        } else {
            Integer n = timeOfDay.getSeconds();
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), n != null ? n : 0);
            DateTime dateTime4 = $this$toDateTime.toDateTime(localTime, timezone);
            Intrinsics.checkNotNull((Object)dateTime4);
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    public static /* synthetic */ DateTime toDateTime$default(LocalDate localDate, TimeOfDay timeOfDay, DateTimeZone dateTimeZone, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeZone = null;
        }
        return DatesKt.toDateTime(localDate, timeOfDay, dateTimeZone);
    }

    @NotNull
    public static final DateTime withTime(@NotNull DateTime $this$withTime, @NotNull TimeOfDay timeOfDay) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$withTime.plusDays(1).withTimeAtStartOfDay();
            Intrinsics.checkNotNull((Object)dateTime3);
            dateTime2 = dateTime3;
        } else {
            Integer n = timeOfDay.getSeconds();
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), n != null ? n : 0);
            DateTime dateTime4 = $this$withTime.withTime(localTime);
            Intrinsics.checkNotNull((Object)dateTime4);
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    @NotNull
    public static final TimeOfDay timeOfDay(@NotNull DateTime $this$timeOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$timeOfDay, (String)"<this>");
        return new TimeOfDay($this$timeOfDay.getHourOfDay(), $this$timeOfDay.getMinuteOfHour(), null, 4, null);
    }

    private static final Duration formatDateTime$lambda$2(DateTime $dateTime, DateTime $now) {
        Intrinsics.checkNotNullParameter((Object)$dateTime, (String)"$dateTime");
        Intrinsics.checkNotNullParameter((Object)$now, (String)"$now");
        return new Duration($dateTime.withTimeAtStartOfDay(), $now.withTimeAtStartOfDay());
    }

    private static final Duration formatDateTime$lambda$3(Lazy<Duration> $durationBetweenDayStart$delegate) {
        Lazy<Duration> lazy = $durationBetweenDayStart$delegate;
        return (Duration)lazy.getValue();
    }

    private static final int formatDateTime$lambda$4(DateTime $dateTime, DateTime $now) {
        Intrinsics.checkNotNullParameter((Object)$dateTime, (String)"$dateTime");
        Intrinsics.checkNotNullParameter((Object)$now, (String)"$now");
        return Years.yearsBetween($dateTime, $now).getYears();
    }

    private static final int formatDateTime$lambda$5(Lazy<Integer> $yearsBetween$delegate) {
        Lazy<Integer> lazy = $yearsBetween$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private static final int formatDateTime$lambda$6(DateTime $dateTime, DateTime $now) {
        Intrinsics.checkNotNullParameter((Object)$dateTime, (String)"$dateTime");
        Intrinsics.checkNotNullParameter((Object)$now, (String)"$now");
        return Months.monthsBetween($dateTime, $now).getMonths();
    }

    private static final int formatDateTime$lambda$7(Lazy<Integer> $monthsBetween$delegate) {
        Lazy<Integer> lazy = $monthsBetween$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private static final int formatDateTime$lambda$8(DateTime $dateTime, DateTime $now) {
        Intrinsics.checkNotNullParameter((Object)$dateTime, (String)"$dateTime");
        Intrinsics.checkNotNullParameter((Object)$now, (String)"$now");
        return Weeks.weeksBetween($dateTime, $now).getWeeks();
    }

    private static final int formatDateTime$lambda$9(Lazy<Integer> $weeksBetween$delegate) {
        Lazy<Integer> lazy = $weeksBetween$delegate;
        return ((Number)lazy.getValue()).intValue();
    }
}

