/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import runtime.json.JsonBuilderContext;
import runtime.logging.ErrorInfo;
import runtime.logging.LogAppVersion;
import runtime.utils.HostKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0011\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a_\u0010'\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(*\u00020\u00012\u0006\u0010)\u001a\u00020\u00132\b\b\u0002\u0010*\u001a\u00020\u00132\b\b\u0002\u0010+\u001a\u00020,2'\u0010-\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00010/\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u0002H(0.H\u0082\b\u00a2\u0006\u0002\u00103\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0014\u001a\n \u0002*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\"\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\" \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 *\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0 *\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00064"}, d2={"computedHostName", "", "kotlin.jvm.PlatformType", "getComputedHostName", "()Ljava/lang/String;", "computedHostName$delegate", "Lkotlin/Lazy;", "logAppVersion", "Lruntime/logging/LogAppVersion;", "getLogAppVersion", "()Lruntime/logging/LogAppVersion;", "logAppVersion$delegate", "putLogAppVersion", "", "Lruntime/json/JsonBuilderContext;", "getAppVersion", "getTracingVersionMap", "", "version", "", "ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS", "Lorg/joda/time/format/DateTimeFormatter;", "Lorg/joda/time/format/DateTimeFormatter;", "dateFormat", "timestamp", "", "error", "Lruntime/logging/ErrorInfo;", "Lch/qos/logback/classic/spi/IThrowableProxy;", "getError", "(Lch/qos/logback/classic/spi/IThrowableProxy;)Lruntime/logging/ErrorInfo;", "allCauses", "Lkotlin/sequences/Sequence;", "getAllCauses", "(Lch/qos/logback/classic/spi/IThrowableProxy;)Lkotlin/sequences/Sequence;", "superErrors", "Lch/qos/logback/classic/spi/ThrowableProxy;", "getSuperErrors", "(Lch/qos/logback/classic/spi/ThrowableProxy;)Lkotlin/sequences/Sequence;", "split", "T", "minParts", "maxParts", "delimiter", "", "factory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "parts", "(Ljava/lang/String;IICLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonLogEventsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayoutKt\n+ 2 jsonDsl.kt\nruntime/json/JsonBuilderContext\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n335#1,2:345\n337#1:348\n54#2,4:340\n1#3:344\n1#3:347\n*S KotlinDebug\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/JsonLogEventsLayoutKt\n*L\n45#1:345,2\n45#1:348\n62#1:340,4\n45#1:347\n*E\n"})
public final class JsonLogEventsLayoutKt {
    @NotNull
    private static final Lazy computedHostName$delegate = LazyKt.lazy(JsonLogEventsLayoutKt::computedHostName_delegate$lambda$0);
    @NotNull
    private static final Lazy logAppVersion$delegate = LazyKt.lazy(JsonLogEventsLayoutKt::logAppVersion_delegate$lambda$2);
    private static final int version = 1;
    private static final DateTimeFormatter ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();

    private static final String getComputedHostName() {
        Lazy lazy = computedHostName$delegate;
        return (String)lazy.getValue();
    }

    private static final LogAppVersion getLogAppVersion() {
        Lazy lazy = logAppVersion$delegate;
        return (LogAppVersion)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final void putLogAppVersion(@NotNull JsonBuilderContext $this$putLogAppVersion) {
        block0: {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)$this$putLogAppVersion, (String)"<this>");
            LogAppVersion logAppVersion = JsonLogEventsLayoutKt.getLogAppVersion();
            if (logAppVersion == null) break block0;
            LogAppVersion build = logAppVersion;
            boolean bl = false;
            JsonBuilderContext jsonBuilderContext = $this$putLogAppVersion;
            String $this$put$iv = "app_build";
            boolean $i$f$put = false;
            ObjectNode objNode$iv = this_$iv.get__factory().objectNode();
            Intrinsics.checkNotNull((Object)objNode$iv);
            JsonBuilderContext $this$putLogAppVersion_u24lambda_u244_u24lambda_u243 = new JsonBuilderContext(objNode$iv, this_$iv.get__factory(), this_$iv.get__mapper());
            boolean bl2 = false;
            $this$putLogAppVersion_u24lambda_u244_u24lambda_u243.put("version", build.getVersion());
            $this$putLogAppVersion_u24lambda_u244_u24lambda_u243.put("date", build.getDate());
            $this$putLogAppVersion_u24lambda_u244_u24lambda_u243.put("commit", build.getCommit());
            $this$putLogAppVersion_u24lambda_u244_u24lambda_u243.put("branch", build.getBranch());
            this_$iv.get__node().set($this$put$iv, (JsonNode)objNode$iv);
        }
    }

    @Nullable
    public static final String getAppVersion() {
        LogAppVersion logAppVersion = JsonLogEventsLayoutKt.getLogAppVersion();
        return logAppVersion != null ? logAppVersion.getVersion() : null;
    }

    @NotNull
    public static final Map<String, String> getTracingVersionMap() {
        Object object;
        block3: {
            block2: {
                object = JsonLogEventsLayoutKt.getLogAppVersion();
                if (object == null) break block2;
                LogAppVersion build = object;
                boolean bl = false;
                Pair[] pairArray = new Pair[6];
                Long l = build.getBuild();
                pairArray[0] = TuplesKt.to((Object)"buildNumber", (Object)String.valueOf(l != null ? l : 0L));
                pairArray[1] = TuplesKt.to((Object)"hostname", (Object)HostKt.getApplication_host());
                pairArray[2] = TuplesKt.to((Object)"stack_name", (Object)HostKt.getApplication_stack_name());
                pairArray[3] = TuplesKt.to((Object)"version", (Object)build.getVersion());
                pairArray[4] = TuplesKt.to((Object)"branch", (Object)build.getBranch());
                pairArray[5] = TuplesKt.to((Object)"deployment_version", (Object)HostKt.getApplication_version());
                Map map2 = MapsKt.mutableMapOf((Pair[])pairArray);
                object = map2;
                if (map2 != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @NotNull
    public static final String dateFormat(long timestamp) {
        String string = ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.print(timestamp);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        return string;
    }

    private static final ErrorInfo getError(IThrowableProxy $this$error) {
        String string = $this$error.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        return new ErrorInfo(string, $this$error.getMessage());
    }

    private static final Sequence<IThrowableProxy> getAllCauses(IThrowableProxy $this$allCauses) {
        return SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)$this$allCauses, JsonLogEventsLayoutKt::_get_allCauses_$lambda$6), (int)15);
    }

    private static final Sequence<ErrorInfo> getSuperErrors(ThrowableProxy $this$superErrors) {
        return SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence($this$superErrors.getThrowable().getClass().getSuperclass(), JsonLogEventsLayoutKt::_get_superErrors_$lambda$7), (int)15), arg_0 -> JsonLogEventsLayoutKt._get_superErrors_$lambda$8($this$superErrors, arg_0));
    }

    private static final <T> T split(String $this$split, int minParts, int maxParts, char delimiter, Function1<? super List<String>, ? extends T> factory2) {
        boolean $i$f$split = false;
        Object object = new char[]{delimiter};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)$this$split, (char[])object, (boolean)false, (int)(maxParts + 1), (int)2, null);
        boolean bl = false;
        int n = it.size();
        Object object2 = (minParts <= n ? n <= maxParts : false) ? object : null;
        if (object2 == null) {
            return null;
        }
        Object parts = object2;
        return (T)factory2.invoke(parts);
    }

    static /* synthetic */ Object split$default(String $this$split_u24default, int minParts, int maxParts, char delimiter, Function1 factory2, int n, Object object) {
        if ((n & 2) != 0) {
            maxParts = minParts;
        }
        if ((n & 4) != 0) {
            delimiter = (char)46;
        }
        boolean $i$f$split = false;
        Object object2 = new char[]{delimiter};
        char[] it = object2 = (Object)StringsKt.split$default((CharSequence)$this$split_u24default, (char[])object2, (boolean)false, (int)(maxParts + 1), (int)2, null);
        boolean bl = false;
        int n2 = it.size();
        Object object3 = (minParts <= n2 ? n2 <= maxParts : false) ? object2 : null;
        if (object3 == null) {
            return null;
        }
        Object parts = object3;
        return factory2.invoke(parts);
    }

    private static final String computedHostName_delegate$lambda$0() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            string = "unknown-host";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final LogAppVersion logAppVersion_delegate$lambda$2() {
        File versionFile = new File(new File(System.getProperty("user.dir")), "version.txt");
        if (versionFile.exists()) {
            List content2 = FilesKt.readLines$default((File)versionFile, null, (int)1, null);
            try {
                Long l;
                void $this$split_u24default$iv;
                int minParts$iv;
                String string = ((String)content2.get(0)).substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String version = string;
                String string2 = ((Object)StringsKt.trim((CharSequence)version)).toString();
                int maxParts$iv = minParts$iv = 4;
                char delimiter$iv = '.';
                boolean $i$f$split = false;
                Object object = new char[]{delimiter$iv};
                char[] it$iv = object = (Object)StringsKt.split$default((CharSequence)((CharSequence)$this$split_u24default$iv), (char[])object, (boolean)false, (int)(maxParts$iv + 1), (int)2, null);
                boolean bl = false;
                int n = it$iv.size();
                Object object2 = (minParts$iv <= n ? n <= maxParts$iv : false) ? object : null;
                if (object2 == null) {
                    l = null;
                } else {
                    Object parts$iv;
                    Object parts = parts$iv = object2;
                    boolean bl2 = false;
                    l = StringsKt.toLongOrNull((String)((String)parts.get(3)));
                }
                Long build = l;
                String string3 = ((String)content2.get(1)).substring(9);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String date2 = string3;
                String string4 = ((String)content2.get(2)).substring(13);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String commit = string4;
                String string5 = ((String)content2.get(3)).substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String branch = string5;
                return new LogAppVersion(version, build, date2, commit, branch);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final IThrowableProxy _get_allCauses_$lambda$6(IThrowableProxy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCause();
    }

    private static final Class _get_superErrors_$lambda$7(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuperclass();
    }

    private static final ErrorInfo _get_superErrors_$lambda$8(ThrowableProxy $this_superErrors, Class it) {
        Intrinsics.checkNotNullParameter((Object)$this_superErrors, (String)"$this_superErrors");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new ErrorInfo(string, $this_superErrors.getMessage());
    }

    public static final /* synthetic */ Sequence access$getAllCauses(IThrowableProxy $receiver) {
        return JsonLogEventsLayoutKt.getAllCauses($receiver);
    }

    public static final /* synthetic */ String access$getComputedHostName() {
        return JsonLogEventsLayoutKt.getComputedHostName();
    }

    public static final /* synthetic */ ErrorInfo access$getError(IThrowableProxy $receiver) {
        return JsonLogEventsLayoutKt.getError($receiver);
    }

    public static final /* synthetic */ Sequence access$getSuperErrors(ThrowableProxy $receiver) {
        return JsonLogEventsLayoutKt.getSuperErrors($receiver);
    }
}

