/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.DebugKt;
import libraries.basics.DevEnv;
import libraries.coroutines.extra.Lifetime;
import libraries.klogging.KLogger;
import libraries.klogging.RichLogRecord;
import libraries.klogging.RichLogRecordKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.CallStack;
import runtime.DevEnvCommonKt;
import runtime.DevEnvKt;
import runtime.reactive.CellTracker;
import runtime.reactive.CellTrackerKt;
import runtime.reactive.DevCellTrackerChecks;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.reactive.XTrackable;
import runtime.reactive.XUnTrackable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J\u001d\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\u0010\n\u001a\n\u0012\u0002\b\u00030\fj\u0002`\u000b\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\u0010\u0017JA\u0010\u0018\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u001e\b\u0002\u0010\u0019\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u00030\fj\u0002`\u000b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ?\u0010\u001c\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u001e\b\u0002\u0010\u0019\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u00030\fj\u0002`\u000b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001a\u00a2\u0006\u0002\u0010\u001bJE\u0010\u001d\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\u00020\u001e2\u001e\b\u0002\u0010\u0019\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u00030\fj\u0002`\u000b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001aH\u0002\u00a2\u0006\u0002\u0010\u001fJO\u0010 \u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010!\u001a\u00020\"2\u001a\u0010#\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u00030\fj\u0002`\u000b\u0012\u0004\u0012\u00020\t0\u00142\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001a\u00a2\u0006\u0002\u0010&R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010'\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lruntime/reactive/CellTracker;", "", "<init>", "()V", "stack", "", "Lruntime/reactive/CellTracker$CacheBucket;", "currentBucket", "trackAccess", "", "trackable", "Lruntime/reactive/CellTrackerDependency;", "Lruntime/reactive/Property;", "(Lruntime/reactive/Property;)Lkotlin/Unit;", "untrack", "Lruntime/reactive/XUnTrackable;", "getUntrack", "()Lruntime/reactive/XUnTrackable;", "T", "action", "Lkotlin/Function1;", "Lruntime/reactive/XTrackable;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "frameAccessImpl", "onDependency", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "frameAccess", "devFrameAccess", "Llibraries/basics/DevEnv;", "(Llibraries/basics/DevEnv;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "frameUpdates", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "onChange", "dbgName", "", "(Llibraries/coroutines/extra/Lifetime;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onCreateMutable", "Lruntime/reactive/MutableProperty;", "CacheBucket", "platform-ui"})
@SourceDebugExtension(value={"SMAP\nCellTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CellTracker.kt\nruntime/reactive/CellTracker\n+ 2 DevCellTrackerChecks.kt\nruntime/reactive/DevCellTrackerChecks\n+ 3 DevEnvCommon.kt\nruntime/DevEnvCommonKt\n+ 4 KLogger.kt\nlibraries/klogging/KLogger\n+ 5 RichLogRecord.kt\nlibraries/klogging/RichLogRecordKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 DebugCommon.kt\nlibraries/basics/DebugCommonKt\n*L\n1#1,193:1\n5#2:194\n24#3,4:195\n28#3,3:204\n28#4,5:199\n28#4,5:208\n168#5:207\n169#5:213\n1#6:214\n29#7,3:215\n*S KotlinDebug\n*F\n+ 1 CellTracker.kt\nruntime/reactive/CellTracker\n*L\n36#1:194\n41#1:195,4\n41#1:204,3\n43#1:199,5\n109#1:208,5\n109#1:207\n109#1:213\n145#1:215,3\n*E\n"})
public final class CellTracker {
    @NotNull
    public static final CellTracker INSTANCE;
    @NotNull
    private static final List<CacheBucket> stack;
    @NotNull
    private static final XUnTrackable untrack;
    @Nullable
    private static Function1<? super MutableProperty<?>, Unit> onCreateMutable;

    private CellTracker() {
    }

    private final CacheBucket currentBucket() {
        return (CacheBucket)CollectionsKt.lastOrNull(stack);
    }

    @Nullable
    public final Unit trackAccess(@NotNull Property<?> trackable) {
        Unit unit;
        Intrinsics.checkNotNullParameter(trackable, (String)"trackable");
        DevCellTrackerChecks this_$iv = DevCellTrackerChecks.INSTANCE;
        boolean $i$f$suspendRenderInProcessChecks = false;
        boolean bl = false;
        CacheBucket bucket = CellTracker.INSTANCE.currentBucket();
        if (bucket != null && !bucket.isPaused()) {
            Function1<Property<?>, Unit> function1 = bucket.getOnDependency();
            if (function1 != null) {
                function1.invoke(trackable);
            }
        }
        String devFeatureKey$iv = "LIVE_OUTSIDE_TRACKABLE_CHECKS";
        boolean $i$f$ifDevFeatureEnabled = false;
        if (DebugKt.getIS_DEV_ENV()) {
            DevEnv $this$ifDevFeatureEnabled_u24lambda_u240$iv = DevEnv.INSTANCE;
            boolean bl2 = false;
            if (DevEnvKt.isDevFeatureKeyEnabled(devFeatureKey$iv)) {
                DevEnv $this$trackAccess_u24lambda_u242_u24lambda_u241 = $this$ifDevFeatureEnabled_u24lambda_u240$iv;
                boolean bl3 = false;
                if (bucket == null) {
                    KLogger this_$iv2 = CellTrackerKt.access$getLog$p();
                    boolean $i$f$warn = false;
                    if (this_$iv2.isWarnEnabled()) {
                        boolean bl4 = false;
                        String msgStr$iv = "Live access (like `someProperty.live`) should only be called in trackable context (like `cell` or `render`)";
                        this_$iv2.warn(msgStr$iv);
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        return unit;
    }

    @NotNull
    public final XUnTrackable getUntrack() {
        return untrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T untrack(@NotNull Function1<? super XTrackable, ? extends T> action2) {
        Object object;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        CacheBucket bucket = this.currentBucket();
        if (bucket != null) {
            int n = bucket.getPauseCounter();
            bucket.setPauseCounter(n + 1);
        }
        try {
            object = action2.invoke((Object)untrack);
        }
        finally {
            if (bucket != null) {
                int n = bucket.getPauseCounter();
                bucket.setPauseCounter(n + -1);
            }
        }
        Object res = object;
        return (T)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T frameAccessImpl(Function1<? super Property<?>, Unit> onDependency, Function0<? extends T> action2) {
        CacheBucket bucket = new CacheBucket(onDependency, 0, 2, null);
        try {
            stack.add(bucket);
            Object object = action2.invoke();
            return (T)object;
        }
        finally {
            CacheBucket removed = stack.remove(CollectionsKt.getLastIndex(stack));
            if (bucket.getId() != removed.getId()) {
                throw new IllegalStateException("Stack corrupted".toString());
            }
        }
    }

    static /* synthetic */ Object frameAccessImpl$default(CellTracker cellTracker, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return cellTracker.frameAccessImpl(function1, function0);
    }

    public final <T> T frameAccess(@Nullable Function1<? super Property<?>, Unit> onDependency, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return this.frameAccessImpl(onDependency, action2);
    }

    public static /* synthetic */ Object frameAccess$default(CellTracker cellTracker, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return cellTracker.frameAccess(function1, function0);
    }

    private final <T> T devFrameAccess(DevEnv $this$devFrameAccess, Function1<? super Property<?>, Unit> onDependency, Function0<? extends T> action2) {
        Map createdMutableState = new LinkedHashMap();
        Function1<? super MutableProperty<?>, Unit> prevOnCreateMutable = onCreateMutable;
        onCreateMutable = arg_0 -> CellTracker.devFrameAccess$lambda$3($this$devFrameAccess, createdMutableState, arg_0);
        Function1 devOnDependency = arg_0 -> CellTracker.devFrameAccess$lambda$7(createdMutableState, onDependency, arg_0);
        T result2 = this.frameAccessImpl(devOnDependency, action2);
        onCreateMutable = prevOnCreateMutable;
        return result2;
    }

    static /* synthetic */ Object devFrameAccess$default(CellTracker cellTracker, DevEnv devEnv2, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return cellTracker.devFrameAccess(devEnv2, function1, function0);
    }

    public final <T> T frameUpdates(@NotNull Lifetime lifetime, @NotNull Function1<? super Property<?>, Unit> onChange2, @Nullable String dbgName, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onChange2, (String)"onChange");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Function1 onDependency = arg_0 -> CellTracker.frameUpdates$lambda$10(dbgName, lifetime, onChange2, arg_0);
        return this.frameAccess(onDependency, action2);
    }

    public static /* synthetic */ Object frameUpdates$default(CellTracker cellTracker, Lifetime lifetime, Function1 function1, String string, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return cellTracker.frameUpdates(lifetime, function1, string, function0);
    }

    private static final Unit devFrameAccess$lambda$3(DevEnv $this_devFrameAccess, Map $createdMutableState, MutableProperty it) {
        Intrinsics.checkNotNullParameter((Object)$this_devFrameAccess, (String)"$this_devFrameAccess");
        Intrinsics.checkNotNullParameter((Object)$createdMutableState, (String)"$createdMutableState");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!DevEnvCommonKt.isInLazyBlock($this_devFrameAccess) && !DevCellTrackerChecks.INSTANCE.getIgnoreRenderInProgressChecks()) {
            $createdMutableState.put(it, new CallStack("Create mutable property", null, 2, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit devFrameAccess$lambda$7$lambda$6$lambda$4(CallStack $creationStack, RichLogRecord $this$richLog) {
        Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
        $this$richLog.unaryPlus($creationStack);
        return Unit.INSTANCE;
    }

    private static final Unit devFrameAccess$lambda$7$lambda$6$lambda$5(CallStack $accessStack, RichLogRecord $this$richLog) {
        Intrinsics.checkNotNullParameter((Object)$accessStack, (String)"$accessStack");
        Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
        $this$richLog.unaryPlus($accessStack);
        return Unit.INSTANCE;
    }

    private static final Unit devFrameAccess$lambda$7$lambda$6(CallStack $creationStack, CallStack $accessStack, RichLogRecord $this$richWarn) {
        Intrinsics.checkNotNullParameter((Object)$accessStack, (String)"$accessStack");
        Intrinsics.checkNotNullParameter((Object)$this$richWarn, (String)"$this$richWarn");
        $this$richWarn.unaryPlus("It's highly likely that you are subscribing to a state which is created in the same reactive context, which could cause an incorrect reactivity behaviour");
        $this$richWarn.unaryPlus(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)arg_0 -> CellTracker.devFrameAccess$lambda$7$lambda$6$lambda$4($creationStack, arg_0))));
        $this$richWarn.unaryPlus(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)arg_0 -> CellTracker.devFrameAccess$lambda$7$lambda$6$lambda$5($accessStack, arg_0))));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit devFrameAccess$lambda$7(Map $createdMutableState, Function1 $onDependency, Property it) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$createdMutableState, (String)"$createdMutableState");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CallStack creationStack = (CallStack)$createdMutableState.get(it);
            if (creationStack != null) {
                void $this$richWarn$iv;
                CallStack accessStack = new CallStack("Access mutable property", null, 2, null);
                KLogger kLogger = CellTrackerKt.access$getLog$p();
                Function1 msg$iv = arg_0 -> CellTracker.devFrameAccess$lambda$7$lambda$6(creationStack, accessStack, arg_0);
                boolean $i$f$richWarn = false;
                void this_$iv$iv = $this$richWarn$iv;
                boolean $i$f$warn = false;
                if (this_$iv$iv.isWarnEnabled()) {
                    boolean bl = false;
                    RichLogRecord msgStr$iv$iv = RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)msg$iv);
                    this_$iv$iv.warn(msgStr$iv$iv);
                }
            }
            Function1 function1 = $onDependency;
            if (function1 == null) break block2;
            function1.invoke((Object)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit frameUpdates$lambda$10$lambda$8(Function1 $onChange, Property $dep, Object object) {
        Intrinsics.checkNotNullParameter((Object)$onChange, (String)"$onChange");
        Intrinsics.checkNotNullParameter((Object)$dep, (String)"$dep");
        $onChange.invoke((Object)$dep);
        return Unit.INSTANCE;
    }

    private static final Unit frameUpdates$lambda$10(String $dbgName, Lifetime $lifetime, Function1 $onChange, Property dep) {
        String string;
        Function1 sink;
        Intrinsics.checkNotNullParameter((Object)$lifetime, (String)"$lifetime");
        Intrinsics.checkNotNullParameter((Object)$onChange, (String)"$onChange");
        Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
        Function1 function1 = sink = arg_0 -> CellTracker.frameUpdates$lambda$10$lambda$8($onChange, dep, arg_0);
        String string2 = $dbgName;
        if (string2 != null) {
            String string3 = string2;
            Function1 function12 = function1;
            boolean bl = false;
            string = $dbgName + ":onDependency";
            function1 = function12;
        } else {
            string = null;
        }
        DebugKt.assignDbgName(function1, string);
        dep.getChanges().forEach($lifetime, sink);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function1 access$getOnCreateMutable$p() {
        return onCreateMutable;
    }

    static {
        block0: {
            INSTANCE = new CellTracker();
            stack = new ArrayList();
            untrack = new XUnTrackable();
            boolean $i$f$ifDevEnv = false;
            if (!DebugKt.getIS_DEV_ENV()) break block0;
            DevEnv $this$_init__u24lambda_u2411 = DevEnv.INSTANCE;
            boolean bl = false;
            PropertyKt.onCreateMutableProperty($this$_init__u24lambda_u2411, Lifetime.Companion.getEternal(), 1.1.INSTANCE);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B/\u0012\u001c\u0010\u0002\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u00030\u0005j\u0002`\u0004\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR'\u0010\u0002\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u00030\u0005j\u0002`\u0004\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lruntime/reactive/CellTracker$CacheBucket;", "", "onDependency", "Lkotlin/Function1;", "Lruntime/reactive/CellTrackerDependency;", "Lruntime/reactive/Property;", "", "pauseCounter", "", "<init>", "(Lkotlin/jvm/functions/Function1;I)V", "getOnDependency", "()Lkotlin/jvm/functions/Function1;", "getPauseCounter", "()I", "setPauseCounter", "(I)V", "id", "getId", "isPaused", "", "()Z", "Companion", "platform-ui"})
    public static final class CacheBucket {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Function1<Property<?>, Unit> onDependency;
        private int pauseCounter;
        private final int id;
        private static int num;

        public CacheBucket(@Nullable Function1<? super Property<?>, Unit> onDependency, int pauseCounter) {
            this.onDependency = onDependency;
            this.pauseCounter = pauseCounter;
            int n = num;
            num = n + 1;
            this.id = n;
        }

        public /* synthetic */ CacheBucket(Function1 function1, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(function1, n);
        }

        @Nullable
        public final Function1<Property<?>, Unit> getOnDependency() {
            return this.onDependency;
        }

        public final int getPauseCounter() {
            return this.pauseCounter;
        }

        public final void setPauseCounter(int n) {
            this.pauseCounter = n;
        }

        public final int getId() {
            return this.id;
        }

        public final boolean isPaused() {
            return this.pauseCounter > 0;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lruntime/reactive/CellTracker$CacheBucket$Companion;", "", "<init>", "()V", "num", "", "getNum", "()I", "setNum", "(I)V", "platform-ui"})
        public static final class Companion {
            private Companion() {
            }

            public final int getNum() {
                return num;
            }

            public final void setNum(int n) {
                num = n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

