/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcirclet/client/api/Currency;", "", "code", "", "sign", "signAsPrefix", "", "hasCents", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "getCode", "()Ljava/lang/String;", "getSign", "getSignAsPrefix", "()Z", "getHasCents", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "spaceport-client-api"})
public final class Currency {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String code;
    @Nullable
    private final String sign;
    private final boolean signAsPrefix;
    private final boolean hasCents;
    @NotNull
    private static final Currency USD = new Currency("USD", "$", true, false, 8, null);
    @NotNull
    private static final Currency EUR = new Currency("EUR", "\u20ac", true, false, 8, null);
    @NotNull
    private static final Currency GBP = new Currency("GBP", "\u00a3", true, false, 8, null);
    @NotNull
    private static final Currency CZK = new Currency("CZK", "K\u010d", false, false, 8, null);
    @NotNull
    private static final Currency JPY = new Currency("JPY", "\u00a5", true, false);
    @NotNull
    private static final List<Currency> knownCurrencies;

    public Currency(@NotNull String code, @Nullable String sign, boolean signAsPrefix, boolean hasCents) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = code;
        this.sign = sign;
        this.signAsPrefix = signAsPrefix;
        this.hasCents = hasCents;
    }

    public /* synthetic */ Currency(String string, String string2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this(string, string2, bl, bl2);
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @Nullable
    public final String getSign() {
        return this.sign;
    }

    public final boolean getSignAsPrefix() {
        return this.signAsPrefix;
    }

    public final boolean getHasCents() {
        return this.hasCents;
    }

    @NotNull
    public final String component1() {
        return this.code;
    }

    @Nullable
    public final String component2() {
        return this.sign;
    }

    public final boolean component3() {
        return this.signAsPrefix;
    }

    public final boolean component4() {
        return this.hasCents;
    }

    @NotNull
    public final Currency copy(@NotNull String code, @Nullable String sign, boolean signAsPrefix, boolean hasCents) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return new Currency(code, sign, signAsPrefix, hasCents);
    }

    public static /* synthetic */ Currency copy$default(Currency currency, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            string = currency.code;
        }
        if ((n & 2) != 0) {
            string2 = currency.sign;
        }
        if ((n & 4) != 0) {
            bl = currency.signAsPrefix;
        }
        if ((n & 8) != 0) {
            bl2 = currency.hasCents;
        }
        return currency.copy(string, string2, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "Currency(code=" + this.code + ", sign=" + this.sign + ", signAsPrefix=" + this.signAsPrefix + ", hasCents=" + this.hasCents + ")";
    }

    public int hashCode() {
        int result2 = this.code.hashCode();
        result2 = result2 * 31 + (this.sign == null ? 0 : this.sign.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.signAsPrefix);
        result2 = result2 * 31 + Boolean.hashCode(this.hasCents);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Currency)) {
            return false;
        }
        Currency currency = (Currency)other;
        if (!Intrinsics.areEqual((Object)this.code, (Object)currency.code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sign, (Object)currency.sign)) {
            return false;
        }
        if (this.signAsPrefix != currency.signAsPrefix) {
            return false;
        }
        return this.hasCents == currency.hasCents;
    }

    static {
        Object[] objectArray = new Currency[]{USD, EUR, GBP, CZK, JPY};
        knownCurrencies = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcirclet/client/api/Currency$Companion;", "", "<init>", "()V", "USD", "Lcirclet/client/api/Currency;", "getUSD", "()Lcirclet/client/api/Currency;", "EUR", "getEUR", "GBP", "getGBP", "CZK", "getCZK", "JPY", "getJPY", "knownCurrencies", "", "getKnownCurrencies", "()Ljava/util/List;", "resolveCurrency", "code", "", "spaceport-client-api"})
    @SourceDebugExtension(value={"SMAP\nBillingAdmin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BillingAdmin.kt\ncirclet/client/api/Currency$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,706:1\n295#2,2:707\n*S KotlinDebug\n*F\n+ 1 BillingAdmin.kt\ncirclet/client/api/Currency$Companion\n*L\n372#1:707,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Currency getUSD() {
            return USD;
        }

        @NotNull
        public final Currency getEUR() {
            return EUR;
        }

        @NotNull
        public final Currency getGBP() {
            return GBP;
        }

        @NotNull
        public final Currency getCZK() {
            return CZK;
        }

        @NotNull
        public final Currency getJPY() {
            return JPY;
        }

        @NotNull
        public final List<Currency> getKnownCurrencies() {
            return knownCurrencies;
        }

        @NotNull
        public final Currency resolveCurrency(@NotNull String code) {
            Currency currency;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                Iterable $this$firstOrNull$iv = this.getKnownCurrencies();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Currency it = (Currency)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getCode(), (String)code, (boolean)true)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((currency = (Currency)v0) == null) {
                String string = code.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                currency = new Currency(string, null, false, false, 8, null);
            }
            return currency;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

