/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class OffsetTimeSerializer
extends JSR310FormattedSerializerBase<OffsetTime> {
    private static final long serialVersionUID = 1L;
    public static final OffsetTimeSerializer INSTANCE = new OffsetTimeSerializer();

    protected OffsetTimeSerializer() {
        super(OffsetTime.class);
    }

    protected OffsetTimeSerializer(OffsetTimeSerializer base, Boolean useTimestamp, DateTimeFormatter dtf) {
        this(base, useTimestamp, null, dtf);
    }

    protected OffsetTimeSerializer(OffsetTimeSerializer base, Boolean useTimestamp, Boolean useNanoseconds, DateTimeFormatter dtf) {
        super(base, useTimestamp, useNanoseconds, dtf, null);
    }

    protected OffsetTimeSerializer withFormat(Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        return new OffsetTimeSerializer(this, useTimestamp, dtf);
    }

    public void serialize(OffsetTime time, JsonGenerator g, SerializerProvider provider2) throws IOException {
        if (this.useTimestamp(provider2)) {
            g.writeStartArray();
            this._serializeAsArrayContents(time, g, provider2);
            g.writeEndArray();
        } else {
            String str = this._formatter == null ? time.toString() : time.format(this._formatter);
            g.writeString(str);
        }
    }

    @Override
    public void serializeWithType(OffsetTime value2, JsonGenerator g, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value2, this.serializationShape(provider2)));
        if (typeIdDef != null && typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value2, g, provider2);
        } else {
            String str = this._formatter == null ? value2.toString() : value2.format(this._formatter);
            g.writeString(str);
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    private final void _serializeAsArrayContents(OffsetTime value2, JsonGenerator g, SerializerProvider provider2) throws IOException {
        g.writeNumber(value2.getHour());
        g.writeNumber(value2.getMinute());
        int secs = value2.getSecond();
        int nanos = value2.getNano();
        if (secs > 0 || nanos > 0) {
            g.writeNumber(secs);
            if (nanos > 0) {
                if (this.useNanoseconds(provider2)) {
                    g.writeNumber(nanos);
                } else {
                    g.writeNumber(value2.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
        g.writeString(value2.getOffset().toString());
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider2) {
        return this.useTimestamp(provider2) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new OffsetTimeSerializer(this, this._useTimestamp, writeNanoseconds, this._formatter);
    }
}

