/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.gateway.spaceport.auth;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.spaceport.gateway.messages.SpaceportGatewayBundle;
import com.intellij.ui.AppUIUtilKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0003\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0003\u00a8\u0006\b"}, d2={"createAuthPage", "", "server", "isSuccess", "", "loadAuthResourceFileContent", "fileName", "loadProductSvg", "intellij.spaceport.gateway"})
@SourceDebugExtension(value={"SMAP\nauthPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 authPage.kt\ncom/intellij/spaceport/gateway/spaceport/auth/AuthPageKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n52#2:69\n1#3:70\n*S KotlinDebug\n*F\n+ 1 authPage.kt\ncom/intellij/spaceport/gateway/spaceport/auth/AuthPageKt\n*L\n40#1:69\n*E\n"})
public final class AuthPageKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String createAuthPage(@NotNull String server, boolean isSuccess) {
        HtmlChunk.Element element;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        HtmlChunk.Element element2 = HtmlChunk.html().child((HtmlChunk)HtmlChunk.head().child((HtmlChunk)HtmlChunk.styleTag((String)AuthPageKt.loadAuthResourceFileContent("spaceAuthPage.css"))));
        HtmlChunk.Element element3 = HtmlChunk.body();
        HtmlChunk.Element element4 = HtmlChunk.div().attr("class", "central-div").child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header").child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header-icon").addRaw(AuthPageKt.loadAuthResourceFileContent("spaceportAuthIcon.svg"))).child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header-text").addText(SpaceportGatewayBundle.INSTANCE.message("auth.page.jetbrains.space.header.text", new Object[0]))));
        HtmlChunk.Element element5 = HtmlChunk.div().attr("class", "central-div-content");
        HtmlChunk.Element element6 = HtmlChunk.div().attr("class", "central-div-content-icon");
        String string = AuthPageKt.loadProductSvg();
        if (string == null) {
            string = "";
        }
        HtmlChunk.Element element7 = element4.child((HtmlChunk)element5.child((HtmlChunk)element6.addRaw(string)).child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-content-text").addText(isSuccess ? SpaceportGatewayBundle.INSTANCE.message("auth.page.content.text.success", new Object[0]) : SpaceportGatewayBundle.INSTANCE.message("auth.page.content.text.failed", new Object[0]))));
        boolean condition$iv = !StringsKt.isBlank((CharSequence)server);
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$createAuthPage_u24lambda_u240;
            void $this$applyIf$iv;
            void var5_5 = $this$applyIf$iv;
            HtmlChunk.Element element8 = element3;
            HtmlChunk.Element element9 = element2;
            boolean bl = false;
            HtmlChunk.Element element10 = $this$createAuthPage_u24lambda_u240.child((HtmlChunk)HtmlChunk.link((String)server, (String)SpaceportGatewayBundle.INSTANCE.message("auth.page.go.to.space.link", new Object[0])).attr("class", "central-div-content-link"));
            element2 = element9;
            element3 = element8;
            element = element10;
        } else {
            element = element7;
        }
        String string2 = element2.child((HtmlChunk)element3.child((HtmlChunk)element)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NlsSafe
    private static final String loadAuthResourceFileContent(String fileName) {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"com.jetbrains.spaceport"));
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException("Couldn't find CodeCanvas plugin descriptor");
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        InputStream inputStream = plugin.getClassLoader().getResourceAsStream("auth/" + fileName);
        Intrinsics.checkNotNull((Object)inputStream);
        Reader reader = new InputStreamReader(inputStream, Charsets.UTF_8);
        int n = 8192;
        return TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
    }

    @NlsSafe
    private static final String loadProductSvg() {
        String string;
        String it = string = AppUIUtilKt.findAppIcon();
        boolean bl = false;
        String string2 = it;
        String string3 = (string2 != null ? StringsKt.endsWith$default((String)string2, (String)".svg", (boolean)false, (int)2, null) : false) ? string : null;
        if (string3 != null) {
            String iconPath = string3;
            boolean bl2 = false;
            File iconFile = new File(iconPath);
            if (iconFile.exists() && iconFile.isFile()) {
                return FilesKt.readText((File)iconFile, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }
}

