/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import java.io.Closeable;
import java.io.InputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.Base64Kt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000%\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0016\u0010\b\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\u0000\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u000b\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\u00a8\u0006\u000e"}, d2={"sha256", "runtime/Base64Kt$sha256$1", "Lruntime/Base64Kt$sha256$1;", "buildSha256Digest", "", "bytes", "longHashCode", "", "resourceBytes", "Ljava/lang/Class;", "resourcePath", "", "resourceText", "sha256Hex", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nBase64.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base64.kt\nruntime/Base64Kt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class Base64Kt {
    @NotNull
    private static final sha256.1 sha256 = new ThreadLocal<MessageDigest>(){

        protected MessageDigest initialValue() {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
            return messageDigest;
        }
    };

    @NotNull
    public static final byte[] buildSha256Digest(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        MessageDigest digest = (MessageDigest)sha256.get();
        digest.reset();
        digest.update(bytes);
        byte[] result2 = digest.digest();
        digest.reset();
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    public static final long longHashCode(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        long acc = 0L;
        for (byte b : bytes) {
            acc = acc * (long)31 + (long)b;
        }
        return acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] resourceBytes(@NotNull Class<?> $this$resourceBytes, @NotNull String resourcePath) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$resourceBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Closeable closeable = $this$resourceBytes.getClassLoader().getResourceAsStream(resourcePath);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @NotNull
    public static final String resourceText(@NotNull Class<?> $this$resourceText, @NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter($this$resourceText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        return new String(Base64Kt.resourceBytes($this$resourceText, resourcePath), Charsets.UTF_8);
    }

    @NotNull
    public static final byte[] sha256(@NotNull byte[] $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        return Base64Kt.buildSha256Digest($this$sha256);
    }

    @NotNull
    public static final String sha256Hex(@NotNull String $this$sha256Hex) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256Hex, (String)"<this>");
        String string = $this$sha256Hex;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return ArraysKt.joinToString$default((byte[])Base64Kt.sha256(byArray), (CharSequence)"", null, null, (int)0, null, Base64Kt::sha256Hex$lambda$1, (int)30, null);
    }

    private static final CharSequence sha256Hex$lambda$1(byte it) {
        String string = Integer.toString((it + 256) % 256, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.padStart((String)string, (int)2, (char)'0');
    }
}

