/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.LifetimedValue;
import runtime.reactive.Maybe;
import runtime.reactive.SequentialLifetimes;
import runtime.reactive.Source;
import runtime.reactive.ValueSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003j\b\u0012\u0004\u0012\u0002H\u0001`\u0002B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J)\u0010\u0011\u001a\u00020\u00062!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00028\u00000\u0015J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001aJ*\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00062\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u00020\u001a0\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lruntime/reactive/LifetimedValueSource;", "T", "Lruntime/reactive/LifetimedValueView;", "Lruntime/reactive/Source;", "Lruntime/reactive/LifetimedValue;", "sourceLifetime", "Llibraries/coroutines/extra/Lifetime;", "<init>", "(Llibraries/coroutines/extra/Lifetime;)V", "valueSource", "Lruntime/reactive/ValueSource;", "lifetimes", "Lruntime/reactive/SequentialLifetimes;", "maybeLifetimedValue", "Lruntime/reactive/Maybe;", "getMaybeLifetimedValue", "()Lruntime/reactive/Maybe;", "setValue", "value", "(Ljava/lang/Object;)Llibraries/coroutines/extra/Lifetime;", "builder", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "lifetime", "applyValue", "", "(Ljava/lang/Object;Llibraries/coroutines/extra/Lifetime;)V", "clearValue", "forEach", "sink", "platform-runtime"})
public final class LifetimedValueSource<T>
implements Source<LifetimedValue<? extends T>> {
    @NotNull
    private final Lifetime sourceLifetime;
    @NotNull
    private final ValueSource<LifetimedValue<T>> valueSource;
    @NotNull
    private final SequentialLifetimes lifetimes;

    public LifetimedValueSource(@NotNull Lifetime sourceLifetime) {
        Intrinsics.checkNotNullParameter((Object)sourceLifetime, (String)"sourceLifetime");
        this.sourceLifetime = sourceLifetime;
        this.valueSource = new ValueSource();
        this.lifetimes = new SequentialLifetimes(this.sourceLifetime);
    }

    @NotNull
    public final Maybe<LifetimedValue<T>> getMaybeLifetimedValue() {
        return this.valueSource.getMaybeValue();
    }

    @NotNull
    public final Lifetime setValue(T value2) {
        if (this.sourceLifetime.isTerminated()) {
            throw new IllegalStateException("Source lifetime terminated.".toString());
        }
        Lifetime valueLifetime = this.lifetimes.next();
        this.applyValue(value2, valueLifetime);
        return valueLifetime;
    }

    @NotNull
    public final Lifetime setValue(@NotNull Function1<? super Lifetime, ? extends T> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        if (this.sourceLifetime.isTerminated()) {
            throw new IllegalStateException("Source lifetime terminated.".toString());
        }
        Lifetime valueLifetime = this.lifetimes.next();
        Object value2 = builder.invoke((Object)valueLifetime);
        this.applyValue(value2, valueLifetime);
        return valueLifetime;
    }

    private final void applyValue(T value2, Lifetime lifetime) {
        lifetime.add((Function)((Function0)() -> LifetimedValueSource.applyValue$lambda$0(this)));
        this.valueSource.setValue(new LifetimedValue<T>(value2, lifetime));
    }

    public final void clearValue() {
        this.lifetimes.clear();
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super LifetimedValue<? extends T>, Unit> sink) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        if (lifetime.isTerminated()) {
            return;
        }
        this.valueSource.forEach(lifetime, sink);
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super LifetimedValue<? extends T>, ? super LifetimedValue<? extends T>, Unit> consume) {
        Source.DefaultImpls.forEachWithPrevious(this, lifetime, consume);
    }

    private static final Unit applyValue$lambda$0(LifetimedValueSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.valueSource.clearValue();
        return Unit.INSTANCE;
    }
}

