/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.classic;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.classic.ClassicTerminalVfsRefresherKt;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\f2\u000e\b\u0002\u0010\u0010\u001a\b\u0018\u00010\bR\u00020\u0000H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0018\u00010\bR\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/classic/ClassicTerminalVfsRefresher;", "", "widget", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "<init>", "(Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;)V", "currentWatcherRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/plugins/terminal/classic/ClassicTerminalVfsRefresher$CommandRunWatcher;", "isDisposed", "", "scheduleRefreshOnCommandFinished", "", "isPromptSame", "Lkotlin/Function0;", "stopWatcher", "watcher", "CommandRunWatcher", "intellij.terminal"})
public final class ClassicTerminalVfsRefresher {
    @NotNull
    private final ShellTerminalWidget widget;
    @NotNull
    private final AtomicReference<CommandRunWatcher> currentWatcherRef;
    private volatile boolean isDisposed;

    public ClassicTerminalVfsRefresher(@NotNull ShellTerminalWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.widget = widget;
        this.currentWatcherRef = new AtomicReference();
        Disposer.register((Disposable)((Disposable)this.widget), () -> ClassicTerminalVfsRefresher._init_$lambda$0(this));
    }

    @RequiresEdt(generateAssertion=false)
    public final void scheduleRefreshOnCommandFinished(@NotNull Function0<Boolean> isPromptSame) {
        Intrinsics.checkNotNullParameter(isPromptSame, (String)"isPromptSame");
        if (!this.isDisposed && Registry.Companion.is("terminal.classic.refresh.vfs.on.shell.command.finished")) {
            ClassicTerminalVfsRefresher.stopWatcher$default(this, null, 1, null);
            if (!this.widget.getTerminalTextBuffer().isUsingAlternateBuffer()) {
                this.currentWatcherRef.set(new CommandRunWatcher(isPromptSame));
            }
        }
    }

    private final void stopWatcher(CommandRunWatcher watcher) {
        if (watcher != null) {
            Disposer.dispose((Disposable)watcher);
            this.currentWatcherRef.compareAndSet(watcher, null);
        }
    }

    static /* synthetic */ void stopWatcher$default(ClassicTerminalVfsRefresher classicTerminalVfsRefresher, CommandRunWatcher commandRunWatcher, int n, Object object) {
        if ((n & 1) != 0) {
            commandRunWatcher = classicTerminalVfsRefresher.currentWatcherRef.get();
        }
        classicTerminalVfsRefresher.stopWatcher(commandRunWatcher);
    }

    private static final void _init_$lambda$0(ClassicTerminalVfsRefresher this$0) {
        this$0.isDisposed = true;
        ClassicTerminalVfsRefresher.stopWatcher$default(this$0, null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/classic/ClassicTerminalVfsRefresher$CommandRunWatcher;", "Lcom/intellij/openapi/Disposable;", "isPromptSame", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/plugins/terminal/classic/ClassicTerminalVfsRefresher;Lkotlin/jvm/functions/Function0;)V", "changes", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "job", "Lkotlinx/coroutines/Job;", "refreshVfsIfSamePromptIsShown", "dispose", "intellij.terminal"})
    private final class CommandRunWatcher
    implements Disposable {
        @NotNull
        private final Function0<Boolean> isPromptSame;
        @NotNull
        private final MutableSharedFlow<Unit> changes;
        @NotNull
        private final Job job;

        public CommandRunWatcher(Function0<Boolean> isPromptSame) {
            Intrinsics.checkNotNullParameter(isPromptSame, (String)"isPromptSame");
            this.isPromptSame = isPromptSame;
            this.changes = SharedFlowKt.MutableSharedFlow((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST);
            Project project = ClassicTerminalVfsRefresher.this.widget.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.job = BuildersKt.launch$default((CoroutineScope)TerminalCoroutineKt.terminalProjectScope(project), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ CommandRunWatcher this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.collectLatest((Flow)((Flow)CommandRunWatcher.access$getChanges$p(this.this$0)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ CommandRunWatcher this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = DelayKt.delay-VtjQ1oo((long)ClassicTerminalVfsRefresherKt.access$getVFS_REFRESH_DELAY_MS$p(), (Continuation)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            CommandRunWatcher.access$refreshVfsIfSamePromptIsShown(this.this$0);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            TerminalTextBuffer terminalTextBuffer = ClassicTerminalVfsRefresher.this.widget.getTerminalTextBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)terminalTextBuffer, (String)"getTerminalTextBuffer(...)");
            TerminalUtilKt.addModelListener(terminalTextBuffer, this, () -> CommandRunWatcher._init_$lambda$0(this));
            Disposer.register((Disposable)((Disposable)ClassicTerminalVfsRefresher.this.widget), (Disposable)this);
        }

        private final void refreshVfsIfSamePromptIsShown() {
            if (((Boolean)this.isPromptSame.invoke()).booleanValue()) {
                SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
                ClassicTerminalVfsRefresher.this.stopWatcher(this);
            }
        }

        public void dispose() {
            Job.DefaultImpls.cancel$default((Job)this.job, null, (int)1, null);
        }

        private static final void _init_$lambda$0(CommandRunWatcher this$0) {
            this$0.changes.tryEmit((Object)Unit.INSTANCE);
        }

        public static final /* synthetic */ MutableSharedFlow access$getChanges$p(CommandRunWatcher $this) {
            return $this.changes;
        }

        public static final /* synthetic */ void access$refreshVfsIfSamePromptIsShown(CommandRunWatcher $this) {
            $this.refreshVfsIfSamePromptIsShown();
        }
    }
}

