/*
 * Decompiled with CFR 0.152.
 */
package circlet.electron;

import circlet.electron.DownloadItemController;
import circlet.electron.DownloadItemInfo;
import circlet.electron.DownloadItemState;
import circlet.electron.DownloadItemVm;
import circlet.electron.DownloadVmKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.coroutines.extra.ILifetimeSource;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchExtKt;
import runtime.DispatchJvmKt;
import runtime.reactive.MutableProperty;
import runtime.reactive.PropertyKt;
import runtime.reactive.SequentialLifetimes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0013J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\rH\u0002J6\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\rJ \u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\rJ\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcirclet/electron/DesktopAppDownloadVM;", "", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "controller", "Lcirclet/electron/DownloadItemController;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/electron/DownloadItemController;)V", "getController", "()Lcirclet/electron/DownloadItemController;", "downloads", "Lruntime/reactive/MutableProperty;", "", "", "Lcirclet/electron/DownloadItemVm;", "addItem", "item", "Lcirclet/electron/DownloadItemInfo;", "onPathDefined", "Lkotlin/Function1;", "", "getItem", "itemId", "onItemUpdated", "id", "fileName", "path", "totalBytes", "", "receivedBytes", "state", "onItemDone", "errorMessage", "removeItem", "spaceport-app-state"})
@SourceDebugExtension(value={"SMAP\ndownloadVm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 downloadVm.kt\ncirclet/electron/DesktopAppDownloadVM\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1863#2,2:211\n*S KotlinDebug\n*F\n+ 1 downloadVm.kt\ncirclet/electron/DesktopAppDownloadVM\n*L\n201#1:211,2\n*E\n"})
public final class DesktopAppDownloadVM {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final DownloadItemController controller;
    @NotNull
    private final MutableProperty<Map<String, DownloadItemVm>> downloads;

    public DesktopAppDownloadVM(@NotNull Lifetime lifetime, @NotNull DownloadItemController controller) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.lifetime = lifetime;
        this.controller = controller;
        this.downloads = PropertyKt.mutableProperty((Map)new LinkedHashMap());
        SequentialLifetimes debugLifetime = new SequentialLifetimes(this.lifetime);
        this.downloads.forEach(this.lifetime, (Function1<Map<String, DownloadItemVm>, Unit>)((Function1)arg_0 -> DesktopAppDownloadVM._init_$lambda$4(debugLifetime, arg_0)));
    }

    @NotNull
    public final DownloadItemController getController() {
        return this.controller;
    }

    @NotNull
    public final DownloadItemVm addItem(@NotNull DownloadItemInfo item2, @NotNull Function1<? super DownloadItemVm, Unit> onPathDefined) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter(onPathDefined, (String)"onPathDefined");
        DownloadItemVm itemVm = new DownloadItemVm(this.lifetime, this.controller, item2, onPathDefined);
        this.downloads.getValue().put(item2.getId(), itemVm);
        this.downloads.forceNotify();
        return itemVm;
    }

    private final DownloadItemVm getItem(String itemId) {
        return this.downloads.getValue().get(itemId);
    }

    public final void onItemUpdated(@NotNull String id2, @NotNull String fileName, @NotNull String path, long totalBytes, long receivedBytes, @NotNull String state) {
        block1: {
            DownloadItemVm it;
            DownloadItemVm itemVm;
            block2: {
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                DownloadItemVm downloadItemVm = itemVm = this.getItem(id2);
                if (downloadItemVm == null) break block1;
                it = downloadItemVm;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)state, (Object)"interrupted") || itemVm.getState().getValue().isTerminal()) break block2;
                itemVm.getState().setValue(DownloadItemState.Paused);
                break block1;
            }
            it.getReceivedBytes().setValue(receivedBytes);
            if (((Number)it.getTotalBytes().getValue()).longValue() == 0L && totalBytes != 0L) {
                it.getTotalBytes().setValue(totalBytes);
            }
            it.getPath().setValue(path);
            it.getFileName().setValue(fileName);
            if (receivedBytes <= 0L || itemVm.getState().getValue() != DownloadItemState.Created) break block1;
            itemVm.getState().setValue(DownloadItemState.InProgress);
        }
    }

    public final void onItemDone(@NotNull String id2, @Nullable String errorMessage, @NotNull String state) {
        block13: {
            DownloadItemVm itemVm;
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            DownloadItemVm downloadItemVm = itemVm = this.getItem(id2);
            if (downloadItemVm == null) break block13;
            DownloadItemVm vm2 = downloadItemVm;
            boolean bl = false;
            int n = -1;
            switch (state.hashCode()) {
                case 476588369: {
                    if (state.equals("cancelled")) {
                        n = 1;
                    }
                    break;
                }
                case -1947652542: {
                    if (state.equals("interrupted")) {
                        n = 2;
                    }
                    break;
                }
                case -1402931637: {
                    if (state.equals("completed")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    vm2.getState().setValue(DownloadItemState.Cancelled);
                    vm2.getErrorMessage().setValue(errorMessage);
                    break;
                }
                case 2: {
                    vm2.getState().setValue(DownloadItemState.Interrupted);
                    vm2.getErrorMessage().setValue(errorMessage);
                    break;
                }
                case 3: {
                    vm2.getState().setValue(DownloadItemState.Completed);
                    break;
                }
                default: {
                    DownloadVmKt.access$getLog$p().warn("Unexpected download item state: " + state);
                    vm2.getState().setValue(DownloadItemState.Completed);
                }
            }
            this.removeItem(id2);
        }
    }

    public final void removeItem(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        DownloadItemVm vm2 = this.downloads.getValue().remove(itemId);
        DispatchExtKt.dispatch(DispatchJvmKt.getUi(), 10000, this.lifetime, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(vm2, null){
            int label;
            final /* synthetic */ DownloadItemVm $vm;
            {
                this.$vm = $vm;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object2 = this.$vm;
                        boolean bl = object2 != null && (object2 = ((DownloadItemVm)object2).getAlertLifetime()) != null ? !((ILifetimeSource)object2).isTerminated() : false;
                        if (bl) {
                            this.$vm.getAlertLifetime().terminate();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.downloads.forceNotify();
    }

    private static final Unit lambda$4$lambda$3$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DownloadVmKt.access$getLog$p().info("Path has changed to " + it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(SequentialLifetimes $debugLifetime, Map it) {
        Intrinsics.checkNotNullParameter((Object)$debugLifetime, (String)"$debugLifetime");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Lifetime nestedSeqLt = $debugLifetime.next();
        Iterable $this$forEach$iv = it.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadItemVm it2 = (DownloadItemVm)element$iv;
            boolean bl = false;
            DownloadVmKt.access$getLog$p().info("###### Path: " + it2.getPath().getValue());
            it2.getPath().forEach(nestedSeqLt, (Function1<String, Unit>)((Function1)DesktopAppDownloadVM::lambda$4$lambda$3$lambda$2));
        }
        return Unit.INSTANCE;
    }
}

