/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.diff;

import com.intellij.collaboration.ui.codereview.diff.model.DiffViewerChangeScrollRequest;
import com.intellij.collaboration.ui.codereview.diff.model.DiffViewerLineScrollRequest;
import com.intellij.collaboration.ui.codereview.diff.model.DiffViewerScrollRequest;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eJ\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/collaboration/ui/codereview/diff/DiffViewerScrollRequestProcessor;", "", "<init>", "()V", "scroll", "", "viewer", "Lcom/intellij/diff/FrameDiffTool$DiffViewer;", "request", "Lcom/intellij/collaboration/ui/codereview/diff/model/DiffViewerScrollRequest;", "location", "Lkotlin/Pair;", "Lcom/intellij/diff/util/Side;", "", "Lcom/intellij/collaboration/ui/codereview/diff/DiffLineLocation;", "policy", "Lcom/intellij/diff/util/DiffUserDataKeysEx$ScrollToPolicy;", "intellij.platform.collaborationTools"})
public final class DiffViewerScrollRequestProcessor {
    @NotNull
    public static final DiffViewerScrollRequestProcessor INSTANCE = new DiffViewerScrollRequestProcessor();

    private DiffViewerScrollRequestProcessor() {
    }

    public final void scroll(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull DiffViewerScrollRequest request) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        DiffViewerScrollRequest diffViewerScrollRequest = request;
        if (diffViewerScrollRequest instanceof DiffViewerLineScrollRequest) {
            this.scroll(viewer, ((DiffViewerLineScrollRequest)request).getLocation());
        } else if (diffViewerScrollRequest instanceof DiffViewerChangeScrollRequest) {
            this.scroll(viewer, ((DiffViewerChangeScrollRequest)request).getPolicy());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void scroll(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull Pair<? extends Side, Integer> location) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter(location, (String)"location");
        Side side = (Side)location.component1();
        int line = ((Number)location.component2()).intValue();
        FrameDiffTool.DiffViewer diffViewer = viewer;
        if (diffViewer instanceof OnesideTextDiffViewer) {
            ((OnesideTextDiffViewer)viewer).scrollToLine(line);
        } else if (diffViewer instanceof SimpleDiffViewer) {
            ((SimpleDiffViewer)viewer).scrollToLine(side, line);
        } else if (diffViewer instanceof UnifiedDiffViewer) {
            ((UnifiedDiffViewer)viewer).scrollToLine(side, line);
        }
    }

    private final void scroll(FrameDiffTool.DiffViewer viewer, DiffUserDataKeysEx.ScrollToPolicy policy) {
        FrameDiffTool.DiffViewer diffViewer = viewer;
        if (diffViewer instanceof SimpleDiffViewer) {
            ((SimpleDiffViewer)viewer).scrollToChange(policy);
        } else if (diffViewer instanceof UnifiedDiffViewer) {
            ((UnifiedDiffViewer)viewer).scrollToChange(policy);
        }
    }
}

