/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.openapi.Disposable;
import com.intellij.terminal.backend.ObservableTtyConnector;
import com.intellij.terminal.backend.TtyConnectorListener;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.TextBufferChangesListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\r\u001a\u0004\u0018\u00010\u000bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/terminal/backend/TerminalOutputLatencyTracker;", "", "ttyConnector", "Lcom/intellij/terminal/backend/ObservableTtyConnector;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/terminal/backend/ObservableTtyConnector;Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/openapi/Disposable;)V", "lastTtyReadTime", "Lkotlin/time/TimeMark;", "firstChangeTtyReadTime", "getCurUpdateTtyReadTimeAndReset", "intellij.terminal.backend"})
public final class TerminalOutputLatencyTracker {
    @Nullable
    private TimeMark lastTtyReadTime;
    @Nullable
    private TimeMark firstChangeTtyReadTime;

    public TerminalOutputLatencyTracker(@NotNull ObservableTtyConnector ttyConnector, @NotNull TerminalTextBuffer textBuffer, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        ttyConnector.addListener(parentDisposable, new TtyConnectorListener(){

            @Override
            public void charsRead(char[] buf, int offset, int length) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                lastTtyReadTime = (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
            }
        });
        textBuffer.addChangesListener(new TextBufferChangesListener(){

            public void linesChanged(int fromIndex) {
                if (firstChangeTtyReadTime == null) {
                    firstChangeTtyReadTime = lastTtyReadTime;
                }
            }

            public void historyCleared() {
                TextBufferChangesListener.DefaultImpls.historyCleared((TextBufferChangesListener)this);
            }

            public void linesDiscardedFromHistory(List<TerminalLine> lines) {
                TextBufferChangesListener.DefaultImpls.linesDiscardedFromHistory((TextBufferChangesListener)this, lines);
            }

            public void widthResized() {
                TextBufferChangesListener.DefaultImpls.widthResized((TextBufferChangesListener)this);
            }
        });
    }

    @Nullable
    public final TimeMark getCurUpdateTtyReadTimeAndReset() {
        TimeMark result2 = this.firstChangeTtyReadTime;
        this.firstChangeTtyReadTime = null;
        return result2;
    }
}

