/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.BeanConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalShellCommandHandlerHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0004\b\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalCommandHandlerCustomizer;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "<init>", "()V", "getConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "TerminalCommandHandlerOptions", "TerminalCommandHandlerListener", "TerminalCommandHandlerConfigurable", "Constants", "intellij.terminal"})
public final class TerminalCommandHandlerCustomizer
extends LocalTerminalCustomizer {
    @Override
    @Nullable
    public UnnamedConfigurable getConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!TerminalShellCommandHandlerHelper.isFeatureEnabled()) {
            return null;
        }
        return (UnnamedConfigurable)new TerminalCommandHandlerConfigurable(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalCommandHandlerCustomizer$Constants;", "", "<init>", "()V", "TERMINAL_CUSTOM_COMMAND_EXECUTION", "", "TERMINAL_CUSTOM_COMMAND_EXECUTION_DEFAULT", "", "TERMINAL_COMMAND_HANDLER_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/plugins/terminal/TerminalCommandHandlerCustomizer$TerminalCommandHandlerListener;", "kotlin.jvm.PlatformType", "getTERMINAL_COMMAND_HANDLER_TOPIC$annotations", "getTERMINAL_COMMAND_HANDLER_TOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.terminal"})
    public static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        @NotNull
        public static final String TERMINAL_CUSTOM_COMMAND_EXECUTION = "terminalCustomCommandExecutionTurnOff";
        public static final boolean TERMINAL_CUSTOM_COMMAND_EXECUTION_DEFAULT = false;
        @Topic.AppLevel
        @NotNull
        private static final Topic<TerminalCommandHandlerListener> TERMINAL_COMMAND_HANDLER_TOPIC = new Topic(TerminalCommandHandlerListener.class);

        private Constants() {
        }

        @NotNull
        public static final Topic<TerminalCommandHandlerListener> getTERMINAL_COMMAND_HANDLER_TOPIC() {
            return TERMINAL_COMMAND_HANDLER_TOPIC;
        }

        @JvmStatic
        public static /* synthetic */ void getTERMINAL_COMMAND_HANDLER_TOPIC$annotations() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalCommandHandlerCustomizer$TerminalCommandHandlerConfigurable;", "Lcom/intellij/openapi/options/BeanConfigurable;", "Lorg/jetbrains/plugins/terminal/TerminalCommandHandlerCustomizer$TerminalCommandHandlerOptions;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "intellij.terminal"})
    public static final class TerminalCommandHandlerConfigurable
    extends BeanConfigurable<TerminalCommandHandlerOptions> {
        public TerminalCommandHandlerConfigurable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super((Object)new TerminalCommandHandlerOptions(project));
            String string = TerminalBundle.message("settings.terminal.smart.command.handling", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.checkBox(string, (KMutableProperty0)new MutablePropertyReference0Impl(this.getInstance()){

                public Object get() {
                    return ((TerminalCommandHandlerOptions)this.receiver).getEnabled();
                }

                public void set(Object value) {
                    ((TerminalCommandHandlerOptions)this.receiver).setEnabled((Boolean)value);
                }
            });
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalCommandHandlerCustomizer$TerminalCommandHandlerListener;", "", "modeChanged", "", "intellij.terminal"})
    public static interface TerminalCommandHandlerListener {
        public void modeChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalCommandHandlerCustomizer$TerminalCommandHandlerOptions;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "intellij.terminal"})
    public static final class TerminalCommandHandlerOptions {
        @NotNull
        private final Project project;

        public TerminalCommandHandlerOptions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final boolean getEnabled() {
            return PropertiesComponent.getInstance().getBoolean("terminalCustomCommandExecutionTurnOff", false);
        }

        public final void setEnabled(boolean value) {
            PropertiesComponent.getInstance().setValue("terminalCustomCommandExecutionTurnOff", value, false);
            ((TerminalCommandHandlerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(Constants.getTERMINAL_COMMAND_HANDLER_TOPIC())).modeChanged();
        }
    }
}

