/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.ActionBasedFeedbackConfig;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalFeedbackDialog;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackMoment;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0011\u001a\u00020\u000eH\u0016J \u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/terminal/block/feedback/ReworkedTerminalSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/ActionBasedFeedbackConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "checkExtraConditionSatisfied", "checkExtraConditionSatisfiedForNotification", "checkExtraConditionSatisfiedForAction", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterNotificationShowed", "", "updateStateAfterDialogClosedOk", "intellij.terminal"})
@ApiStatus.Internal
public final class ReworkedTerminalSurveyConfig
implements InIdeFeedbackSurveyConfig,
ActionBasedFeedbackConfig {
    @NotNull
    public static final ReworkedTerminalSurveyConfig INSTANCE = new ReworkedTerminalSurveyConfig();
    @NotNull
    private static final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, 7, 15);
    private static final boolean requireIdeEAP;

    private ReworkedTerminalSurveyConfig() {
    }

    @NotNull
    public String getSurveyId() {
        return "reworked_terminal";
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isJetBrainsProduct();
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ReworkedTerminalFeedbackDialog(project, forTest);
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public boolean checkExtraConditionSatisfiedForNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageLocalStorage usageStorage = TerminalUsageLocalStorage.Companion.getInstance();
        return !usageStorage.getState().getFeedbackNotificationShown() && (usageStorage.getState().getEnterKeyPressedTimes() >= 15 || usageStorage.getState().getEnterKeyPressedTimes() > 0 && ReworkedTerminalFeedbackSurveyKt.getFeedbackMoment(project) == TerminalFeedbackMoment.ON_DISABLING);
    }

    public boolean checkExtraConditionSatisfiedForAction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return TerminalOptionsProvider.Companion.getInstance().getTerminalEngine() == TerminalEngine.REWORKED;
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = TerminalBundle.message("feedback.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = TerminalBundle.message("feedback.notification.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new RequestFeedbackNotification("Feedback In IDE", string, string2);
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageLocalStorage.Companion.getInstance().recordFeedbackNotificationShown();
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

