/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked.hyperlinks;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkListener;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.ExpirableTokenProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.terminal.block.hyperlinks.CompositeFilterWrapper;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0007J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u001bH\u0081@\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\u001bH\u0081@\u00a2\u0006\u0004\b#\u0010!J\r\u0010\u0018\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinkHighlighter;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lkotlinx/coroutines/CoroutineScope;)V", "filterWrapper", "Lorg/jetbrains/plugins/terminal/block/hyperlinks/CompositeFilterWrapper;", "tokenProvider", "Lcom/intellij/execution/impl/ExpirableTokenProvider;", "actualStartOffset", "", "delayedHighlightingJob", "Lkotlinx/coroutines/Job;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "hyperlinkSupport", "Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "getHyperlinkSupport", "()Lcom/intellij/execution/impl/EditorHyperlinkSupport;", "rehighlightAll", "", "highlightHyperlinks", "startOffset", "doHyperlinkHighlighting", "awaitInitialized", "awaitInitialized$intellij_terminal", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitDelayedHighlightings", "awaitDelayedHighlightings$intellij_terminal", "getHyperlinkSupport$intellij_terminal", "Companion", "intellij.terminal"})
@ApiStatus.Internal
public final class TerminalHyperlinkHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CompositeFilterWrapper filterWrapper;
    @NotNull
    private final ExpirableTokenProvider tokenProvider;
    private int actualStartOffset;
    @Nullable
    private Job delayedHighlightingJob;
    private static final long DELAY = DurationKt.toDuration((int)SystemProperties.getIntProperty((String)"console.flush.delay.ms", (int)200), (DurationUnit)DurationUnit.MILLISECONDS);
    private static final int INFINITE = Integer.MAX_VALUE;

    private TerminalHyperlinkHighlighter(Project project, Editor editor, CoroutineScope coroutineScope) {
        this.editor = editor;
        this.coroutineScope = coroutineScope;
        this.filterWrapper = new CompositeFilterWrapper(project, this.coroutineScope);
        this.tokenProvider = new ExpirableTokenProvider();
        this.actualStartOffset = Integer.MAX_VALUE;
        this.filterWrapper.addFiltersUpdatedListener((Function0<Unit>)((Function0)() -> TerminalHyperlinkHighlighter._init_$lambda$0(this)));
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOffset() == 0 && event.getNewLength() == 0) {
                    actualStartOffset = Math.max(0, actualStartOffset - event.getOldLength());
                }
            }
        });
        EditorHyperlinkSupport hyperlinkSupport = this.getHyperlinkSupport();
        EditorHyperlinkListener listener2 = TerminalHyperlinkHighlighter::_init_$lambda$1;
        hyperlinkSupport.addEditorHyperlinkListener(listener2);
        JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> TerminalHyperlinkHighlighter._init_$lambda$2(hyperlinkSupport, listener2, arg_0));
    }

    private final Document getDocument() {
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    private final EditorHyperlinkSupport getHyperlinkSupport() {
        EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get((Editor)this.editor, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)editorHyperlinkSupport, (String)"get(...)");
        return editorHyperlinkSupport;
    }

    private final void rehighlightAll() {
        this.tokenProvider.invalidateAll();
        this.getHyperlinkSupport().clearHyperlinks(0, this.getDocument().getTextLength());
        this.highlightHyperlinks(0);
    }

    @RequiresEdt(generateAssertion=false)
    public final void highlightHyperlinks(int startOffset) {
        this.actualStartOffset = Math.min(this.actualStartOffset, startOffset);
        if (TerminalHyperlinkHighlighter.Companion.isNotActive(this.delayedHighlightingJob)) {
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = ModalityState.any();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
            this.delayedHighlightingJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ TerminalHyperlinkHighlighter this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)TerminalHyperlinkHighlighter.access$getDELAY$cp(), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            TerminalHyperlinkHighlighter.access$doHyperlinkHighlighting(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void doHyperlinkHighlighting() {
        CompositeFilter compositeFilter = this.filterWrapper.getFilter();
        if (compositeFilter == null) {
            return;
        }
        CompositeFilter filter = compositeFilter;
        if (filter.isEmpty()) {
            return;
        }
        if (this.getDocument().getTextLength() == 0) {
            return;
        }
        int startOffset = this.actualStartOffset;
        this.actualStartOffset = Integer.MAX_VALUE;
        int startLine = this.getDocument().getLineNumber(startOffset);
        int endLine = Math.max(0, this.getDocument().getLineCount() - 1);
        this.getHyperlinkSupport().clearHyperlinks(startOffset, this.getDocument().getTextLength());
        this.getHyperlinkSupport().highlightHyperlinksLater((Filter)filter, startLine, endLine, this.tokenProvider.createExpirable());
    }

    @TestOnly
    @Nullable
    public final Object awaitInitialized$intellij_terminal(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.filterWrapper.awaitFiltersComputed$intellij_terminal($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @TestOnly
    @Nullable
    public final Object awaitDelayedHighlightings$intellij_terminal(@NotNull Continuation<? super Unit> $completion) {
        Job job2 = this.delayedHighlightingJob;
        if (job2 != null) {
            Object object = job2.join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @TestOnly
    @NotNull
    public final EditorHyperlinkSupport getHyperlinkSupport$intellij_terminal() {
        return this.getHyperlinkSupport();
    }

    private static final Unit _init_$lambda$0(TerminalHyperlinkHighlighter this$0) {
        this$0.rehighlightAll();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(HyperlinkInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ReworkedTerminalUsageCollector.INSTANCE.logHyperlinkFollowed(it.getClass());
    }

    private static final Unit _init_$lambda$2(EditorHyperlinkSupport $hyperlinkSupport, EditorHyperlinkListener $listener, Throwable it) {
        $hyperlinkSupport.removeEditorHyperlinkListener($listener);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ long access$getDELAY$cp() {
        return DELAY;
    }

    public static final /* synthetic */ void access$doHyperlinkHighlighting(TerminalHyperlinkHighlighter $this) {
        $this.doHyperlinkHighlighting();
    }

    public /* synthetic */ TerminalHyperlinkHighlighter(Project project, Editor editor, CoroutineScope coroutineScope, DefaultConstructorMarker $constructor_marker) {
        this(project, editor, coroutineScope);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u0015H\u0002R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinkHighlighter$Companion;", "", "<init>", "()V", "install", "Lorg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinkHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "DELAY", "Lkotlin/time/Duration;", "J", "INFINITE", "", "isNotActive", "", "Lkotlinx/coroutines/Job;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TerminalHyperlinkHighlighter install(@NotNull Project project, @NotNull TerminalOutputModel model, @NotNull Editor editor, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            TerminalHyperlinkHighlighter hyperlinkHighlighter = new TerminalHyperlinkHighlighter(project, editor, coroutineScope, null);
            model.addListener(CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope), new TerminalOutputModelListener(hyperlinkHighlighter){
                final /* synthetic */ TerminalHyperlinkHighlighter $hyperlinkHighlighter;
                {
                    this.$hyperlinkHighlighter = $hyperlinkHighlighter;
                }

                public void afterContentChanged(TerminalOutputModel model, int startOffset) {
                    Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                    this.$hyperlinkHighlighter.highlightHyperlinks(startOffset);
                }
            });
            return hyperlinkHighlighter;
        }

        private final boolean isNotActive(Job $this$isNotActive) {
            return $this$isNotActive == null || !$this$isNotActive.isActive();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

