/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.LocalProcessService;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance(OSProcessHandler.class);
    private static final Set<String> REPORTED_EXECUTIONS = ContainerUtil.newConcurrentSet();
    private static final long ALLOWED_TIMEOUT_THRESHOLD = 10L;
    private static final Key<Set<File>> DELETE_FILES_ON_TERMINATION = Key.create((String)"OSProcessHandler.FileToDelete");
    private final boolean myHasErrorStream;
    private final ModalityState myModality;
    private Boolean myHasPty;
    private boolean myDestroyRecursively;
    @Nullable
    private final Set<? extends File> myFilesToDelete;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            OSProcessHandler.$$$reportNull$$$0(0);
        }
        super(OSProcessHandler.startProcess(commandLine), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myDestroyRecursively = true;
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        this.myHasErrorStream = !commandLine.isRedirectErrorStream();
        this.myFilesToDelete = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
        this.myModality = OSProcessHandler.getDefaultModality();
    }

    @NotNull
    public static ModalityState getDefaultModality() {
        Application app = ApplicationManager.getApplication();
        ModalityState modalityState = app == null ? ModalityState.nonModal() : app.getDefaultModalityState();
        if (modalityState == null) {
            OSProcessHandler.$$$reportNull$$$0(1);
        }
        return modalityState;
    }

    public OSProcessHandler(@NotNull Process process, String commandLine) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(2);
        }
        this(process, commandLine, EncodingManager.getInstance().getDefaultConsoleEncoding());
    }

    public OSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(3);
        }
        this(process, commandLine, charset, null);
    }

    public OSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset, @Nullable Set<? extends File> filesToDelete) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(4);
        }
        super(process, commandLine, charset);
        this.myDestroyRecursively = true;
        this.myFilesToDelete = filesToDelete;
        this.myHasErrorStream = true;
        this.myModality = OSProcessHandler.getDefaultModality();
    }

    private static Process startProcess(GeneralCommandLine commandLine) throws ExecutionException {
        try {
            return commandLine.createProcess();
        }
        catch (Throwable e) {
            OSProcessHandler.deleteTempFiles(commandLine.getUserData(DELETE_FILES_ON_TERMINATION));
            throw e;
        }
    }

    public boolean waitFor() {
        OSProcessHandler.checkEdtAndReadAction((ProcessHandler)this);
        return super.waitFor();
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        if (timeoutInMilliseconds > 10L) {
            OSProcessHandler.checkEdtAndReadAction((ProcessHandler)this);
        }
        return super.waitFor(timeoutInMilliseconds);
    }

    @ApiStatus.Internal
    public static void checkEdtAndReadAction(@NotNull ProcessHandler processHandler) {
        Application application;
        if (processHandler == null) {
            OSProcessHandler.$$$reportNull$$$0(5);
        }
        if ((application = ApplicationManager.getApplication()) == null || !application.isInternal() || application.isHeadlessEnvironment()) {
            return;
        }
        String message = null;
        if (application.isDispatchThread()) {
            message = "Synchronous execution on EDT: ";
        } else if (application.holdsReadLock()) {
            message = "Synchronous execution under ReadAction: ";
        }
        if (message != null && REPORTED_EXECUTIONS.add(ExceptionUtil.currentStackTrace())) {
            LOG.error(message + String.valueOf(processHandler) + ", see com.intellij.execution.process.OSProcessHandler#checkEdtAndReadAction() Javadoc for resolutions");
        }
    }

    private static void deleteTempFiles(Set<? extends File> tempFiles) {
        if (tempFiles != null) {
            try {
                for (File file : tempFiles) {
                    FileUtil.delete((File)file);
                }
            }
            catch (Throwable t) {
                LOG.error("failed to delete temp. files", t);
            }
        }
    }

    protected void onOSProcessTerminated(int exitCode) {
        if (this.myModality != ModalityState.nonModal()) {
            ProgressManager.getInstance().runProcess(() -> super.onOSProcessTerminated(exitCode), (ProgressIndicator)new EmptyProgressIndicator(this.myModality));
        } else {
            super.onOSProcessTerminated(exitCode);
        }
        OSProcessHandler.deleteTempFiles(this.myFilesToDelete);
    }

    protected boolean processHasSeparateErrorStream() {
        return this.myHasErrorStream;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process)) {
            this.killProcessTree(process);
        } else {
            process.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process) {
        return !(process instanceof SelfKiller);
    }

    protected void killProcessTree(@NotNull Process process) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(6);
        }
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessUtil.killProcessTree(process);
        if (!destroyed) {
            if (!process.isAlive()) {
                LOG.warn("Process has been already terminated: " + this.getCommandLineForLog());
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.getCommandLineForLog());
                process.destroy();
            }
        }
    }

    public boolean hasPty() {
        if (this.myHasPty == null) {
            this.myHasPty = LoadingState.COMPONENTS_LOADED.isOccurred() && LocalProcessService.getInstance().isLocalPtyProcess(this.getProcess());
        }
        return this.myHasPty;
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = this.hasPty() ? BaseOutputReader.Options.forTerminalPtyProcess() : super.readerOptions();
        if (options == null) {
            OSProcessHandler.$$$reportNull$$$0(7);
        }
        return options;
    }

    @ApiStatus.Internal
    public static void deleteFileOnTermination(@NotNull GeneralCommandLine commandLine, @NotNull File fileToDelete) {
        Set<File> set;
        if (commandLine == null) {
            OSProcessHandler.$$$reportNull$$$0(8);
        }
        if (fileToDelete == null) {
            OSProcessHandler.$$$reportNull$$$0(9);
        }
        if ((set = commandLine.getUserData(DELETE_FILES_ON_TERMINATION)) == null) {
            set = new HashSet<File>();
            commandLine.putUserData(DELETE_FILES_ON_TERMINATION, set);
        }
        set.add(fileToDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModality";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkEdtAndReadAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteFileOnTermination";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }

    public static class Silent
    extends OSProcessHandler {
        public Silent(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                Silent.$$$reportNull$$$0(0);
            }
            super(commandLine);
        }

        @Override
        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
            if (options == null) {
                Silent.$$$reportNull$$$0(1);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/process/OSProcessHandler$Silent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/process/OSProcessHandler$Silent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

