/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImplKt;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.UtilKt;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0012\u001a\u00020\u00132\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000H\u0007J\u001e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0007J6\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020!0 2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020!0 J\u001c\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010&\u001a\u00020\u0013J\u001c\u0010'\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J,\u0010(\u001a\u00020\u00132\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0007J(\u0010(\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020\u001dH\u0017J>\u00101\u001a\b\u0012\u0004\u0012\u0002H20\t\"\b\b\u0000\u00102*\u00020\u00112\u0006\u00103\u001a\u00020\b2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H2052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u001dH\u0007J@\u00106\u001a\b\u0012\u0004\u0012\u0002H20\t\"\b\b\u0000\u00102*\u00020\u00112\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\u001dH\u0003J(\u00109\u001a\b\u0012\u0004\u0012\u0002H20\t\"\b\b\u0000\u00102*\u00020\u00112\u0006\u00103\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0016\u001a\u00020\u00132\f\u0010<\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010=\u001a\b\u0012\u0004\u0012\u0002H20\t\"\b\b\u0000\u00102*\u00020\u00112\u0006\u0010\u001e\u001a\u00020\bH\u0016J\"\u0010>\u001a\n\u0012\u0004\u0012\u0002H2\u0018\u00010\t\"\b\b\u0000\u00102*\u00020\u00112\u0006\u0010\u001e\u001a\u00020\bH\u0016J&\u0010=\u001a\b\u0012\u0004\u0012\u0002H20?\"\b\b\u0000\u00102*\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H20@H\u0016J \u0010A\u001a\u00020\u00132\u0016\u0010B\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00130CH\u0017J\u0010\u0010D\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\bH\u0017J\u0010\u0010E\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0014\u0010E\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030@H\u0016J\b\u0010F\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/openapi/extensions/impl/ExtensionsAreaImpl;", "Lcom/intellij/openapi/extensions/ExtensionsArea;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "<init>", "(Lcom/intellij/openapi/components/ComponentManager;)V", "extensionPoints", "", "", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "epTraces", "Ljava/util/HashMap;", "", "nameToPointMap", "getNameToPointMap", "()Ljava/util/Map;", "lock", "", "reset", "", "notifyAreaReplaced", "newArea", "registerExtensionPoints", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "extensionPointElements", "", "Lorg/jdom/Element;", "unregisterExtensions", "", "extensionPointName", "priorityListenerCallbacks", "", "Ljava/lang/Runnable;", "listenerCallbacks", "resetExtensionPoints", "descriptors", "Lcom/intellij/openapi/extensions/ExtensionPointDescriptor;", "clearUserCache", "unregisterExtensionPoints", "registerExtensionPoint", "extensionPoint", "Lcom/intellij/openapi/extensions/BaseExtensionPointName;", "extensionPointBeanClass", "kind", "Lcom/intellij/openapi/extensions/ExtensionPoint$Kind;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "isDynamic", "registerPoint", "T", "name", "extensionClass", "Ljava/lang/Class;", "doRegisterExtensionPoint", "isInterface", "dynamic", "registerFakeBeanPoint", "checkThatPointNotDuplicated", "pointName", "points", "getExtensionPoint", "getExtensionPointIfRegistered", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "processExtensionPoints", "consumer", "Lkotlin/Function1;", "unregisterExtensionPoint", "hasExtensionPoint", "toString", "intellij.platform.extensions"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExtensionsAreaImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1869#2,2:307\n*S KotlinDebug\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n*L\n287#1:307,2\n*E\n"})
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    @NotNull
    private final ComponentManager componentManager;
    @NotNull
    private volatile Map<String, ? extends ExtensionPointImpl<?>> extensionPoints;
    @Nullable
    private final HashMap<String, Throwable> epTraces;
    @NotNull
    private final Object lock;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        this.componentManager = componentManager;
        Map map = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"emptyMap(...)");
        this.extensionPoints = map;
        this.epTraces = null;
        this.lock = new Object();
    }

    @Override
    @NotNull
    public Map<String, ExtensionPointImpl<?>> getNameToPointMap() {
        return this.extensionPoints;
    }

    public final void reset(@NotNull Map<String, ? extends ExtensionPointImpl<?>> nameToPointMap) {
        Intrinsics.checkNotNullParameter(nameToPointMap, (String)"nameToPointMap");
        this.extensionPoints = nameToPointMap;
    }

    @TestOnly
    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.name);
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.name)) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @TestOnly
    public final void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<? extends Element> extensionPointElements) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(extensionPointElements, (String)"extensionPointElements");
        for (Element element : extensionPointElements) {
            String pointName = element.getAttributeValue("qualifiedName");
            if (pointName == null) {
                String name;
                if (element.getAttributeValue("name") == null) {
                    throw this.componentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                }
                pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
            }
            String beanClassName = element.getAttributeValue("beanClass");
            String interfaceClassName = element.getAttributeValue("interface");
            if (beanClassName == null && interfaceClassName == null) {
                throw this.componentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            if (beanClassName != null && interfaceClassName != null) {
                throw this.componentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            boolean dynamic = Boolean.parseBoolean(element.getAttributeValue("dynamic"));
            String string = interfaceClassName;
            if (string == null) {
                string = beanClassName;
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            this.doRegisterExtensionPoint(pointName, string2, pluginDescriptor, interfaceClassName != null, dynamic);
        }
    }

    public final boolean unregisterExtensions(@NotNull String extensionPointName, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter(priorityListenerCallbacks, (String)"priorityListenerCallbacks");
        Intrinsics.checkNotNullParameter(listenerCallbacks, (String)"listenerCallbacks");
        ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(extensionPointName);
        if (extensionPointImpl == null) {
            return false;
        }
        ExtensionPointImpl<?> point = extensionPointImpl;
        point.unregisterExtensions(this.componentManager, pluginDescriptor, priorityListenerCallbacks, listenerCallbacks);
        return true;
    }

    public final void resetExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        for (ExtensionPointDescriptor descriptor : descriptors) {
            ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(descriptor.getQualifiedName(pluginDescriptor));
            if (extensionPointImpl == null) continue;
            extensionPointImpl.reset();
        }
    }

    public final void clearUserCache() {
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.clearUserCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (descriptors.isEmpty()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            for (ExtensionPointDescriptor descriptor : descriptors) {
                this.extensionPoints = UtilKt.without(this.extensionPoints, (Object)descriptor.getQualifiedName(pluginDescriptor));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @TestOnly
    public final void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(extensionPoint, (String)"extensionPoint");
        Intrinsics.checkNotNullParameter((Object)extensionPointBeanClass, (String)"extensionPointBeanClass");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        String extensionPointName = extensionPoint.getName();
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, kind, false);
        Disposer.register((Disposable)parentDisposable, () -> ExtensionsAreaImpl.registerExtensionPoint$lambda$1(this, extensionPointName));
    }

    @Override
    @TestOnly
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, boolean isDynamic) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        Intrinsics.checkNotNullParameter((Object)extensionPointBeanClass, (String)"extensionPointBeanClass");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("fakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, isDynamic);
    }

    @TestOnly
    @NotNull
    public final <T> ExtensionPointImpl<T> registerPoint(@NotNull String name, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isDynamic) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        String string = extensionClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.doRegisterExtensionPoint(name, string, pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, isDynamic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private final <T> ExtensionPointImpl<T> doRegisterExtensionPoint(String name, String extensionClass, PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        ExtensionPointImpl extensionPointImpl;
        if (isInterface) {
            ComponentManager componentManager = this.componentManager;
            extensionPointImpl = new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, componentManager, null, dynamic, false);
        } else {
            extensionPointImpl = new BeanExtensionPoint(name, extensionClass, pluginDescriptor, this.componentManager, dynamic);
        }
        ExtensionPointImpl point = extensionPointImpl;
        this.checkThatPointNotDuplicated(name, point.getPluginDescriptor());
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.extensionPoints = UtilKt.with(this.extensionPoints, (Object)name, (Object)point);
            Unit unit = Unit.INSTANCE;
        }
        return point;
    }

    @TestOnly
    @NotNull
    public final <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.doRegisterExtensionPoint(name, string, pluginDescriptor, false, false);
    }

    private final void checkThatPointNotDuplicated(String pointName, PluginDescriptor pluginDescriptor) {
        ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(pointName);
        if (extensionPointImpl == null) {
            return;
        }
        PluginId pluginId = extensionPointImpl.getPluginDescriptor().getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId id1 = pluginId;
        PluginId pluginId2 = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getPluginId(...)");
        PluginId id2 = pluginId2;
        String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        throw this.componentManager.createError(message, pluginDescriptor.getPluginId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        HashMap map = new HashMap();
        ExtensionsAreaImplKt.createExtensionPoints(points, this.componentManager, map, pluginDescriptor);
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.extensionPoints = UtilKt.withAll(this.extensionPoints, (Map)map);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        return extensionPoint;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, (String)"extensionPointName");
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    @TestOnly
    public void processExtensionPoints(@NotNull Function1<? super ExtensionPointImpl<?>, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable $this$forEach$iv = this.extensionPoints.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            consumer.invoke(element$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TestOnly
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            return;
        }
        ExtensionPoint extensionPoint2 = extensionPoint;
        ((ExtensionPointImpl)extensionPoint2).reset();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.extensionPoints = UtilKt.without(this.extensionPoints, (Object)extensionPointName);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter((Object)extensionPointName, (String)"extensionPointName");
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, (String)"extensionPointName");
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    @NotNull
    public String toString() {
        return this.componentManager.toString();
    }

    private static final void registerExtensionPoint$lambda$1(ExtensionsAreaImpl this$0, String $extensionPointName) {
        this$0.unregisterExtensionPoint($extensionPointName);
    }
}

