/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.impl;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.ijent.EelPlatformExKt;
import com.intellij.platform.ijent.IjentBundle;
import com.intellij.platform.ijent.impl.ProductionIjentExecFileProvider;
import com.intellij.platform.ijent.impl.ProductionIjentExecFileProviderKt;
import com.intellij.util.system.CpuArch;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000?\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u001c\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0081@\u00a2\u0006\u0002\u0010\u0007\u001a\u0016\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0001\u001a\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0081@\u00a2\u0006\u0002\u0010\f\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a \u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0017\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002\u00a2\u0006\u0002\u0010\u001d\"\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\u0010\"\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"getHostingPlugin", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/platform/eel/EelPlatform;", "tryGetIjentBinariesFromStaticDirectory", "", "Ljava/nio/file/Path;", "targetPlatform", "(Lcom/intellij/platform/eel/EelPlatform;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "theOnlyLocalBinary", "localBinaries", "reportAboutProblemsWhenRunningFromSources", "", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBinaryFromPluginRoot", "repositoryRoot", "getRepositoryRoot", "()Ljava/nio/file/Path;", "gitRoot", "getGitRoot", "gitRoot$delegate", "Lkotlin/Lazy;", "askAboutPlugin", "", "mayShowDialog", "Lkotlin/reflect/KMutableProperty0;", "dialogMessage", "", "doNotAskOption", "com/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt$doNotAskOption$1", "(Lkotlin/reflect/KMutableProperty0;)Lcom/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt$doNotAskOption$1;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ijent.impl"})
@SourceDebugExtension(value={"SMAP\nProductionIjentExecFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductionIjentExecFileProvider.kt\ncom/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,311:1\n68#2,4:312\n14#2:316\n*S KotlinDebug\n*F\n+ 1 ProductionIjentExecFileProvider.kt\ncom/intellij/platform/ijent/impl/ProductionIjentExecFileProviderKt\n*L\n232#1:312,4\n311#1:316\n*E\n"})
public final class ProductionIjentExecFileProviderKt {
    @NotNull
    private static final Lazy gitRoot$delegate = LazyKt.lazy(ProductionIjentExecFileProviderKt::gitRoot_delegate$lambda$4);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final PluginId getHostingPlugin(@NotNull EelPlatform $this$getHostingPlugin) {
        PluginId pluginId;
        Intrinsics.checkNotNullParameter((Object)$this$getHostingPlugin, (String)"<this>");
        EelPlatform eelPlatform = $this$getHostingPlugin;
        if (eelPlatform instanceof EelPlatform.Linux) {
            PluginId pluginId2 = PluginId.getId((String)"intellij.platform.ijent.impl");
            pluginId = pluginId2;
            Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"getId(...)");
        } else if (eelPlatform instanceof EelPlatform.Darwin || eelPlatform instanceof EelPlatform.Windows || eelPlatform instanceof EelPlatform.FreeBSD) {
            PluginId pluginId3 = PluginId.getId((String)"ijent.binariesPlugin");
            pluginId = pluginId3;
            Intrinsics.checkNotNullExpressionValue((Object)pluginId3, (String)"getId(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @Nullable
    public static final Object tryGetIjentBinariesFromStaticDirectory(@NotNull EelPlatform targetPlatform, @NotNull Continuation<? super Collection<? extends Path>> $completion) {
        String string;
        String string2;
        Path path = ProductionIjentExecFileProviderKt.getRepositoryRoot();
        if (path == null) {
            return null;
        }
        Path repositoryRoot = path;
        LOG.debug("Looking if there are locally built IJent binaries");
        EelPlatform eelPlatform = targetPlatform;
        if (eelPlatform instanceof EelPlatform.Darwin) {
            var5_4 = ((EelPlatform.Darwin)targetPlatform).getArch();
            if (Intrinsics.areEqual((Object)var5_4, (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
                string2 = "aarch64-apple-darwin";
            } else {
                if (!Intrinsics.areEqual((Object)var5_4, (Object)EelPlatform.Arch.X86_64.INSTANCE)) throw new IllegalArgumentException("Unsupported darwin arch: " + ((EelPlatform.Darwin)targetPlatform).getArch());
                string2 = "x86_64-apple-darwin";
            }
        } else if (eelPlatform instanceof EelPlatform.Linux) {
            var5_4 = ((EelPlatform.Linux)targetPlatform).getArch();
            if (Intrinsics.areEqual((Object)var5_4, (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
                string2 = "aarch64-unknown-linux-musl";
            } else {
                if (!Intrinsics.areEqual((Object)var5_4, (Object)EelPlatform.Arch.X86_64.INSTANCE)) throw new IllegalArgumentException("Unsupported linux arch: " + ((EelPlatform.Linux)targetPlatform).getArch());
                string2 = "x86_64-unknown-linux-musl";
            }
        } else if (eelPlatform instanceof EelPlatform.Windows) {
            var5_4 = ((EelPlatform.Windows)targetPlatform).getArch();
            if (Intrinsics.areEqual((Object)var5_4, (Object)EelPlatform.Arch.ARM_64.INSTANCE)) {
                string2 = "aarch64-pc-windows-gnu";
            } else {
                if (!Intrinsics.areEqual((Object)var5_4, (Object)EelPlatform.Arch.X86_64.INSTANCE)) throw new IllegalArgumentException("Unsupported windows arch: " + ((EelPlatform.Windows)targetPlatform).getArch());
                string2 = "x86_64-pc-windows-gnu";
            }
        } else {
            if (!(eelPlatform instanceof EelPlatform.FreeBSD)) throw new NoWhenBranchMatchedException();
            throw new IllegalStateException("FreeBSD is not supported");
        }
        String explicitTargetSubdir = string2;
        Path localBinariesHomePath = repositoryRoot.resolve("fleet/native/target");
        EelPlatform eelPlatform2 = targetPlatform;
        if (eelPlatform2 instanceof EelPlatform.Posix) {
            string = "";
        } else {
            if (!(eelPlatform2 instanceof EelPlatform.Windows)) throw new NoWhenBranchMatchedException();
            string = ".exe";
        }
        String extension = string;
        boolean sameSystem = EelPlatformKt.isMac((EelPlatform)targetPlatform) && EelPlatformKt.isArm64((EelPlatform)targetPlatform) ? SystemInfoRt.isMac && CpuArch.isArm64() : (EelPlatformKt.isLinux((EelPlatform)targetPlatform) && EelPlatformKt.isArm64((EelPlatform)targetPlatform) ? SystemInfoRt.isLinux && CpuArch.isArm64() : (EelPlatformKt.isMac((EelPlatform)targetPlatform) && EelPlatformKt.isX86_64((EelPlatform)targetPlatform) ? SystemInfoRt.isMac && CpuArch.isIntel64() : (EelPlatformKt.isLinux((EelPlatform)targetPlatform) && EelPlatformKt.isX86_64((EelPlatform)targetPlatform) ? SystemInfoRt.isLinux && CpuArch.isIntel64() : (EelPlatformKt.isWindows((EelPlatform)targetPlatform) && EelPlatformKt.isX86_64((EelPlatform)targetPlatform) ? SystemInfoRt.isWindows && CpuArch.isIntel64() : (EelPlatformKt.isWindows((EelPlatform)targetPlatform) && EelPlatformKt.isArm64((EelPlatform)targetPlatform) ? SystemInfoRt.isWindows && CpuArch.isArm64() : false)))));
        Object[] objectArray = new String[]{"debug", "release"};
        return SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sequenceOf((Object[])objectArray), arg_0 -> ProductionIjentExecFileProviderKt.tryGetIjentBinariesFromStaticDirectory$lambda$0(localBinariesHomePath, explicitTargetSubdir, extension, sameSystem, arg_0)), ProductionIjentExecFileProviderKt::tryGetIjentBinariesFromStaticDirectory$lambda$2));
    }

    @VisibleForTesting
    @NotNull
    public static final Path theOnlyLocalBinary(@NotNull Collection<? extends Path> localBinaries) {
        Intrinsics.checkNotNullParameter(localBinaries, (String)"localBinaries");
        Path theBinary = (Path)CollectionsKt.first((Iterable)localBinaries);
        LOG.warn("Reminder: the following IJent is used instead of the bundled one. In case if it is undesired, delete the binary. " + theBinary);
        return theBinary;
    }

    @VisibleForTesting
    @Nullable
    public static final Object reportAboutProblemsWhenRunningFromSources(@NotNull Collection<? extends Path> localBinaries, @NotNull Continuation<? super Unit> $completion) {
        String message = CollectionsKt.joinToString$default((Iterable)localBinaries, (CharSequence)"\n\n", (CharSequence)"Ambiguity in paths to locally built IJents. Don't know what to choose between the files below. Keep only the right file, delete the others.\n\n", null, (int)0, null, null, (int)60, null);
        Application application = ApplicationManager.getApplication();
        boolean bl = application != null ? !application.isUnitTestMode() : false;
        if (bl) {
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = ModalityState.any();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
            Object object = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(message, null){
                int label;
                final /* synthetic */ String $message;
                {
                    this.$message = $message;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Messages.showErrorDialog((String)this.$message, (String)"IJent in internal mode");
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        throw new IllegalStateException(message.toString());
    }

    private static final Path getBinaryFromPluginRoot(Path $this$getBinaryFromPluginRoot, EelPlatform targetPlatform) {
        Path path;
        Path result = $this$getBinaryFromPluginRoot.resolve(EelPlatformExKt.getExecutableName((EelPlatform)targetPlatform));
        Intrinsics.checkNotNull((Object)result);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(result, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.warn(result + " isn't a regular file. It seems that the plugin " + $this$getBinaryFromPluginRoot + " is corrupted.");
            path = null;
        } else {
            path = result;
        }
        return path;
    }

    private static final Path getRepositoryRoot() {
        return AppMode.isDevServer() ? ProductionIjentExecFileProviderKt.getGitRoot() : (PluginManagerCore.isRunningFromSources() ? Path.of(PathManager.getHomePath(), new String[0]) : null);
    }

    private static final Path getGitRoot() {
        Lazy lazy = gitRoot$delegate;
        return (Path)lazy.getValue();
    }

    private static final boolean askAboutPlugin(KMutableProperty0<Boolean> mayShowDialog, @NlsContexts.DialogMessage String dialogMessage) {
        return (Boolean)mayShowDialog.get() != false && ((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(IjentBundle.INSTANCE.message("dialog.title.ijent.binary.plugin", new Object[0]), dialogMessage).doNotAsk((DoNotAskOption)ProductionIjentExecFileProviderKt.doNotAskOption(mayShowDialog))).ask(null);
    }

    private static final doNotAskOption.1 doNotAskOption(KMutableProperty0<Boolean> $this$doNotAskOption) {
        return new DoNotAskOption.Adapter($this$doNotAskOption){
            final /* synthetic */ KMutableProperty0<Boolean> $this_doNotAskOption;
            {
                this.$this_doNotAskOption = $receiver;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (exitCode == 0) {
                    this.$this_doNotAskOption.set((Object)(!isSelected ? 1 : 0));
                }
            }
        };
    }

    private static final Sequence tryGetIjentBinariesFromStaticDirectory$lambda$0(Path $localBinariesHomePath, String $explicitTargetSubdir, String $extension, boolean $sameSystem, String subdir) {
        Intrinsics.checkNotNullParameter((Object)subdir, (String)"subdir");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Path>, Continuation<? super Unit>, Object>($localBinariesHomePath, $explicitTargetSubdir, subdir, $extension, $sameSystem, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Path $localBinariesHomePath;
            final /* synthetic */ String $explicitTargetSubdir;
            final /* synthetic */ String $subdir;
            final /* synthetic */ String $extension;
            final /* synthetic */ boolean $sameSystem;
            {
                this.$localBinariesHomePath = $localBinariesHomePath;
                this.$explicitTargetSubdir = $explicitTargetSubdir;
                this.$subdir = $subdir;
                this.$extension = $extension;
                this.$sameSystem = $sameSystem;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield((Object)this.$localBinariesHomePath.resolve(this.$explicitTargetSubdir + "/" + this.$subdir + "/ijent" + this.$extension), (Continuation)this);
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (this.$sameSystem) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$sequence);
                            this.label = 2;
                            v1 = $this$sequence.yield((Object)this.$localBinariesHomePath.resolve(this.$subdir + "/ijent" + this.$extension), (Continuation)this);
                            if (v1 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Path> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final boolean tryGetIjentBinariesFromStaticDirectory$lambda$2(Path binary) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Checking existence of " + binary);
        }
        Intrinsics.checkNotNull((Object)binary);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(binary, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final Path gitRoot_delegate$lambda$4() {
        Object v0;
        block1: {
            Sequence sequence = SequencesKt.generateSequence((Object)Path.of(PathManager.getHomePath(), new String[0]), (Function1)gitRoot.2.1.INSTANCE);
            for (Object e : sequence) {
                Path path;
                Path path2 = (Path)e;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)path2.resolve(".git"), (String)"resolve(...)");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Path access$getBinaryFromPluginRoot(Path $receiver, EelPlatform targetPlatform) {
        return ProductionIjentExecFileProviderKt.getBinaryFromPluginRoot($receiver, targetPlatform);
    }

    public static final /* synthetic */ boolean access$askAboutPlugin(KMutableProperty0 mayShowDialog, String dialogMessage) {
        return ProductionIjentExecFileProviderKt.askAboutPlugin((KMutableProperty0<Boolean>)mayShowDialog, dialogMessage);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProductionIjentExecFileProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

