/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.tabs.target;

import com.intellij.ide.actions.searcheverywhere.ScopeChooserAction;
import com.intellij.ide.ui.colors.ColorId;
import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeSeparator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.searchEverywhere.SeSearchScopeData;
import com.intellij.platform.searchEverywhere.SeSearchScopesInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/searchEverywhere/frontend/tabs/target/SeScopeChooserActionProvider;", "", "scopesInfo", "Lcom/intellij/platform/searchEverywhere/SeSearchScopesInfo;", "onSelectedScopeChanged", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/intellij/platform/searchEverywhere/SeSearchScopesInfo;Lkotlin/jvm/functions/Function1;)V", "getScopesInfo", "()Lcom/intellij/platform/searchEverywhere/SeSearchScopesInfo;", "descriptors", "", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "value", "selectedScopeId", "getSelectedScopeId", "()Ljava/lang/String;", "setSelectedScopeId", "(Ljava/lang/String;)V", "getAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.searchEverywhere.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSeScopeChooserActionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeScopeChooserActionProvider.kt\ncom/intellij/platform/searchEverywhere/frontend/tabs/target/SeScopeChooserActionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1193#2,2:80\n1267#2,4:82\n*S KotlinDebug\n*F\n+ 1 SeScopeChooserActionProvider.kt\ncom/intellij/platform/searchEverywhere/frontend/tabs/target/SeScopeChooserActionProvider\n*L\n22#1:80,2\n22#1:82,4\n*E\n"})
public final class SeScopeChooserActionProvider {
    @NotNull
    private final SeSearchScopesInfo scopesInfo;
    @NotNull
    private final Function1<String, Unit> onSelectedScopeChanged;
    @NotNull
    private final Map<String, ScopeDescriptor> descriptors;
    @Nullable
    private String selectedScopeId;

    /*
     * WARNING - void declaration
     */
    public SeScopeChooserActionProvider(@NotNull SeSearchScopesInfo scopesInfo, @NotNull Function1<? super String, Unit> onSelectedScopeChanged) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)scopesInfo, (String)"scopesInfo");
        Intrinsics.checkNotNullParameter(onSelectedScopeChanged, (String)"onSelectedScopeChanged");
        this.scopesInfo = scopesInfo;
        this.onSelectedScopeChanged = onSelectedScopeChanged;
        Iterable iterable = this.scopesInfo.getScopes();
        SeScopeChooserActionProvider seScopeChooserActionProvider = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            ScopeDescriptor scopeDescriptor;
            Map map2 = destination$iv$iv;
            SeSearchScopeData it = (SeSearchScopeData)element$iv$iv;
            boolean bl = false;
            if (it.isSeparator()) {
                scopeDescriptor = (ScopeDescriptor)new ScopeSeparator(it.getName());
            } else {
                GlobalSearchScope globalSearchScope = new GlobalSearchScope(){

                    public boolean contains(VirtualFile file) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        throw new IllegalStateException("Should not be called");
                    }

                    public boolean isSearchInModuleContent(Module aModule) {
                        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
                        throw new IllegalStateException("Should not be called");
                    }

                    public boolean isSearchInLibraries() {
                        throw new IllegalStateException("Should not be called");
                    }
                };
                scopeDescriptor = new ScopeDescriptor(it, globalSearchScope){
                    final /* synthetic */ SeSearchScopeData $it;
                    {
                        this.$it = $it;
                        super((SearchScope)$super_call_param$1);
                    }

                    public Color getColor() {
                        ColorId colorId = this.$it.getColorId();
                        return colorId != null ? ColorIdKt.color((ColorId)colorId) : null;
                    }

                    public String getDisplayName() {
                        return this.$it.getName();
                    }

                    public Icon getIcon() {
                        IconId iconId = this.$it.getIconId();
                        return iconId != null ? IconIdKt.icon((IconId)iconId) : null;
                    }
                };
            }
            ScopeDescriptor descriptor2 = scopeDescriptor;
            Pair pair = TuplesKt.to((Object)it.getScopeId(), (Object)descriptor2);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        seScopeChooserActionProvider.descriptors = destination$iv$iv;
        this.selectedScopeId = this.scopesInfo.getSelectedScopeId();
    }

    @NotNull
    public final SeSearchScopesInfo getScopesInfo() {
        return this.scopesInfo;
    }

    @Nullable
    public final String getSelectedScopeId() {
        return this.selectedScopeId;
    }

    private final void setSelectedScopeId(String value) {
        this.selectedScopeId = value;
        this.onSelectedScopeChanged.invoke((Object)value);
    }

    @NotNull
    public final AnAction getAction() {
        return (AnAction)new ScopeChooserAction(this){
            private final boolean canToggleEverywhere;
            final /* synthetic */ SeScopeChooserActionProvider this$0;
            {
                this.this$0 = $receiver;
                this.canToggleEverywhere = $receiver.getScopesInfo().getCanToggleEverywhere();
            }

            public final boolean getCanToggleEverywhere() {
                return this.canToggleEverywhere;
            }

            public void onScopeSelected(ScopeDescriptor o) {
                block2: {
                    Object v0;
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        Iterable $this$firstOrNull$iv = this.this$0.getScopesInfo().getScopes();
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            SeSearchScopeData it = (SeSearchScopeData)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)o.getDisplayName())) continue;
                            v0 = element$iv;
                            break block1;
                        }
                        v0 = null;
                    }
                    SeSearchScopeData seSearchScopeData = v0;
                    if (seSearchScopeData == null) break block2;
                    SeSearchScopeData seSearchScopeData2 = seSearchScopeData;
                    SeScopeChooserActionProvider seScopeChooserActionProvider = this.this$0;
                    SeSearchScopeData it = seSearchScopeData2;
                    boolean bl = false;
                    SeScopeChooserActionProvider.access$setSelectedScopeId(seScopeChooserActionProvider, it.getScopeId());
                }
            }

            public ScopeDescriptor getSelectedScope() {
                String string;
                block3: {
                    block2: {
                        string = this.this$0.getSelectedScopeId();
                        if (string == null) break block2;
                        String string2 = string;
                        SeScopeChooserActionProvider seScopeChooserActionProvider = this.this$0;
                        String it = string2;
                        boolean bl = false;
                        ScopeDescriptor scopeDescriptor = (ScopeDescriptor)SeScopeChooserActionProvider.access$getDescriptors$p(seScopeChooserActionProvider).get(it);
                        string = scopeDescriptor;
                        if (scopeDescriptor != null) break block3;
                    }
                    string = new ScopeDescriptor((SearchScope)GlobalSearchScope.EMPTY_SCOPE);
                }
                return string;
            }

            protected void onProjectScopeToggled() {
                this.setEverywhere(!Intrinsics.areEqual((Object)this.this$0.getSelectedScopeId(), (Object)this.this$0.getScopesInfo().getEverywhereScopeId()));
            }

            protected boolean processScopes(Processor<? super ScopeDescriptor> processor) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter(processor, (String)"processor");
                    Iterable $this$all$iv = SeScopeChooserActionProvider.access$getDescriptors$p(this.this$0).values();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            ScopeDescriptor it = (ScopeDescriptor)element$iv;
                            boolean bl2 = false;
                            if (processor.process((Object)it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }

            public boolean isEverywhere() {
                return Intrinsics.areEqual((Object)this.this$0.getSelectedScopeId(), (Object)this.this$0.getScopesInfo().getEverywhereScopeId());
            }

            public void setEverywhere(boolean everywhere) {
                String string;
                if (everywhere) {
                    string = this.this$0.getScopesInfo().getEverywhereScopeId();
                } else {
                    string = this.this$0.getScopesInfo().getProjectScopeId();
                    if (string == null) {
                        return;
                    }
                }
                String targetScope = string;
                SeScopeChooserActionProvider.access$setSelectedScopeId(this.this$0, targetScope);
            }

            public boolean canToggleEverywhere() {
                if (!this.canToggleEverywhere) {
                    return false;
                }
                return !Intrinsics.areEqual((Object)this.this$0.getSelectedScopeId(), (Object)this.this$0.getScopesInfo().getEverywhereScopeId()) || !Intrinsics.areEqual((Object)this.this$0.getSelectedScopeId(), (Object)this.this$0.getScopesInfo().getProjectScopeId());
            }
        };
    }

    public static final /* synthetic */ Map access$getDescriptors$p(SeScopeChooserActionProvider $this) {
        return $this.descriptors;
    }

    public static final /* synthetic */ void access$setSelectedScopeId(SeScopeChooserActionProvider $this, String value) {
        $this.setSelectedScopeId(value);
    }
}

